/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.keybindbundles.util;

import com.matyrobbrt.keybindbundles.util.MappedSearchTree;
import com.matyrobbrt.keybindbundles.util.RegistryBackedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.SessionSearchTrees;
import net.minecraft.client.searchtree.IdSearchTree;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.CreativeModeTabSearchRegistry;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;

public class SearchTreeManager {
    private static SearchTree<ItemStack> basicSearch;

    public static void onPlayerJoin(ClientPlayerNetworkEvent.LoggingIn event) {
        if (basicSearch != null) {
            basicSearch = null;
        }
    }

    public static SearchTree<ItemStack> getSearchTree() {
        ClientPacketListener conn = Minecraft.getInstance().getConnection();
        if (conn != null) {
            SessionSearchTrees searchTrees = conn.searchTrees();
            RegistryAccess.Frozen registries = conn.registryAccess();
            FeatureFlagSet enabledFeatures = conn.enabledFeatures();
            if (CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)enabledFeatures, (Minecraft.getInstance().player.canUseGameMasterBlocks() && (Boolean)Minecraft.getInstance().options.operatorItemsTab().get() != false ? 1 : 0) != 0, (HolderLookup.Provider)registries)) {
                CreativeModeTabs.allTabs().stream().filter(CreativeModeTab::hasSearchBar).forEach(tab -> {
                    List list = List.copyOf(tab.getDisplayItems());
                    searchTrees.updateCreativeTooltips((HolderLookup.Provider)registries, list, Objects.requireNonNull(CreativeModeTabSearchRegistry.getNameSearchKey((CreativeModeTab)tab)));
                    searchTrees.updateCreativeTags(list, Objects.requireNonNull(CreativeModeTabSearchRegistry.getTagSearchKey((CreativeModeTab)tab)));
                });
            }
            return searchTrees.creativeNameSearch();
        }
        if (basicSearch == null) {
            basicSearch = new MappedSearchTree<Item, ItemStack>((SearchTree<Item>)new IdSearchTree(i -> Stream.of(i.builtInRegistryHolder().getKey().location()), new RegistryBackedList<Item>((Registry<Item>)BuiltInRegistries.ITEM, Item.class)), Item::getDefaultInstance);
        }
        return basicSearch;
    }
}

