/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.keybindbundles.render;

import com.matyrobbrt.keybindbundles.util.DelegatingConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;

public abstract class AutoCompleteEditBox<T>
extends EditBox {
    private final SearchTree<T> tree;
    private final Function<T, ResourceLocation> idGetter;
    private final int maxSuggestions;
    private final DelegatingConsumer<String> responders;
    private final AutoComplete autoComplete;

    public AutoCompleteEditBox(Font font, int x, int y, int width, int height, int itemHeight, int itemWidth, int maxSuggestions, Component message, SearchTree<T> tree, Function<T, ResourceLocation> idGetter) {
        super(font, x, y, width, height, message);
        this.tree = tree;
        this.idGetter = idGetter;
        this.maxSuggestions = maxSuggestions;
        this.responders = new DelegatingConsumer();
        this.setResponder(this.responders);
        this.autoComplete = new AutoComplete(x, y + 2 + height, width, itemHeight, itemWidth);
        this.addResponder(this.autoComplete);
        this.setFormatter((search, cursor) -> {
            if (search.indexOf(64) >= 0) {
                MutableComponent comp = Component.empty();
                String[] spl = search.split(" ");
                for (int i = 0; i < spl.length; ++i) {
                    if (i != 0) {
                        comp = comp.append((Component)Component.literal((String)" "));
                    }
                    comp = spl[i].startsWith("@") ? comp.append((Component)Component.literal((String)spl[i]).withStyle(ChatFormatting.GOLD)) : comp.append((Component)Component.literal((String)spl[i]));
                }
                int trailingAmount = 0;
                int lastIndex = search.length() - 1;
                while (search.charAt(lastIndex--) == ' ') {
                    ++trailingAmount;
                }
                if (trailingAmount > 0) {
                    comp = comp.append((Component)Component.literal((String)" ".repeat(trailingAmount)));
                }
                return comp.getVisualOrderText();
            }
            return Component.literal((String)search).getVisualOrderText();
        });
    }

    public void addResponder(Consumer<String> res) {
        this.responders.add(res);
    }

    public abstract void renderItem(GuiGraphics var1, int var2, int var3, T var4);

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY) && button == 1) {
            this.setValue("");
            this.autoComplete.accept("");
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int key, int scancode, int mods) {
        if (key == 257 && this.autoComplete().selectedIndex >= 0) {
            Object item = this.autoComplete.getSuggestion(this.autoComplete.offset + this.autoComplete.selectedIndex);
            if (item != null) {
                this.setValue(this.idGetter.apply(item).toString());
                return true;
            }
        } else {
            if (key == 264) {
                this.autoComplete.scrollDown();
                return true;
            }
            if (key == 265) {
                this.autoComplete.scrollUp();
                return true;
            }
        }
        return super.keyPressed(key, scancode, mods);
    }

    public AutoComplete autoComplete() {
        return this.autoComplete;
    }

    public class AutoComplete
    extends AbstractWidget
    implements Consumer<String> {
        private List<T> currentSuggestions;
        private final Vector2d lastMousePosition;
        private final int itemHeight;
        private final int itemWidth;
        private int selectedIndex;
        private int offset;
        private String prevSearch;

        public AutoComplete(int x, int y, int width, int itemHeight, int itemWidth) {
            super(x, y, width, itemHeight * AutoCompleteEditBox.this.maxSuggestions, (Component)Component.empty());
            this.currentSuggestions = List.of();
            this.lastMousePosition = new Vector2d(0.0, 0.0);
            this.itemHeight = itemHeight;
            this.itemWidth = itemWidth;
        }

        @Override
        public void accept(String search) {
            String namespaceFilter;
            if (Objects.equals(search, this.prevSearch) || search.isBlank()) {
                return;
            }
            this.prevSearch = search;
            this.offset = 0;
            this.selectedIndex = 0;
            ResourceLocation asRl = ResourceLocation.tryParse((String)search);
            if (search.indexOf(64) >= 0) {
                ArrayList<String> spl = new ArrayList<String>(Arrays.asList(search.split(" ")));
                String element = spl.stream().filter(s -> s.startsWith("@")).findFirst().orElseThrow();
                spl.remove(element);
                namespaceFilter = element.substring(1).toLowerCase(Locale.ROOT);
                search = String.join((CharSequence)" ", spl);
            } else {
                namespaceFilter = "";
            }
            ArrayList items = AutoCompleteEditBox.this.tree.search(search.trim().toLowerCase(Locale.ROOT));
            HashSet<ResourceLocation> distinctSet = new HashSet<ResourceLocation>();
            ArrayList newItems = new ArrayList(items.size());
            for (Object item : items) {
                if (!distinctSet.add(AutoCompleteEditBox.this.idGetter.apply(item))) continue;
                newItems.add(item);
            }
            items = newItems;
            this.currentSuggestions = asRl != null && items.stream().anyMatch(i -> AutoCompleteEditBox.this.idGetter.apply(i).equals((Object)asRl)) ? List.of() : (namespaceFilter.isBlank() ? items : items.stream().filter(i -> AutoCompleteEditBox.this.idGetter.apply(i).getNamespace().startsWith(namespaceFilter)).toList());
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (AutoCompleteEditBox.this.isFocused()) {
                this.updateHoveringState(mouseX, mouseY);
                for (int i = this.offset; i < Math.min(this.offset + this.shownSuggestions(), this.currentSuggestions.size()); ++i) {
                    int minX = this.getX() + 2;
                    int minY = this.getY() + this.itemHeight * (i - this.offset);
                    int maxY = minY + this.itemHeight;
                    Object item = this.currentSuggestions.get(i);
                    boolean hovered = i - this.offset == this.selectedIndex;
                    guiGraphics.fill(RenderType.guiOverlay(), this.getX(), minY, this.getX() + this.getWidth(), maxY, hovered ? -535752431 : -536870912);
                    AutoCompleteEditBox.this.renderItem(guiGraphics, minX, minY, item);
                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)AutoCompleteEditBox.this.idGetter.apply(item).toString()), minX + this.itemWidth + 2, minY + (this.itemHeight - 9) / 2, hovered ? ChatFormatting.YELLOW.getColor() : -1);
                }
            }
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        private void updateHoveringState(double x, double y) {
            if (!this.lastMousePosition.equals(x, y)) {
                this.selectedIndex = -1;
                if (this.isMouseOver(x, y)) {
                    int minY = this.getY();
                    for (int i = 0; i < this.shownSuggestions(); ++i) {
                        int maxY = minY + this.itemHeight;
                        if (x >= (double)this.getX() && x <= (double)(this.getX() + this.getWidth()) && y >= (double)minY && y < (double)maxY) {
                            this.selectedIndex = i;
                        }
                        minY = maxY;
                    }
                }
                this.lastMousePosition.set(x, y);
            }
        }

        @Nullable
        private T getSuggestion(int index) {
            return index >= this.currentSuggestions.size() ? null : (Object)this.currentSuggestions.get(index);
        }

        private int shownSuggestions() {
            return Math.min(AutoCompleteEditBox.this.maxSuggestions, this.currentSuggestions.size());
        }

        private void scrollUp() {
            this.offsetDisplay(this.selectedIndex - 1);
        }

        private void scrollDown() {
            this.offsetDisplay(this.selectedIndex + 1);
        }

        private void offsetDisplay(int offset) {
            int halfSuggestions;
            int currentItem = this.offset + (offset = Mth.clamp((int)offset, (int)0, (int)(this.shownSuggestions() - 1)));
            if (currentItem < this.offset + (halfSuggestions = Math.floorDiv(AutoCompleteEditBox.this.maxSuggestions, 2))) {
                this.offset = Math.max(currentItem - halfSuggestions, 0);
            } else if (currentItem > this.offset + halfSuggestions) {
                this.offset = Math.min(currentItem - halfSuggestions, Math.max(this.currentSuggestions.size() - AutoCompleteEditBox.this.maxSuggestions, 0));
            }
            this.selectedIndex = currentItem - this.offset;
        }

        public boolean mouseScrolled(double xpos, double ypos, double xDelta, double yDelta) {
            if (!this.isMouseOver(xpos, ypos)) {
                return false;
            }
            this.offset = (int)Mth.clamp((double)((double)this.offset - yDelta), (double)0.0, (double)Math.max(this.currentSuggestions.size() - AutoCompleteEditBox.this.maxSuggestions, 0));
            this.lastMousePosition.set(0.0);
            return true;
        }

        protected boolean clicked(double xpos, double ypos) {
            return super.clicked(xpos, ypos) && ypos < (double)(this.getY() + this.shownSuggestions() * this.itemHeight);
        }

        public boolean isMouseOver(double xpos, double ypos) {
            return super.isMouseOver(xpos, ypos) && ypos < (double)(this.getY() + this.shownSuggestions() * this.itemHeight);
        }

        public boolean mouseClicked(double mx, double my, int mb) {
            if (super.mouseClicked(mx, my, mb)) {
                Object item;
                this.updateHoveringState(mx, my);
                if (this.selectedIndex != -1 && (item = this.getSuggestion(this.offset + this.selectedIndex)) != null) {
                    AutoCompleteEditBox.this.setValue(AutoCompleteEditBox.this.idGetter.apply(item).toString());
                }
                return true;
            }
            return false;
        }
    }
}

