/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.keybindbundles;

import com.matyrobbrt.keybindbundles.KBClientConfig;
import com.matyrobbrt.keybindbundles.KeyBindBundleManager;
import com.matyrobbrt.keybindbundles.KeyMappingUtil;
import com.matyrobbrt.keybindbundles.PriorityKeyMapping;
import com.matyrobbrt.keybindbundles.render.KeybindSelectionOverlay;
import com.matyrobbrt.keybindbundles.util.SearchTreeManager;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.ArrayUtils;

@Mod(value="keybindbundles", dist={Dist.CLIENT})
public class ModKeyBindBundles {
    public static final String MOD_ID = "keybindbundles";
    public static final KeyMapping OPEN_RADIAL_MENU_MAPPING = new PriorityKeyMapping("key.keybindbundles.open_radial_menu", 342, "category.keybindbundles"){

        @Override
        public int compareTo(KeyMapping map) {
            return map instanceof KeyBindBundleManager.RadialKeyMapping ? -1 : super.compareTo(map);
        }
    };
    public static final KeyMapping OPEN_SCREEN_MAPPING = new PriorityKeyMapping("key.keybindbundles.open_screen", -1, "category.keybindbundles"){

        public void setDown(boolean value) {
            if (this.isDown() && !value && Minecraft.getInstance().screen == null) {
                super.setDown(false);
                Minecraft.getInstance().setScreen((Screen)new KeyBindsScreen(new Screen(this, (Component)Component.empty()){

                    protected void init() {
                        Minecraft.getInstance().setScreen(null);
                    }
                }, Minecraft.getInstance().options));
            } else {
                super.setDown(value);
            }
        }

        @Override
        public int compareTo(KeyMapping map) {
            return map instanceof KeyBindBundleManager.RadialKeyMapping ? -1 : super.compareTo(map);
        }
    };
    public static final int SPECIAL_KEY_CODE = 22745;
    public static final InputConstants.Key BUNDLE_TRIGGER_KEY = InputConstants.getKey((int)22745, (int)-1);

    public ModKeyBindBundles(ModContainer container, IEventBus bus) {
        bus.addListener(event -> event.enqueueWork(KeyBindBundleManager::load));
        bus.addListener(event -> event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"keybind_selection"), (LayeredDraw.Layer)KeybindSelectionOverlay.INSTANCE));
        bus.addListener(EventPriority.LOWEST, event -> {
            Minecraft.getInstance().options.keyMappings = (KeyMapping[])ArrayUtils.insert((int)0, (Object[])Minecraft.getInstance().options.keyMappings, (Object[])new KeyMapping[]{OPEN_RADIAL_MENU_MAPPING, OPEN_SCREEN_MAPPING});
        });
        NeoForge.EVENT_BUS.addListener(event -> {
            if (KeybindSelectionOverlay.INSTANCE.getDisplayedKeybind() != null && Minecraft.getInstance().screen == null && event.getButton() <= 1) {
                MouseHandler mouse = Minecraft.getInstance().mouseHandler;
                double mouseX = mouse.xpos() * (double)Minecraft.getInstance().getWindow().getGuiScaledWidth() / (double)Minecraft.getInstance().getWindow().getScreenWidth();
                double mouseY = mouse.ypos() * (double)Minecraft.getInstance().getWindow().getGuiScaledHeight() / (double)Minecraft.getInstance().getWindow().getScreenHeight();
                KeybindSelectionOverlay.INSTANCE.mouseClick(mouseX, mouseY, event.getButton(), event.getAction());
                event.setCanceled(true);
            }
        });
        NeoForge.EVENT_BUS.addListener(event -> KeyMappingUtil.restoreAll());
        NeoForge.EVENT_BUS.addListener(SearchTreeManager::onPlayerJoin);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)KBClientConfig.SPEC, "keybindbundles-client.toml");
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }
}

