/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen.preview;

import com.supermartijn642.core.gui.CursorType;
import com.supermartijn642.core.gui.CursorTypes;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.rechiseled.screen.ToggleRotationButton;
import com.supermartijn642.rechiseled.screen.preview.BlockCapture;
import com.supermartijn642.rechiseled.screen.preview.PreviewMode;
import com.supermartijn642.rechiseled.screen.preview.ScreenBlockRenderer;
import com.supermartijn642.rechiseled.screen.preview.ScreenItemRenderer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class EntryPreviewWidget
extends BaseWidget {
    private static final int ROTATION_TIME = 10000;
    private static boolean rotatePreview = true;
    private static float yaw = 0.35f;
    private static float pitch = 30.0f;
    private final Supplier<Item> item;
    private final Supplier<PreviewMode> previewMode;
    private long lastRotationTime;
    private boolean dragging = false;
    private int mouseStartX;
    private int mouseStartY;

    public EntryPreviewWidget(int x, int y, int width, int height, Supplier<Item> item, Supplier<PreviewMode> previewMode) {
        super(x, y, width, height);
        this.item = item;
        this.previewMode = previewMode;
        this.lastRotationTime = System.currentTimeMillis();
    }

    protected void addWidgets() {
        this.addWidget((Widget)new ToggleRotationButton(this.x, this.y, 11, 11, () -> rotatePreview, () -> {
            rotatePreview = !rotatePreview;
        }, () -> this.item.get() != null));
        super.addWidgets();
    }

    public Component getNarrationMessage() {
        return null;
    }

    public CursorType curser(int mouseX, int mouseY) {
        CursorType curser = super.curser(mouseX, mouseY);
        return curser == null && this.item.get() != null ? CursorTypes.resizeAll() : curser;
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        long now = System.currentTimeMillis();
        Item item = this.item.get();
        PreviewMode previewMode = this.previewMode.get();
        if (item != null) {
            if (this.dragging) {
                yaw += (float)((double)(mouseX - this.mouseStartX) / 100.0 * 360.0);
                pitch += (float)((double)(mouseY - this.mouseStartY) / 100.0 * 360.0);
                this.mouseStartX = mouseX;
                this.mouseStartY = mouseY;
            } else if (rotatePreview) {
                yaw += (float)(now - this.lastRotationTime) / 10000.0f * 360.0f;
            }
            if (item instanceof BlockItem) {
                int y;
                int x;
                Block block = ((BlockItem)item).getBlock();
                BlockCapture capture = new BlockCapture();
                int xRange = previewMode == PreviewMode.SINGLE ? 1 : 2;
                int yRange = previewMode == PreviewMode.PANEL ? 2 : 1;
                for (x = -xRange; x <= xRange; ++x) {
                    for (y = -yRange; y <= yRange; ++y) {
                        BlockPos pos = new BlockPos(x, y, 0);
                        if (Math.abs(x) == xRange || Math.abs(y) == yRange) {
                            capture.putBlock(pos, Blocks.COBBLESTONE.defaultBlockState());
                            continue;
                        }
                        capture.putBlock(pos, block);
                    }
                }
                capture.updateShapes();
                for (x = -xRange; x <= xRange; ++x) {
                    for (y = -yRange; y <= yRange; ++y) {
                        if (Math.abs(x) != xRange && Math.abs(y) != yRange) continue;
                        capture.putBlock(new BlockPos(x, y, 0), (BlockState)null);
                    }
                }
                ScreenBlockRenderer.drawBlock(context.poseStack(), capture, (double)this.x + (double)this.width / 2.0, (double)this.y + (double)this.height / 2.0, this.width, yaw, pitch, true);
            } else {
                ScreenItemRenderer.drawItem(context.poseStack(), item, (double)this.x + (double)this.width / 2.0, (double)this.y + (double)this.height / 2.0, this.width, yaw, pitch, true);
            }
        }
        this.lastRotationTime = now;
        super.render(context, mouseX, mouseY);
    }

    public boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (!(hasBeenHandled |= super.mousePressed(mouseX, mouseY, button, hasBeenHandled)) && mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height) {
            this.dragging = true;
            this.mouseStartX = mouseX;
            this.mouseStartY = mouseY;
            return true;
        }
        return hasBeenHandled;
    }

    public boolean mouseReleased(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, button, hasBeenHandled);
    }
}

