/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen.preview;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.rechiseled.screen.preview.BlockCapture;
import com.supermartijn642.rechiseled.util.EmptyChunkSource;
import com.supermartijn642.rechiseled.util.EmptyLevelTickAccess;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.LevelTickAccess;
import org.jetbrains.annotations.Nullable;

public class BlockCaptureLevel
implements LevelAccessor {
    private BlockCapture capture;
    private static final DifficultyInstance DIFFICULTY_INSTANCE = new DifficultyInstance(Difficulty.NORMAL, 0L, 0L, 0.0f);
    private static final RandomSource RANDOM_SOURCE = RandomSource.create();

    public void setCapture(BlockCapture capture) {
        this.capture = capture;
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        return null;
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.capture.getBlock(pos);
    }

    public FluidState getFluidState(BlockPos pos) {
        return this.capture.getBlock(pos).getFluidState();
    }

    public float getShade(Direction side, boolean bl) {
        return 1.0f;
    }

    public int getBrightness(LightLayer lightLayer, BlockPos pos) {
        return 15;
    }

    public LevelLightEngine getLightEngine() {
        return null;
    }

    @Nullable
    public ChunkAccess getChunk(int i, int j, ChunkStatus chunkStatus, boolean bl) {
        return null;
    }

    public long nextSubTickCount() {
        return 0L;
    }

    public LevelTickAccess<Block> getBlockTicks() {
        return EmptyLevelTickAccess.INSTANCE;
    }

    public LevelTickAccess<Fluid> getFluidTicks() {
        return EmptyLevelTickAccess.INSTANCE;
    }

    public LevelData getLevelData() {
        return ClientUtils.getWorld().getLevelData();
    }

    public DifficultyInstance getCurrentDifficultyAt(BlockPos blockPos) {
        return DIFFICULTY_INSTANCE;
    }

    @Nullable
    public MinecraftServer getServer() {
        return null;
    }

    public ChunkSource getChunkSource() {
        return EmptyChunkSource.INSTANCE;
    }

    public boolean hasChunk(int i, int j) {
        return false;
    }

    public RandomSource getRandom() {
        return RANDOM_SOURCE;
    }

    public void playSound(@Nullable Player player, BlockPos blockPos, SoundEvent soundEvent, SoundSource soundSource, float f, float g) {
    }

    public void addParticle(ParticleOptions particleOptions, double d, double e, double f, double g, double h, double i) {
    }

    public void levelEvent(@Nullable Player player, int i, BlockPos blockPos, int j) {
    }

    public void gameEvent(Holder<GameEvent> holder, Vec3 vec3, GameEvent.Context context) {
    }

    public int getHeight(Heightmap.Types types, int i, int j) {
        return 0;
    }

    public int getSkyDarken() {
        return 0;
    }

    public BiomeManager getBiomeManager() {
        return null;
    }

    public int getBlockTint(BlockPos pos, ColorResolver colorResolver) {
        Registry biomeRegistry = (Registry)BuiltInRegistries.REGISTRY.get(Registries.BIOME.location());
        return biomeRegistry == null ? 0 : colorResolver.getColor((Biome)biomeRegistry.get(Biomes.PLAINS), (double)pos.getX(), (double)pos.getZ());
    }

    public Holder<Biome> getUncachedNoiseBiome(int i, int j, int k) {
        return ClientUtils.getWorld().getUncachedNoiseBiome(0, 0, 0);
    }

    public boolean isClientSide() {
        return true;
    }

    public int getSeaLevel() {
        return 0;
    }

    public DimensionType dimensionType() {
        return ClientUtils.getWorld().dimensionType();
    }

    public int getHeight() {
        return Integer.MAX_VALUE;
    }

    public RegistryAccess registryAccess() {
        return ClientUtils.getWorld().registryAccess();
    }

    public FeatureFlagSet enabledFeatures() {
        return ClientUtils.getWorld().enabledFeatures();
    }

    public int getMinBuildHeight() {
        return -2147483647;
    }

    public WorldBorder getWorldBorder() {
        return ClientUtils.getWorld().getWorldBorder();
    }

    public List<Entity> getEntities(@Nullable Entity entity, AABB aABB, Predicate<? super Entity> predicate) {
        return List.of();
    }

    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> entityTypeTest, AABB aABB, Predicate<? super T> predicate) {
        return List.of();
    }

    public List<? extends Player> players() {
        return List.of();
    }

    public List<VoxelShape> getEntityCollisions(@Nullable Entity entity, AABB aABB) {
        return List.of();
    }

    public boolean isStateAtPosition(BlockPos pos, Predicate<BlockState> predicate) {
        return predicate.test(this.capture.getBlock(pos));
    }

    public boolean isFluidAtPosition(BlockPos blockPos, Predicate<FluidState> predicate) {
        return predicate.test(Fluids.EMPTY.defaultFluidState());
    }

    public boolean setBlock(BlockPos blockPos, BlockState blockState, int i, int j) {
        return false;
    }

    public boolean removeBlock(BlockPos blockPos, boolean bl) {
        return false;
    }

    public boolean destroyBlock(BlockPos blockPos, boolean bl, @Nullable Entity entity, int i) {
        return false;
    }
}

