/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingBlockShape;
import com.supermartijn642.rechiseled.screen.DisplayEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ShapeSelectionWidget
extends AbstractButtonWidget {
    private static final ResourceLocation SMALL_GREY_BUTTONS = Rechiseled.identifier("textures/screen/grey_buttons.png");
    private static final ResourceLocation BLOCK_ICON = Rechiseled.identifier("textures/screen/icon_1x1.png");
    private static final ResourceLocation STAIRS_ICON = Rechiseled.identifier("textures/screen/icon_stairs.png");
    private static final ResourceLocation SLAB_ICON = Rechiseled.identifier("textures/screen/icon_slab.png");
    private final ChiselingBlockShape shape;
    private final Supplier<DisplayEntry> currentEntry;
    private final ResourceLocation icon;

    public ShapeSelectionWidget(int x, int y, int width, int height, ChiselingBlockShape shape, Supplier<DisplayEntry> currentEntry, Runnable onPress) {
        super(x, y, width, height, onPress);
        this.shape = shape;
        this.currentEntry = currentEntry;
        this.icon = shape == ChiselingBlockShape.BLOCK ? BLOCK_ICON : (shape == ChiselingBlockShape.STAIRS ? STAIRS_ICON : SLAB_ICON);
    }

    protected boolean isClickable() {
        DisplayEntry display = this.currentEntry.get();
        return display != null && this.shape != display.shape() && display.entry().hasShape(this.shape);
    }

    public Component getNarrationMessage() {
        Holder message = new Holder();
        this.getTooltips(arg_0 -> ((Holder)message).set(arg_0));
        return (Component)message.get();
    }

    protected void getTooltips(Consumer<Component> tooltips) {
        DisplayEntry display = this.currentEntry.get();
        if (display != null && display.entry().hasShape(this.shape)) {
            tooltips.accept((Component)TextComponents.translation((String)"rechiseled.chiseling.select_shape", (Object[])new Object[]{TextComponents.fromTextComponent((Component)this.shape.translation()).color(ChatFormatting.GOLD).get()}).get());
        }
    }

    public void renderBackground(WidgetRenderContext context, int mouseX, int mouseY) {
        boolean canClick = this.isClickable();
        ScreenUtils.bindTexture((ResourceLocation)SMALL_GREY_BUTTONS);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)0.0f, (float)((float)(canClick ? (this.isFocused() ? 2 : 0) : 1) / 3.0f), (float)1.0f, (float)0.33333334f);
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        DisplayEntry display = this.currentEntry.get();
        if (display != null && display.entry().hasShape(this.shape)) {
            ScreenUtils.bindTexture((ResourceLocation)this.icon);
            ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)(this.x + 1), (float)(this.y + 2), (float)(this.width - 2), (float)(this.height - 4));
        }
    }
}

