/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.screen.DisplayEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ConnectingToggleWidget
extends AbstractButtonWidget {
    private static final ResourceLocation SMALL_GREY_BUTTONS = Rechiseled.identifier("textures/screen/grey_buttons.png");
    private static final ResourceLocation ICON_CONNECTED_ON = Rechiseled.identifier("textures/screen/icon_connecting_true.png");
    private static final ResourceLocation ICON_CONNECTED_OFF = Rechiseled.identifier("textures/screen/icon_connecting_false.png");
    private final Supplier<Boolean> connecting;
    private final Supplier<DisplayEntry> currentEntry;

    public ConnectingToggleWidget(int x, int y, int width, int height, Supplier<Boolean> connecting, Supplier<DisplayEntry> currentEntry, Runnable onPress) {
        super(x, y, width, height, onPress);
        this.connecting = connecting;
        this.currentEntry = currentEntry;
    }

    protected boolean isClickable() {
        DisplayEntry display = this.currentEntry.get();
        return display != null && display.hasItem(this.connecting.get() == false);
    }

    public Component getNarrationMessage() {
        Holder message = new Holder();
        this.getTooltips(arg_0 -> ((Holder)message).set(arg_0));
        return (Component)message.get();
    }

    protected void getTooltips(Consumer<Component> tooltips) {
        if (this.isClickable()) {
            tooltips.accept((Component)TextComponents.translation((String)"rechiseled.chiseling.connecting", (Object[])new Object[]{TextComponents.translation((String)("rechiseled.chiseling.connecting." + (this.connecting.get() != false ? "on" : "off"))).color(ChatFormatting.GOLD).get()}).get());
        }
    }

    public void renderBackground(WidgetRenderContext context, int mouseX, int mouseY) {
        boolean canSwitch = this.isClickable();
        ScreenUtils.bindTexture((ResourceLocation)SMALL_GREY_BUTTONS);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)0.0f, (float)((float)(canSwitch ? (this.isFocused() ? 2 : 0) : 1) / 3.0f), (float)1.0f, (float)0.33333334f);
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        ScreenUtils.bindTexture((ResourceLocation)(this.connecting.get() != false ? ICON_CONNECTED_ON : ICON_CONNECTED_OFF));
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)(this.x + 1), (float)(this.y + 2), (float)(this.width - 2), (float)(this.height - 4));
    }
}

