/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.BaseContainerType;
import com.supermartijn642.core.gui.CustomSlot;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingBlockShape;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingRecipeManager;
import com.supermartijn642.rechiseled.api.chiseling.ItemWithWorth;
import com.supermartijn642.rechiseled.api.chiseling.conversion.ChiselingConversionHelper;
import com.supermartijn642.rechiseled.api.chiseling.conversion.ConversionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class BaseChiselingContainer
extends BaseContainer {
    private final boolean isClient;
    public ChiselingRecipe currentRecipe = null;
    public ChiselingEntry currentEntry = null;
    public ChiselingBlockShape shape = null;
    public boolean connecting = false;

    public BaseChiselingContainer(BaseContainerType<?> type, Player player) {
        super(type, player);
        this.isClient = player.level().isClientSide();
        this.addSlots();
    }

    protected void addSlots(Player player) {
        boolean isClient = player.level().isClientSide();
        this.addSlot(CustomSlot.builder().position(181, 108).size(26).setter(this::setCurrentStack).getter(this::getCurrentStack).filter(stack -> ChiselingRecipeManager.get(isClient).getRecipeForItem((ItemLike)stack.getItem()) != null).onChange((oldStack, newStack) -> this.findRecipe()).build().getVanillaSlot());
        this.addPlayerSlots(50, 161);
    }

    public boolean stillValid(Player playerIn) {
        return !this.shouldBeClosed();
    }

    protected void findRecipe() {
        Item item = this.getCurrentStack().getItem();
        ChiselingRecipe recipe = ChiselingRecipeManager.get(this.isClient).getRecipeForItem((ItemLike)item);
        if (recipe != null && this.currentRecipe == recipe && this.currentRecipe.contains((ItemLike)item) && this.currentEntry.contains((ItemLike)item) && (this.connecting ? this.currentEntry.getConnectingItem(this.shape).item() == item : this.currentEntry.getRegularItem(this.shape).item() == item)) {
            return;
        }
        if (recipe != null) {
            this.currentRecipe = recipe;
            for (ChiselingEntry entry : this.currentRecipe.entries()) {
                if (!entry.contains((ItemLike)item)) continue;
                for (ChiselingBlockShape shape : ChiselingBlockShape.values()) {
                    if (this.connecting && entry.hasConnectingItem(shape) && entry.getConnectingItem(shape).item() == item) {
                        this.currentEntry = entry;
                        this.shape = shape;
                        return;
                    }
                    if (entry.hasRegularItem(shape) && entry.getRegularItem(shape).item() == item) {
                        this.currentEntry = entry;
                        this.shape = shape;
                        this.connecting = false;
                        return;
                    }
                    if (this.connecting || !entry.hasConnectingItem(shape) || entry.getConnectingItem(shape).item() != item) continue;
                    this.currentEntry = entry;
                    this.shape = shape;
                    this.connecting = true;
                    return;
                }
            }
        }
        this.currentRecipe = null;
        this.currentEntry = null;
        this.shape = null;
        this.connecting = false;
    }

    public void setCurrentEntry(int index, ChiselingBlockShape shape, boolean connecting) {
        if (this.currentRecipe == null || this.currentEntry == null || index >= this.currentRecipe.entries().size()) {
            return;
        }
        ChiselingEntry entry = this.currentRecipe.entries().get(index);
        if (connecting ? !entry.hasConnectingItem(shape) : !entry.hasRegularItem(shape)) {
            return;
        }
        ItemStack currentStack = this.getCurrentStack();
        ItemWithWorth currentWorth = this.currentRecipe.getWorth((ItemLike)currentStack.getItem());
        ItemWithWorth target = connecting ? entry.getConnectingItem(shape) : entry.getRegularItem(shape);
        ConversionResult conversion = ChiselingConversionHelper.convert(currentStack.getCount(), currentWorth, target);
        if (conversion.numberOfConversions() <= 0) {
            return;
        }
        this.currentEntry = entry;
        this.shape = shape;
        this.connecting = connecting;
        this.setCurrentStack(new ItemStack((ItemLike)target.item(), conversion.result()));
        if (conversion.leftover() > 0) {
            currentStack = currentStack.copyWithCount(conversion.leftover());
            int leftover = this.player.getInventory().addResource(currentStack);
            if (leftover > 0) {
                this.player.drop(currentStack.copyWithCount(leftover), true, true);
            }
        }
    }

    public void chiselAll(boolean includeAllShapes) {
        ItemWithWorth target;
        if (this.currentRecipe == null) {
            return;
        }
        ItemWithWorth itemWithWorth = target = this.connecting ? this.currentEntry.getConnectingItem(this.shape) : this.currentEntry.getRegularItem(this.shape);
        assert (target != null);
        Item targetItem = target.item();
        int availableSpace = 0;
        Inventory inventory = this.player.getInventory();
        for (int index = 0; index < inventory.getContainerSize(); ++index) {
            ItemStack stack = inventory.getItem(index);
            if (!stack.isEmpty() && stack.getItem() != targetItem) continue;
            availableSpace += Math.max(0, targetItem.getDefaultMaxStackSize() - stack.getCount());
        }
        int overflow = 0;
        for (int index = 0; index < inventory.getContainerSize(); ++index) {
            boolean canConvertEntireStack;
            ItemStack stack = inventory.getItem(index);
            if (stack.isEmpty() || stack.getItem() == targetItem || !this.currentRecipe.contains((ItemLike)stack.getItem()) || !stack.getComponentsPatch().isEmpty()) continue;
            ChiselingEntry stackEntry = null;
            for (ChiselingEntry chiselingEntry : this.currentRecipe.entries()) {
                if (!chiselingEntry.contains((ItemLike)stack.getItem())) continue;
                stackEntry = chiselingEntry;
            }
            assert (stackEntry != null);
            ChiselingBlockShape stackShape = null;
            for (ChiselingBlockShape shape : ChiselingBlockShape.values()) {
                if ((!stackEntry.hasRegularItem(shape) || stackEntry.getRegularItem(shape).item() != stack.getItem()) && (!stackEntry.hasConnectingItem(shape) || stackEntry.getConnectingItem(shape).item() != stack.getItem())) continue;
                stackShape = shape;
            }
            assert (stackShape != null);
            if (!includeAllShapes && stackShape != this.shape) continue;
            ItemWithWorth itemWithWorth2 = this.currentRecipe.getWorth((ItemLike)stack.getItem());
            ConversionResult conversion = ChiselingConversionHelper.convert(stack.getCount(), itemWithWorth2, target, availableSpace + targetItem.getDefaultMaxStackSize());
            boolean bl = canConvertEntireStack = conversion.leftover() <= 0;
            if (!canConvertEntireStack) {
                conversion = ChiselingConversionHelper.convert(stack.getCount(), itemWithWorth2, target, availableSpace + targetItem.getDefaultMaxStackSize());
            }
            if (conversion.numberOfConversions() <= 0) continue;
            if (canConvertEntireStack) {
                int newStackSize = Math.min(conversion.result(), targetItem.getDefaultMaxStackSize());
                inventory.setItem(index, new ItemStack((ItemLike)targetItem, newStackSize));
                overflow += conversion.result() - newStackSize;
                availableSpace -= conversion.result() - newStackSize;
                continue;
            }
            inventory.setItem(index, stack.copyWithCount(conversion.leftover()));
            overflow += conversion.result();
            availableSpace -= conversion.result();
        }
        if (overflow > 0) {
            int remaining;
            while ((remaining = inventory.addResource(new ItemStack((ItemLike)targetItem, overflow))) != overflow && (overflow = remaining) > 0) {
            }
            if (overflow > 0) {
                Rechiseled.LOGGER.error("Failed to insert stacks into player inventory despite the fact there should be sufficient space!");
                this.player.drop(new ItemStack((ItemLike)targetItem, overflow), true, true);
            }
        }
    }

    public abstract ItemStack getCurrentStack();

    public abstract void setCurrentStack(ItemStack var1);

    public abstract boolean shouldBeClosed();

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack stack = this.getSlot(index).getItem();
        if (stack.isEmpty()) {
            return stack;
        }
        if (index == 0 ? !this.moveItemStackTo(stack, 1, this.slots.size(), true) : !this.moveItemStackTo(stack, 0, 1, true)) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            ((Slot)this.slots.get(index)).set(stack);
        }
        return stack;
    }

    protected boolean moveItemStackTo(ItemStack stack, int minSlot, int maxSlot, boolean reversed) {
        ItemStack slotStack;
        Slot slot;
        boolean changed = false;
        int index = minSlot;
        if (reversed) {
            index = maxSlot - 1;
        }
        if (stack.isStackable()) {
            while (!stack.isEmpty() && !(!reversed ? index >= maxSlot : index < minSlot)) {
                slot = (Slot)this.slots.get(index);
                slotStack = slot.getItem();
                if (!slotStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack)) {
                    int maxSize;
                    int sumCount = slotStack.getCount() + stack.getCount();
                    if (sumCount <= (maxSize = Math.min(slot.getMaxStackSize(), stack.getMaxStackSize()))) {
                        stack.setCount(0);
                        slotStack.setCount(sumCount);
                        slot.set(slotStack);
                        changed = true;
                    } else if (slotStack.getCount() < maxSize) {
                        stack.shrink(maxSize - slotStack.getCount());
                        slotStack.setCount(maxSize);
                        slot.set(slotStack);
                        changed = true;
                    }
                }
                if (reversed) {
                    --index;
                    continue;
                }
                ++index;
            }
        }
        if (!stack.isEmpty()) {
            index = reversed ? maxSlot - 1 : minSlot;
            while (!(!reversed ? index >= maxSlot : index < minSlot)) {
                slot = (Slot)this.slots.get(index);
                slotStack = slot.getItem();
                if (slotStack.isEmpty() && slot.mayPlace(stack)) {
                    if (stack.getCount() > slot.getMaxStackSize()) {
                        slot.set(stack.split(slot.getMaxStackSize()));
                    } else {
                        slot.set(stack.split(stack.getCount()));
                    }
                    changed = true;
                    break;
                }
                if (reversed) {
                    --index;
                    continue;
                }
                ++index;
            }
        }
        return changed;
    }
}

