/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.registration;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.rechiseled.api.blocks.BlockSpecification;
import com.supermartijn642.rechiseled.api.blocks.RechiseledCommonBlockBuilder;
import com.supermartijn642.rechiseled.registration.RechiseledBlockBuilderImpl;
import com.supermartijn642.rechiseled.registration.RechiseledRegistrationImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public abstract class RechiseledCommonBlockBuilderImpl<T extends RechiseledCommonBlockBuilder<?>>
implements RechiseledCommonBlockBuilder<T> {
    private final RechiseledCommonBlockBuilderImpl<?> parent;
    protected final RechiseledRegistrationImpl registration;
    protected final String identifier;
    private final String translationSuffix;
    private Supplier<BlockProperties> properties;
    private Consumer<BlockProperties> propertiesConsumer;
    protected boolean hasRegularVariant = true;
    protected boolean hasConnectingVariant = true;
    private Supplier<Block> customRegularVariant;
    private Supplier<Block> customConnectingVariant;
    private Set<CreativeModeTab> itemGroups;
    private final Set<ResourceLocation> blockTags = new HashSet<ResourceLocation>();
    private final Set<ResourceLocation> itemTags = new HashSet<ResourceLocation>();
    private Supplier<Block> miningTagsFromBlock;
    private String translation;
    private boolean completed;
    protected Supplier<Block> regularBlock;
    protected Supplier<Block> connectingBlock;
    protected Supplier<BlockItem> regularItem;
    protected Supplier<BlockItem> connectingItem;

    protected RechiseledCommonBlockBuilderImpl(RechiseledRegistrationImpl registration, String identifier) {
        this.parent = this;
        this.registration = registration;
        this.identifier = identifier;
        this.translationSuffix = null;
    }

    protected RechiseledCommonBlockBuilderImpl(RechiseledBlockBuilderImpl parent, String identifierSuffix, String translationSuffix) {
        this.parent = parent;
        this.registration = this.parent.registration;
        this.identifier = this.parent.identifier + identifierSuffix;
        this.translationSuffix = translationSuffix;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean hasRegularVariant() {
        return this.hasRegularVariant;
    }

    public boolean hasConnectingVariant() {
        return this.hasConnectingVariant;
    }

    public Block getRegularBlock() {
        return this.customRegularVariant != null ? this.customRegularVariant.get() : (this.hasRegularVariant ? this.regularBlock.get() : null);
    }

    public Block getConnectingBlock() {
        return this.customConnectingVariant != null ? this.customConnectingVariant.get() : (this.hasConnectingVariant ? this.connectingBlock.get() : null);
    }

    public Set<ResourceLocation> getBlockTags() {
        return Collections.unmodifiableSet(this.blockTags);
    }

    public Set<ResourceLocation> getItemTags() {
        return Collections.unmodifiableSet(this.itemTags);
    }

    public Block getMiningTagsBlock() {
        return this.miningTagsFromBlock == null ? null : this.miningTagsFromBlock.get();
    }

    public String getTranslation() {
        return this.translation;
    }

    protected void complete() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        if (this.properties == null) {
            this.properties = this.parent.properties;
            this.propertiesConsumer = this.propertiesConsumer == null ? this.parent.propertiesConsumer : this.parent.propertiesConsumer.andThen(this.propertiesConsumer);
        }
        this.hasRegularVariant = this.parent.hasRegularVariant;
        this.hasConnectingVariant = this.parent.hasConnectingVariant;
        if (!this.parent.hasRegularVariant && this.parent.customRegularVariant == null) {
            this.customRegularVariant = null;
        }
        if (!this.parent.hasConnectingVariant && this.parent.customConnectingVariant == null) {
            this.customConnectingVariant = null;
        }
        if (this.itemGroups == null) {
            this.itemGroups = this.parent.itemGroups;
        }
        this.blockTags.addAll(this.parent.blockTags);
        this.itemTags.addAll(this.parent.itemTags);
        if (this.miningTagsFromBlock == null) {
            this.miningTagsFromBlock = this.parent.miningTagsFromBlock;
        }
        if (this.translation == null && this.parent.translation != null) {
            this.translation = this.parent.translation + this.translationSuffix;
        }
    }

    protected void checkMutable() {
        if (this.completed) {
            throw new RuntimeException("Builder has already been built!");
        }
    }

    void createBlocks(BlockSpecification specification) {
        RegistrationHandler handler = RegistrationHandler.get((String)this.registration.getModid());
        if (this.properties == null && this.propertiesConsumer == null) {
            throw new RuntimeException("Builder for '" + this.registration.getModid() + ":" + this.identifier + "' is missing block properties!");
        }
        Holder<BlockProperties> propertiesHolder = new Holder<BlockProperties>(){

            public BlockProperties get() {
                BlockProperties value = (BlockProperties)super.get();
                if (value == null) {
                    BlockProperties blockProperties = value = RechiseledCommonBlockBuilderImpl.this.properties == null ? BlockProperties.create() : RechiseledCommonBlockBuilderImpl.this.properties.get();
                    if (RechiseledCommonBlockBuilderImpl.this.propertiesConsumer != null) {
                        RechiseledCommonBlockBuilderImpl.this.propertiesConsumer.accept(value);
                    }
                    this.set(value);
                }
                return value;
            }
        };
        Holder regularBlockHolder = new Holder();
        Holder connectingBlockHolder = new Holder();
        ResourceLocation blockIdentifier = ResourceLocation.fromNamespaceAndPath((String)this.registration.getModid(), (String)this.identifier);
        if (this.hasRegularVariant && this.parent.hasRegularVariant) {
            handler.registerBlock(this.identifier, () -> this.lambda$createBlocks$0(regularBlockHolder, specification, (Holder)propertiesHolder, blockIdentifier));
        }
        if (this.hasConnectingVariant && this.parent.hasConnectingVariant) {
            handler.registerBlock(this.identifier + "_connecting", () -> this.lambda$createBlocks$1(connectingBlockHolder, specification, (Holder)propertiesHolder, blockIdentifier));
        }
        Holder regularItemHolder = new Holder();
        Holder connectingItemHolder = new Holder();
        ItemProperties itemProperties = ItemProperties.create();
        if (this.itemGroups != null) {
            this.itemGroups.forEach(arg_0 -> ((ItemProperties)itemProperties).group(arg_0));
        }
        if (this.hasRegularVariant) {
            handler.registerItem(this.identifier, () -> {
                regularItemHolder.set((Object)new BaseBlockItem((Block)regularBlockHolder.get(), itemProperties));
                return (Item)regularItemHolder.get();
            });
        }
        if (this.hasConnectingVariant) {
            handler.registerItem(this.identifier + "_connecting", () -> {
                connectingItemHolder.set((Object)new BaseBlockItem(this, (Block)connectingBlockHolder.get(), itemProperties){

                    protected void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
                        super.appendItemInformation(stack, info, advanced);
                        info.accept((Component)TextComponents.translation((String)"rechiseled.tooltip.connecting").color(ChatFormatting.GRAY).get());
                    }
                });
                return (Item)connectingItemHolder.get();
            });
        }
        this.regularBlock = () -> ((Holder)regularBlockHolder).get();
        this.connectingBlock = () -> ((Holder)connectingBlockHolder).get();
        this.regularItem = () -> ((Holder)regularItemHolder).get();
        this.connectingItem = () -> ((Holder)connectingItemHolder).get();
        if ((specification == BlockSpecification.GLASS || specification == BlockSpecification.GLASS_PILLAR) && CommonUtils.getEnvironmentSide().isClient()) {
            if (this.hasRegularVariant) {
                ClientRegistrationHandler.get((String)this.registration.getModid()).registerBlockModelTranslucentRenderType(this.regularBlock);
            }
            if (this.hasConnectingVariant) {
                ClientRegistrationHandler.get((String)this.registration.getModid()).registerBlockModelTranslucentRenderType(this.connectingBlock);
            }
        }
    }

    protected abstract Block createBlock(BlockSpecification var1, Block var2, boolean var3, BlockProperties var4, ResourceLocation var5);

    protected abstract void setBlockReferences(Block var1, Block var2, Block var3, Block var4, Block var5, Block var6);

    @Override
    public T properties(BlockProperties properties) {
        this.checkMutable();
        this.properties = () -> properties;
        return this.self();
    }

    @Override
    public T properties(Supplier<BlockProperties> properties) {
        this.checkMutable();
        this.properties = properties;
        return this.self();
    }

    @Override
    public T properties(Consumer<BlockProperties> configurer) {
        this.checkMutable();
        this.propertiesConsumer = configurer;
        return this.self();
    }

    @Override
    public T itemGroups(CreativeModeTab group, CreativeModeTab ... groups) {
        this.checkMutable();
        ArrayList<CreativeModeTab> tabs = new ArrayList<CreativeModeTab>(Arrays.asList(groups));
        tabs.add(group);
        this.itemGroups = Set.copyOf(tabs);
        return this.self();
    }

    @Override
    public T noItemGroups() {
        this.itemGroups = null;
        return this.self();
    }

    @Override
    public T noRegularVariant() {
        this.checkMutable();
        this.hasRegularVariant = false;
        return this.self();
    }

    @Override
    public T noConnectingVariant() {
        this.checkMutable();
        this.hasConnectingVariant = false;
        return this.self();
    }

    @Override
    public T regularVariant(Supplier<Block> block) {
        this.noRegularVariant();
        this.customRegularVariant = block;
        return this.self();
    }

    @Override
    public T connectingVariant(Supplier<Block> block) {
        this.noConnectingVariant();
        this.customConnectingVariant = block;
        return this.self();
    }

    @Override
    public T blockTag(ResourceLocation identifier) {
        this.checkMutable();
        this.blockTags.add(identifier);
        return this.self();
    }

    @Override
    public T itemTag(ResourceLocation identifier) {
        this.checkMutable();
        this.itemTags.add(identifier);
        return this.self();
    }

    @Override
    public T miningTagsFrom(Supplier<Block> block) {
        this.checkMutable();
        this.miningTagsFromBlock = block;
        return this.self();
    }

    @Override
    public T translation(String translation) {
        this.checkMutable();
        this.translation = translation;
        return this.self();
    }

    private T self() {
        return (T)this;
    }

    private /* synthetic */ Block lambda$createBlocks$1(Holder connectingBlockHolder, BlockSpecification specification, Holder propertiesHolder, ResourceLocation blockIdentifier) {
        Block parent = this.parent == this ? null : this.parent.getConnectingBlock();
        connectingBlockHolder.set((Object)this.createBlock(specification, parent, true, (BlockProperties)propertiesHolder.get(), blockIdentifier.withSuffix("_connecting")));
        return (Block)connectingBlockHolder.get();
    }

    private /* synthetic */ Block lambda$createBlocks$0(Holder regularBlockHolder, BlockSpecification specification, Holder propertiesHolder, ResourceLocation blockIdentifier) {
        Block parent = this.parent == this ? null : this.parent.getRegularBlock();
        regularBlockHolder.set((Object)this.createBlock(specification, parent, false, (BlockProperties)propertiesHolder.get(), blockIdentifier));
        return (Block)regularBlockHolder.get();
    }
}

