/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.packet;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.rechiseled.Rechiseled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PacketChiselBlocks
implements BasePacket {
    private BlockPos pos;
    private Direction side;
    private boolean isSneaking;

    public PacketChiselBlocks(BlockPos pos, Direction side, boolean isSneaking) {
        this.pos = pos;
        this.side = side;
        this.isSneaking = isSneaking;
    }

    public PacketChiselBlocks() {
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeEnum((Enum)this.side);
        buffer.writeBoolean(this.isSneaking);
    }

    public void read(FriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.side = (Direction)buffer.readEnum(Direction.class);
        this.isSneaking = buffer.readBoolean();
    }

    public void handle(PacketContext context) {
        Player player = context.getPlayer();
        if (player.getEyePosition().distanceToSqr((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) > 100.0) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() == Rechiseled.chisel) {
            Rechiseled.chisel.leftClickBlock(player, stack, this.pos, this.side, this.isSneaking);
        }
    }
}

