/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.blocks;

import com.supermartijn642.core.util.Pair;
import com.supermartijn642.rechiseled.blocks.RechiseledGlassBlock;
import com.supermartijn642.rechiseled.blocks.RechiseledStairBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RechiseledGlassStairBlock
extends RechiseledStairBlock {
    private Block block;
    private Block slab;
    private boolean haveBlockAndSlabBeenSet = false;
    private volatile Map<Pair<BlockState, BlockState>, Boolean[]> shouldHideFaceCache = null;

    public RechiseledGlassStairBlock(boolean connecting, BlockState parent, BlockBehaviour.Properties properties) {
        super(connecting, parent, properties.noOcclusion().isSuffocating(Blocks::never).isViewBlocking(Blocks::never));
    }

    public void setBlockAndSlab(Block block, Block slab) {
        if (this.haveBlockAndSlabBeenSet) {
            throw new IllegalStateException("Already set block and slab!");
        }
        this.haveBlockAndSlabBeenSet = true;
        this.block = block;
        this.slab = slab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean skipRendering(BlockState state, BlockState otherState, Direction side) {
        if (!this.haveBlockAndSlabBeenSet) {
            throw new IllegalStateException("Block and slab have not been set!");
        }
        if (!(otherState.is((Block)this) || otherState.is(this.block) || otherState.is(this.slab))) {
            return false;
        }
        if (this.shouldHideFaceCache == null) {
            RechiseledGlassStairBlock rechiseledGlassStairBlock = this;
            synchronized (rechiseledGlassStairBlock) {
                if (this.shouldHideFaceCache == null) {
                    this.shouldHideFaceCache = new HashMap<Pair<BlockState, BlockState>, Boolean[]>();
                }
            }
        }
        return RechiseledGlassBlock.calculateShouldHideFace(state, otherState, side, this.shouldHideFaceCache);
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }
}

