/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.blocks;

import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.rechiseled.blocks.RechiseledGlassBlock;
import com.supermartijn642.rechiseled.blocks.RechiseledPillarBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RechiseledGlassPillarBlock
extends RechiseledPillarBlock {
    private Block stairs;
    private Block slab;
    private boolean haveStairsAndSlabBeenSet = false;
    private volatile Map<Pair<BlockState, BlockState>, Boolean[]> shouldHideFaceCache = null;

    public RechiseledGlassPillarBlock(boolean connecting, BlockProperties properties) {
        super(connecting, properties.noOcclusion().isSuffocating(Blocks::never));
    }

    public RechiseledGlassPillarBlock(boolean connecting, BlockBehaviour.Properties properties) {
        super(connecting, properties.noOcclusion().isSuffocating(Blocks::never));
    }

    public void setStairsAndSlab(Block stairs, Block slab) {
        if (this.haveStairsAndSlabBeenSet) {
            throw new IllegalStateException("Already set stairs and slab!");
        }
        this.haveStairsAndSlabBeenSet = true;
        this.stairs = stairs;
        this.slab = slab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean skipRendering(BlockState state, BlockState otherState, Direction side) {
        if (state.getValue((Property)AXIS_PROPERTY) != Direction.Axis.Y) {
            return state == otherState;
        }
        if (!(otherState.is((Block)this) || otherState.is(this.stairs) || otherState.is(this.slab))) {
            return false;
        }
        if (this.shouldHideFaceCache == null) {
            RechiseledGlassPillarBlock rechiseledGlassPillarBlock = this;
            synchronized (rechiseledGlassPillarBlock) {
                if (this.shouldHideFaceCache == null) {
                    this.shouldHideFaceCache = new HashMap<Pair<BlockState, BlockState>, Boolean[]>();
                }
            }
        }
        return RechiseledGlassBlock.calculateShouldHideFace(state, otherState, side, this.shouldHideFaceCache);
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }
}

