/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.api.chiseling.conversion;

import com.supermartijn642.rechiseled.api.chiseling.ItemWithWorth;
import com.supermartijn642.rechiseled.api.chiseling.conversion.ConversionResult;
import com.supermartijn642.rechiseled.chiseling.ConversionResultImpl;

public final class ChiselingConversionHelper {
    public static float getConversionFactor(ItemWithWorth from, ItemWithWorth to) {
        return from.worth() / to.worth();
    }

    public static ConversionResult convert(int amount, ItemWithWorth from, ItemWithWorth to, int maxResultAmount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount must be positive!");
        }
        if (maxResultAmount < 0) {
            return new ConversionResultImpl(0, amount, 0);
        }
        double conversionFactor = from.worth() / to.worth();
        int conversions = Math.min((int)Math.floor((double)maxResultAmount / conversionFactor), (int)Math.round(Math.floor(conversionFactor * (double)amount) / conversionFactor));
        int leftover = amount - conversions;
        int result = (int)Math.round((double)conversions * conversionFactor);
        return new ConversionResultImpl(conversions, leftover, result);
    }

    public static ConversionResult convert(int amount, ItemWithWorth from, ItemWithWorth to) {
        return ChiselingConversionHelper.convert(amount, from, to, Integer.MAX_VALUE);
    }
}

