/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.api;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingBlockShape;
import com.supermartijn642.rechiseled.api.chiseling.ItemWithWorth;
import com.supermartijn642.rechiseled.api.chiseling.data.ChiselingEntryBuilder;
import com.supermartijn642.rechiseled.chiseling.data.ChiselingEntryBuilderImpl;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public abstract class ChiselingRecipeProvider
implements DataProvider {
    private final String modid;
    private final DataGenerator generator;
    private final ExistingFileHelper existingFileHelper;
    private final Map<ResourceLocation, ChiselingRecipeBuilder> recipes = new HashMap<ResourceLocation, ChiselingRecipeBuilder>();

    public ChiselingRecipeProvider(String modid, DataGenerator generator, ExistingFileHelper existingFileHelper) {
        this.modid = modid;
        this.generator = generator;
        this.existingFileHelper = existingFileHelper;
    }

    public String getName() {
        return "Chiseling Recipes: " + this.modid;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        this.buildRecipes();
        Path path = this.generator.getPackOutput().getOutputFolder();
        ArrayList<CompletableFuture> tasks = new ArrayList<CompletableFuture>();
        for (Map.Entry<ResourceLocation, ChiselingRecipeBuilder> entry : this.recipes.entrySet()) {
            ResourceLocation recipeName = entry.getKey();
            ChiselingRecipeBuilder recipe = entry.getValue();
            JsonObject json = ChiselingRecipeProvider.serializeRecipe(recipeName, recipe);
            Path recipePath = path.resolve("data/" + recipeName.getNamespace() + "/chiseling_recipes/" + recipeName.getPath() + ".json");
            tasks.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)recipePath));
        }
        return CompletableFuture.allOf((CompletableFuture[])tasks.toArray(CompletableFuture[]::new));
    }

    private static JsonObject serializeRecipe(ResourceLocation recipeName, ChiselingRecipeBuilder recipe) {
        JsonObject json = new JsonObject();
        json.addProperty("type", Rechiseled.identifier("chiseling").toString());
        json.addProperty("overwrite", Boolean.valueOf(recipe.overwrite));
        HashSet items = Sets.newHashSet();
        JsonArray entries = new JsonArray();
        for (ChiselingEntryBuilderImpl entry : recipe.entries) {
            if (entry.items.isEmpty() && entry.connectingItems.isEmpty()) {
                throw new IllegalStateException("Entry for recipe '" + String.valueOf(recipeName) + "' has no items!");
            }
            if (entry.items.containsKey((Object)ChiselingBlockShape.BLOCK) && entry.items.size() == 1 && entry.items.get((Object)ChiselingBlockShape.BLOCK).worth() == 1.0f && entry.connectingItems.isEmpty() && !entry.optional) {
                ItemWithWorth item = entry.items.get((Object)ChiselingBlockShape.BLOCK);
                if (!items.add(item.item())) {
                    throw new IllegalStateException("Duplicate item '" + String.valueOf(Registries.ITEMS.getIdentifier((Object)item.item())) + "' in chiseling recipe '" + String.valueOf(recipeName) + "'");
                }
                entries.add(Registries.ITEMS.getIdentifier((Object)item.item()).toString());
                continue;
            }
            JsonObject object = new JsonObject();
            if (entry.items.containsKey((Object)ChiselingBlockShape.BLOCK)) {
                ChiselingRecipeProvider.serializeItem(object, "block", entry.items.get((Object)ChiselingBlockShape.BLOCK), items, recipeName);
            }
            if (entry.items.containsKey((Object)ChiselingBlockShape.STAIRS)) {
                ChiselingRecipeProvider.serializeItem(object, "stairs", entry.items.get((Object)ChiselingBlockShape.STAIRS), items, recipeName);
            }
            if (entry.items.containsKey((Object)ChiselingBlockShape.SLAB)) {
                ChiselingRecipeProvider.serializeItem(object, "slab", entry.items.get((Object)ChiselingBlockShape.SLAB), items, recipeName);
            }
            if (entry.connectingItems.containsKey((Object)ChiselingBlockShape.BLOCK)) {
                ChiselingRecipeProvider.serializeItem(object, "connecting_block", entry.connectingItems.get((Object)ChiselingBlockShape.BLOCK), items, recipeName);
            }
            if (entry.connectingItems.containsKey((Object)ChiselingBlockShape.STAIRS)) {
                ChiselingRecipeProvider.serializeItem(object, "connecting_stairs", entry.connectingItems.get((Object)ChiselingBlockShape.STAIRS), items, recipeName);
            }
            if (entry.connectingItems.containsKey((Object)ChiselingBlockShape.SLAB)) {
                ChiselingRecipeProvider.serializeItem(object, "connecting_slab", entry.connectingItems.get((Object)ChiselingBlockShape.SLAB), items, recipeName);
            }
            if (entry.optional) {
                object.addProperty("optional", Boolean.valueOf(true));
            }
            entries.add((JsonElement)object);
        }
        json.add("entries", (JsonElement)entries);
        return json;
    }

    private static void serializeItem(JsonObject json, String key, ItemWithWorth item, Set<Item> items, ResourceLocation recipeName) {
        if (!items.add(item.item())) {
            throw new IllegalStateException("Duplicate item '" + String.valueOf(Registries.ITEMS.getIdentifier((Object)item.item())) + "' in chiseling recipe '" + String.valueOf(recipeName) + "'");
        }
        json.addProperty(key, Registries.ITEMS.getIdentifier((Object)item.item()).toString());
        if (item.worth() != 1.0f) {
            json.addProperty(key + "_worth", (Number)Float.valueOf(item.worth()));
        }
    }

    private void trackRecipe(ResourceLocation recipe) {
        this.existingFileHelper.trackGenerated(recipe, PackType.SERVER_DATA, ".json", "chiseling_recipes");
    }

    protected abstract void buildRecipes();

    protected ChiselingRecipeBuilder beginRecipe(String recipeName) {
        this.trackRecipe(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)recipeName));
        return this.recipes.computeIfAbsent(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)recipeName), s -> new ChiselingRecipeBuilder());
    }

    protected ChiselingRecipeBuilder beginRecipe(ResourceLocation recipe) {
        this.trackRecipe(recipe);
        return this.recipes.computeIfAbsent(recipe, s -> new ChiselingRecipeBuilder());
    }

    public static class ChiselingRecipeBuilder {
        private final List<ChiselingEntryBuilderImpl> entries = new LinkedList<ChiselingEntryBuilderImpl>();
        private boolean overwrite = false;

        private ChiselingRecipeBuilder() {
        }

        public void overwrite(boolean overwrite) {
            this.overwrite = overwrite;
        }

        public ChiselingEntryBuilder entry() {
            ChiselingEntryBuilderImpl entry = new ChiselingEntryBuilderImpl();
            this.entries.add(entry);
            return entry;
        }

        public ChiselingRecipeBuilder entry(Consumer<ChiselingEntryBuilder> builder) {
            builder.accept(this.entry());
            return this;
        }

        @Deprecated
        public ChiselingRecipeBuilder add(@Nullable Item regularBlock, @Nullable Item connectingBlock, boolean optional) {
            if (regularBlock == null && connectingBlock == null) {
                throw new IllegalArgumentException("At least one of regular item or connecting item must not be null!");
            }
            ChiselingEntryBuilder entry = this.entry().optional(optional);
            if (regularBlock != null) {
                entry.regularItem(ChiselingBlockShape.BLOCK, (ItemLike)regularBlock);
            }
            if (connectingBlock != null) {
                entry.connectingItem(ChiselingBlockShape.BLOCK, (ItemLike)connectingBlock);
            }
            return this;
        }

        @Deprecated
        public ChiselingRecipeBuilder add(Item regularBlock, Item connectingBlock) {
            return this.add(regularBlock, connectingBlock, false);
        }

        @Deprecated
        public ChiselingRecipeBuilder addRegularItem(Item item, boolean optional) {
            if (item == null) {
                throw new IllegalArgumentException("Item must not be null!");
            }
            return this.add(item, null, optional);
        }

        @Deprecated
        public ChiselingRecipeBuilder addRegularItem(Item item) {
            return this.addRegularItem(item, false);
        }

        @Deprecated
        public ChiselingRecipeBuilder addConnectingItem(Item item, boolean optional) {
            if (item == null) {
                throw new IllegalArgumentException("Item must not be null!");
            }
            return this.add(null, item, optional);
        }

        @Deprecated
        public ChiselingRecipeBuilder addConnectingItem(Item item) {
            return this.addConnectingItem(item, false);
        }
    }
}

