/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.gui.BaseContainerType;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.network.PacketChannel;
import com.supermartijn642.core.network.PacketDirection;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import com.supermartijn642.rechiseled.ChiselItem;
import com.supermartijn642.rechiseled.RechiseledBlocks;
import com.supermartijn642.rechiseled.RechiseledChiselingRecipes;
import com.supermartijn642.rechiseled.RechiseledClient;
import com.supermartijn642.rechiseled.api.blocks.RechiseledBlockType;
import com.supermartijn642.rechiseled.api.registration.RechiseledRegistration;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipeDatapackPlugin;
import com.supermartijn642.rechiseled.chiseling.PacketUpdateChiselingRecipes;
import com.supermartijn642.rechiseled.data.RechiseledBlockModelGenerator;
import com.supermartijn642.rechiseled.data.RechiseledItemModelGenerator;
import com.supermartijn642.rechiseled.data.RechiseledLanguageGenerator;
import com.supermartijn642.rechiseled.data.RechiseledRecipeGenerator;
import com.supermartijn642.rechiseled.data.RechiseledTextureProvider;
import com.supermartijn642.rechiseled.packet.PacketChiselAll;
import com.supermartijn642.rechiseled.packet.PacketChiselBlocks;
import com.supermartijn642.rechiseled.packet.PacketSelectEntry;
import com.supermartijn642.rechiseled.screen.ChiselContainer;
import java.util.LinkedList;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="rechiseled")
public class Rechiseled {
    public static final String MODID = "rechiseled";
    public static final RechiseledRegistration REGISTRATION = RechiseledRegistration.get("rechiseled");
    public static final PacketChannel CHANNEL = PacketChannel.create((String)"rechiseled");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rechiseled");
    @RegistryEntryAcceptor(namespace="rechiseled", identifier="chisel", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static ChiselItem chisel;
    @RegistryEntryAcceptor(namespace="rechiseled", identifier="chisel_container", registry=RegistryEntryAcceptor.Registry.MENU_TYPES)
    public static BaseContainerType<ChiselContainer> chisel_container;
    public static final CreativeItemGroup GROUP;

    public static ResourceLocation identifier(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public Rechiseled() {
        CHANNEL.registerMessage(PacketSelectEntry.class, PacketSelectEntry::new, PacketDirection.CLIENT_TO_SERVER, true);
        CHANNEL.registerMessage(PacketChiselAll.class, PacketChiselAll::new, PacketDirection.CLIENT_TO_SERVER, true);
        CHANNEL.registerMessage(PacketUpdateChiselingRecipes.class, PacketUpdateChiselingRecipes::new, PacketDirection.SERVER_TO_CLIENT, false);
        CHANNEL.registerMessage(PacketChiselBlocks.class, PacketChiselBlocks::new, PacketDirection.CLIENT_TO_SERVER, true);
        NeoForge.EVENT_BUS.addListener(e -> e.addListener((PreparableReloadListener)ChiselingRecipeDatapackPlugin.INSTANCE));
        Rechiseled.register();
        if (CommonUtils.getEnvironmentSide().isClient()) {
            RechiseledClient.register();
        }
        Rechiseled.registerGenerators();
        RechiseledBlocks.init();
        RechiseledChiselingRecipes.init();
    }

    public static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)MODID);
        handler.registerItem("chisel", ChiselItem::new);
        handler.registerMenuType("chisel_container", (MenuType)BaseContainerType.create((container, buffer) -> buffer.writeBoolean(container.hand == InteractionHand.MAIN_HAND), (player, buffer) -> new ChiselContainer((Player)player, buffer.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND)));
        handler.registerDataComponentType("chisel_held_stack", ChiselItem.HELD_STACK);
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)MODID);
        handler.addProvider(RechiseledTextureProvider::new);
        handler.addGenerator(RechiseledItemModelGenerator::new);
        handler.addGenerator(RechiseledLanguageGenerator::new);
        handler.addGenerator(RechiseledRecipeGenerator::new);
        handler.addGenerator(RechiseledBlockModelGenerator::new);
        REGISTRATION.registerDataProviders();
    }

    static {
        GROUP = CreativeItemGroup.create((String)MODID, () -> chisel).filler(stackConsumer -> {
            LinkedList<ChiselItem> items = new LinkedList<ChiselItem>();
            items.add(chisel);
            for (RechiseledBlockType type : REGISTRATION.getAllBlockTypes()) {
                if (type.hasRegularVariant()) {
                    items.add((ChiselItem)type.getRegularItem());
                }
                if (type.hasConnectingVariant()) {
                    items.add((ChiselItem)type.getConnectingItem());
                }
                if (type.hasRegularStairs()) {
                    items.add((ChiselItem)type.getRegularStairsItem());
                }
                if (type.hasConnectingStairs()) {
                    items.add((ChiselItem)type.getConnectingStairsItem());
                }
                if (type.hasRegularSlab()) {
                    items.add((ChiselItem)type.getRegularSlabItem());
                }
                if (!type.hasConnectingSlab()) continue;
                items.add((ChiselItem)type.getConnectingSlabItem());
            }
            items.stream().map(ItemStack::new).forEach((Consumer<ItemStack>)stackConsumer);
        });
    }
}

