/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingBlockShape;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingRecipeManager;
import com.supermartijn642.rechiseled.api.chiseling.ItemWithWorth;
import com.supermartijn642.rechiseled.packet.PacketChiselBlocks;
import com.supermartijn642.rechiseled.screen.ChiselContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ChiselItem
extends BaseItem {
    public static final DataComponentType<ItemHolder> HELD_STACK = DataComponentType.builder().persistent(ItemStack.OPTIONAL_CODEC.xmap(ItemHolder::new, ItemHolder::stack)).networkSynchronized(ItemStack.OPTIONAL_STREAM_CODEC.map(ItemHolder::new, ItemHolder::stack)).build();

    public static ItemStack getStoredStack(ItemStack chisel) {
        return chisel.has(HELD_STACK) ? ((ItemHolder)chisel.get(ChiselItem.HELD_STACK)).stack : ItemStack.EMPTY;
    }

    public static void setStoredStack(ItemStack chisel, ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            chisel.remove(HELD_STACK);
        } else {
            chisel.set(HELD_STACK, (Object)new ItemHolder(stack));
        }
    }

    public ChiselItem() {
        super(ItemProperties.create().maxStackSize(1).group((CreativeModeTab)Rechiseled.GROUP));
    }

    public BaseItem.ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        if (!level.isClientSide()) {
            CommonUtils.openContainer((BaseContainer)new ChiselContainer(player, hand));
        }
        return BaseItem.ItemUseResult.success((ItemStack)stack);
    }

    protected void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        ItemStack storedStack = ChiselItem.getStoredStack(stack);
        if (!storedStack.isEmpty()) {
            info.accept((Component)TextComponents.item((Item)storedStack.getItem()).color(ChatFormatting.GRAY).italic().get());
        }
        super.appendItemInformation(stack, info, advanced);
    }

    public boolean leftClickBlock(Player player, ItemStack stack, BlockPos pos, Direction side, boolean isShift) {
        Level level = player.level();
        List<Pair<BlockPos, BlockState>> chiselableBlocks = ChiselItem.findChiselableBlocks(level, pos, side, ChiselItem.getStoredStack(stack), isShift);
        if (chiselableBlocks.isEmpty()) {
            return false;
        }
        if (level.isClientSide()) {
            Rechiseled.CHANNEL.sendToServer((BasePacket)new PacketChiselBlocks(pos, side, isShift));
            player.playSound(level.getBlockState(pos).getSoundType().getHitSound());
        } else {
            for (Pair<BlockPos, BlockState> block : chiselableBlocks) {
                level.setBlock((BlockPos)block.left(), (BlockState)block.right(), 3);
            }
        }
        return true;
    }

    public static List<Pair<BlockPos, BlockState>> findChiselableBlocks(Level level, BlockPos targetedPos, Direction side, ItemStack filter, boolean isShiftDown) {
        ChiselingRecipe recipe;
        if (!filter.isEmpty() && !(filter.getItem() instanceof BlockItem)) {
            return List.of();
        }
        ChiselingRecipe chiselingRecipe = recipe = filter.isEmpty() ? null : ChiselingRecipeManager.get(true).getRecipeForItem((ItemLike)filter.getItem());
        if (!filter.isEmpty() && recipe == null) {
            return List.of();
        }
        BlockState targetedBlock = level.getBlockState(targetedPos);
        if (recipe == null ? (recipe = ChiselingRecipeManager.get(true).getRecipeForItem((ItemLike)targetedBlock.getBlock().asItem())) == null : recipe != ChiselingRecipeManager.get(true).getRecipeForItem((ItemLike)targetedBlock.getBlock().asItem())) {
            return List.of();
        }
        Item item = targetedBlock.getBlock().asItem();
        ChiselingBlockShape targetShape = null;
        block0: for (ChiselingEntry chiselingEntry : recipe.entries()) {
            if (!chiselingEntry.contains((ItemLike)item)) continue;
            for (ChiselingBlockShape shape : ChiselingBlockShape.values()) {
                if ((!chiselingEntry.hasRegularItem(shape) || chiselingEntry.getRegularItem(shape).item() != item) && (!chiselingEntry.hasConnectingItem(shape) || chiselingEntry.getConnectingItem(shape).item() != item)) continue;
                targetShape = shape;
                break block0;
            }
        }
        Block filterBlock = null;
        if (!filter.isEmpty()) {
            item = filter.getItem();
            block2: for (ChiselingEntry entry : recipe.entries()) {
                if (!entry.contains((ItemLike)item)) continue;
                for (ChiselingBlockShape shape : ChiselingBlockShape.values()) {
                    if (entry.hasRegularItem(shape) && entry.getRegularItem(shape).item() == item && entry.hasRegularItem(targetShape) && entry.getRegularItem(targetShape).item() instanceof BlockItem) {
                        filterBlock = ((BlockItem)entry.getRegularItem(targetShape).item()).getBlock();
                        break block2;
                    }
                    if (!entry.hasConnectingItem(shape) || entry.getConnectingItem(shape).item() != item || !entry.hasConnectingItem(targetShape) || !(entry.getConnectingItem(targetShape).item() instanceof BlockItem)) continue;
                    filterBlock = ((BlockItem)entry.getConnectingItem(targetShape).item()).getBlock();
                    break block2;
                }
            }
            if (filterBlock == null) {
                return List.of();
            }
        }
        ArrayList<Pair<BlockPos, BlockState>> arrayList = new ArrayList<Pair<BlockPos, BlockState>>();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int xRange = isShiftDown || side.getAxis() == Direction.Axis.X ? 0 : 1;
        int yRange = isShiftDown || side.getAxis() == Direction.Axis.Y ? 0 : 1;
        int zRange = isShiftDown || side.getAxis() == Direction.Axis.Z ? 0 : 1;
        for (int x = -xRange; x <= xRange; ++x) {
            for (int y = -yRange; y <= yRange; ++y) {
                for (int z = -zRange; z <= zRange; ++z) {
                    ItemWithWorth worth;
                    pos.set(targetedPos.getX() + x, targetedPos.getY() + y, targetedPos.getZ() + z);
                    BlockState state = level.getBlockState((BlockPos)pos);
                    if (state.getBlock() == filterBlock || (worth = recipe.getWorth((ItemLike)state.getBlock())) == null) continue;
                    pos.set(targetedPos.getX() + x + side.getStepX(), targetedPos.getY() + y + side.getStepY(), targetedPos.getZ() + z + side.getStepZ());
                    VoxelShape occlusionShape = level.getBlockState((BlockPos)pos).getFaceOcclusionShape((BlockGetter)level, (BlockPos)pos, side.getOpposite());
                    if (occlusionShape == Shapes.block() || !occlusionShape.isEmpty() && !Shapes.joinIsNotEmpty((VoxelShape)Shapes.block(), (VoxelShape)occlusionShape, (BooleanOp)BooleanOp.ONLY_FIRST)) continue;
                    pos.set(targetedPos.getX() + x, targetedPos.getY() + y, targetedPos.getZ() + z);
                    ChiselingBlockShape shape = null;
                    block7: for (ChiselingEntry chiselingEntry : recipe.entries()) {
                        if (!chiselingEntry.contains((ItemLike)state.getBlock())) continue;
                        for (ChiselingBlockShape s : ChiselingBlockShape.values()) {
                            if ((!chiselingEntry.hasRegularItem(s) || chiselingEntry.getRegularItem(s).item() != state.getBlock().asItem()) && (!chiselingEntry.hasConnectingItem(s) || chiselingEntry.getConnectingItem(s).item() != state.getBlock().asItem())) continue;
                            shape = s;
                            break block7;
                        }
                    }
                    if (targetShape != null && shape != targetShape) continue;
                    if (filterBlock != null) {
                        arrayList.add((Pair<BlockPos, BlockState>)Pair.of((Object)pos.immutable(), (Object)filterBlock.withPropertiesOf(state)));
                        continue;
                    }
                    ArrayList<Block> validBlocks = new ArrayList<Block>();
                    for (ChiselingEntry entry3 : recipe.entries()) {
                        Item connectingItem;
                        Item regularItem;
                        if (entry3.contains((ItemLike)state.getBlock())) continue;
                        if (entry3.hasRegularItem(shape) && entry3.getRegularItem(shape).worth() == worth.worth() && (regularItem = entry3.getRegularItem(shape).item()) instanceof BlockItem) {
                            validBlocks.add(((BlockItem)regularItem).getBlock());
                        }
                        if (!entry3.hasConnectingItem(shape) || entry3.getConnectingItem(shape).worth() != worth.worth() || !((connectingItem = entry3.getConnectingItem(shape).item()) instanceof BlockItem)) continue;
                        validBlocks.add(((BlockItem)connectingItem).getBlock());
                    }
                    if (validBlocks.isEmpty()) continue;
                    Block block = (Block)validBlocks.get(level.random.nextInt(validBlocks.size()));
                    arrayList.add((Pair<BlockPos, BlockState>)Pair.of((Object)pos.immutable(), (Object)block.withPropertiesOf(state)));
                }
            }
        }
        return arrayList;
    }

    private record ItemHolder(@NotNull ItemStack stack) {
    }
}

