/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.tile;

import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.network.EnderStorageNetwork;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Cuboid6;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class TileFrequencyOwner
extends BlockEntity {
    public static final Cuboid6 SELECTION_BUTTON = new Cuboid6(-0.0625, 0.0, -0.125, 0.0625, 0.0625, 0.125);
    protected Frequency frequency = new Frequency();
    private int changeCount;

    public TileFrequencyOwner(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public void setFreq(Frequency frequency) {
        assert (this.level != null);
        this.frequency = frequency;
        this.onFrequencySet();
        this.setChanged();
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        if (!this.level.isClientSide) {
            this.sendUpdatePacket();
        }
    }

    public void tick() {
        assert (this.level != null);
        if (this.getStorage().getChangeCount() > this.changeCount) {
            this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
            this.changeCount = this.getStorage().getChangeCount();
        }
    }

    public abstract AbstractEnderStorage getStorage();

    public void onFrequencySet() {
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.frequency = (Frequency)Frequency.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get("Frequency")).getOrThrow();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("Frequency", (Tag)Frequency.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.frequency).getOrThrow());
    }

    public void setLevel(Level p_155231_) {
        super.setLevel(p_155231_);
        this.onFrequencySet();
    }

    public boolean activate(Player player, int subHit, InteractionHand hand) {
        return false;
    }

    public void onPlaced(@Nullable LivingEntity entity) {
    }

    protected void sendUpdatePacket() {
        assert (this.level != null);
        this.createPacket().sendToChunk((BlockEntity)this);
    }

    public PacketCustom createPacket() {
        PacketCustom packet = new PacketCustom(EnderStorageNetwork.NET_CHANNEL, 1, this.level.registryAccess());
        packet.writePos(this.getBlockPos());
        this.writeToPacket((MCDataOutput)packet);
        return packet;
    }

    public void writeToPacket(MCDataOutput packet) {
        packet.writeWithRegistryCodec(Frequency.STREAM_CODEC, (Object)this.frequency);
    }

    public void readFromPacket(MCDataInput packet) {
        this.frequency = (Frequency)packet.readWithRegistryCodec(Frequency.STREAM_CODEC);
        this.onFrequencySet();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadWithComponents(tag, registries);
    }

    public int getLightValue() {
        return 0;
    }

    public boolean redstoneInteraction() {
        return false;
    }

    public int comparatorOutput() {
        return 0;
    }

    public boolean rotate() {
        return false;
    }
}

