/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.util;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.capabilities.attributes.BeeAttributesHandler;
import cy.jdkdigital.productivebees.common.block.Feeder;
import cy.jdkdigital.productivebees.common.block.entity.AmberBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.FeederBlockEntity;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredientFactory;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.item.CombBlockItem;
import cy.jdkdigital.productivebees.common.item.Honeycomb;
import cy.jdkdigital.productivebees.common.recipe.AdvancedBeehiveRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeConversionRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeNBTChangerRecipe;
import cy.jdkdigital.productivebees.common.recipe.BlockConversionRecipe;
import cy.jdkdigital.productivebees.common.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.common.recipe.ItemConversionRecipe;
import cy.jdkdigital.productivebees.compat.curios.CuriosCompat;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.ColorUtil;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneValue;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.common.util.Lazy;

public class BeeHelper {
    private static final Map<String, List<RecipeHolder<BlockConversionRecipe>>> blockConversionRecipeMap = new HashMap<String, List<RecipeHolder<BlockConversionRecipe>>>();
    private static final Map<String, List<RecipeHolder<ItemConversionRecipe>>> itemConversionRecipeMap = new HashMap<String, List<RecipeHolder<ItemConversionRecipe>>>();
    private static final Map<String, List<RecipeHolder<BeeNBTChangerRecipe>>> nbtChangerRecipeMap = new HashMap<String, List<RecipeHolder<BeeNBTChangerRecipe>>>();

    public static Entity itemInteract(Bee entity, ItemStack itemStack, ServerLevel level, Player player) {
        Entity bee = null;
        IdentifierInventory beeInv = new IdentifierInventory(entity, String.valueOf(BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem())));
        ArrayList<BeeConversionRecipe> recipes = new ArrayList<BeeConversionRecipe>();
        List allRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.BEE_CONVERSION_TYPE.get());
        for (RecipeHolder entry : allRecipes) {
            BeeConversionRecipe recipe = (BeeConversionRecipe)entry.value();
            if (!recipe.matches(beeInv, (Level)level)) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            BeeConversionRecipe recipe = (BeeConversionRecipe)recipes.get(level.random.nextInt(recipes.size()));
            if (level.random.nextFloat() < recipe.chance) {
                bee = recipe.result.get().getBeeEntity().create((Level)level);
                if (bee instanceof ConfigurableBee) {
                    ((ConfigurableBee)bee).setBeeType(recipe.result.get().getBeeType().toString());
                    ((ConfigurableBee)bee).setDefaultAttributes();
                }
                if (bee instanceof Bee) {
                    BeeHelper.setOffspringAttributes((Bee)bee, entity, (AgeableMob)entity);
                    ((Bee)bee).setAge(entity.getAge());
                }
            }
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
        }
        if (bee != null) {
            BlockPos pos = entity.blockPosition();
            bee.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, bee.getYRot(), bee.getXRot());
            if (bee instanceof LivingEntity) {
                ((LivingEntity)bee).setHealth(entity.getHealth());
                ((LivingEntity)bee).yBodyRot = entity.yBodyRot;
            }
            if (bee instanceof Animal && entity.getAge() > 0) {
                ((Animal)bee).setAge(entity.getAge());
            }
            return bee;
        }
        return null;
    }

    @Nullable
    public static Entity getBreedingResult(Bee beeEntity, AgeableMob targetEntity, ServerLevel world) {
        ResourceLocation type;
        CompoundTag nbt;
        BeeIngredient beeIngredient;
        RecipeHolder<BeeBreedingRecipe> recipe = BeeHelper.getRandomBreedingRecipe(beeEntity, targetEntity, world);
        if (recipe != null && ((BeeBreedingRecipe)recipe.value()).offspring.get() != null && (beeIngredient = ((BeeBreedingRecipe)recipe.value()).offspring.get()) != null) {
            Entity newBee = beeIngredient.getBeeEntity().create((Level)world);
            if (newBee instanceof ConfigurableBee) {
                ((ConfigurableBee)newBee).setBeeType(beeIngredient.getBeeType().toString());
                ((ConfigurableBee)newBee).setDefaultAttributes();
            }
            return newBee;
        }
        if (beeEntity instanceof ProductiveBee && !((ProductiveBee)beeEntity).canSelfBreed() || targetEntity instanceof ProductiveBee && !((ProductiveBee)targetEntity).canSelfBreed()) {
            return null;
        }
        if (beeEntity instanceof ConfigurableBee && (nbt = BeeReloadListener.INSTANCE.getData((type = ((ConfigurableBee)beeEntity).getBeeType()).toString())) != null && ((ConfigurableBee)beeEntity).canSelfBreed()) {
            ConfigurableBee newBee = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).create((Level)world);
            newBee.setBeeType(type.toString());
            newBee.setDefaultAttributes();
            return newBee;
        }
        if (beeEntity != null && (!(beeEntity instanceof ProductiveBee) || ((ProductiveBee)beeEntity).canSelfBreed())) {
            return ((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)beeEntity.getEncodeId()))).create((Level)world);
        }
        return null;
    }

    public static RecipeHolder<BeeBreedingRecipe> getRandomBreedingRecipe(Bee beeEntity, AgeableMob targetEntity, ServerLevel level) {
        List<RecipeHolder<BeeBreedingRecipe>> recipes = BeeHelper.getBreedingRecipes(beeEntity, targetEntity, level);
        if (!recipes.isEmpty()) {
            return recipes.get(level.random.nextInt(recipes.size()));
        }
        return null;
    }

    public static List<RecipeHolder<BeeBreedingRecipe>> getBreedingRecipes(Bee beeEntity, AgeableMob targetEntity, ServerLevel level) {
        IdentifierInventory beeInv = new IdentifierInventory(beeEntity, (Bee)targetEntity);
        return BeeHelper.getBreedingRecipes(beeInv, level);
    }

    public static List<RecipeHolder<BeeBreedingRecipe>> getBreedingRecipes(IdentifierInventory beeInv, ServerLevel level) {
        if (beeInv.getIdentifier(0) == null || beeInv.getIdentifier(1) == null) {
            return new ArrayList<RecipeHolder<BeeBreedingRecipe>>();
        }
        ArrayList<RecipeHolder<BeeBreedingRecipe>> recipes = new ArrayList<RecipeHolder<BeeBreedingRecipe>>();
        List allRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.BEE_BREEDING_TYPE.get());
        for (RecipeHolder entry : allRecipes) {
            if (!((BeeBreedingRecipe)entry.value()).matches(beeInv, (Level)level)) continue;
            recipes.add(entry);
        }
        ResourceLocation bee1Id = ResourceLocation.parse((String)beeInv.getIdentifier(0));
        CompoundTag bee1Data = BeeReloadListener.INSTANCE.getData(bee1Id);
        boolean canSelfBreed = bee1Id.toString().equals(beeInv.getIdentifier(1)) && (!bee1Id.getNamespace().equals("productivebees") || bee1Data == null || bee1Data.getBoolean("selfbreed"));
        Supplier<BeeIngredient> bee1Ingredient = BeeIngredientFactory.getIngredient(beeInv.getIdentifier());
        if (bee1Ingredient != null) {
            if (canSelfBreed && bee1Data == null) {
                ProductiveBee pBee;
                Entity bee = bee1Ingredient.get().getCachedEntity((Level)level);
                boolean bl = canSelfBreed = !(bee instanceof ProductiveBee) || (pBee = (ProductiveBee)bee).canSelfBreed();
            }
            if (canSelfBreed) {
                recipes.add((RecipeHolder<BeeBreedingRecipe>)new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("bee_breeding_" + ResourceLocation.parse((String)beeInv.getIdentifier()).getPath() + "_self")), (Recipe)new BeeBreedingRecipe((Supplier<BeeIngredient>)Lazy.of(bee1Ingredient), (Supplier<BeeIngredient>)Lazy.of(bee1Ingredient), (Supplier<BeeIngredient>)Lazy.of(bee1Ingredient), 0.0f)));
            }
        }
        return recipes;
    }

    public static RecipeHolder<BlockConversionRecipe> getBlockConversionRecipe(Bee beeEntity, BlockState flowerBlockState) {
        List<Object> recipes = new ArrayList();
        BlockStateInventory beeInv = new BlockStateInventory(beeEntity, flowerBlockState);
        String cacheKey = beeInv.getIdentifier(0) + beeInv.getIdentifier(1);
        if (blockConversionRecipeMap.containsKey(cacheKey)) {
            recipes = blockConversionRecipeMap.get(cacheKey);
        } else if (beeEntity.level() instanceof ServerLevel) {
            List allRecipes = beeEntity.level().getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.BLOCK_CONVERSION_TYPE.get());
            for (RecipeHolder recipe : allRecipes) {
                if (!((BlockConversionRecipe)recipe.value()).matches(beeInv, beeEntity.level())) continue;
                recipes.add(recipe);
            }
            blockConversionRecipeMap.put(cacheKey, recipes);
        }
        if (!recipes.isEmpty()) {
            return (RecipeHolder)recipes.get(beeEntity.level().random.nextInt(recipes.size()));
        }
        return null;
    }

    public static boolean hasBlockConversionRecipe(Bee beeEntity, BlockState flowerBlockState) {
        return BeeHelper.getBlockConversionRecipe(beeEntity, flowerBlockState) != null;
    }

    public static RecipeHolder<ItemConversionRecipe> getItemConversionRecipe(Bee beeEntity, ItemStack item) {
        List<Object> recipes = new ArrayList();
        ItemInventory beeInv = new ItemInventory(beeEntity, item);
        String cacheKey = beeInv.getIdentifier(0) + beeInv.getIdentifier(1);
        if (itemConversionRecipeMap.containsKey(cacheKey)) {
            recipes = itemConversionRecipeMap.get(cacheKey);
        } else if (beeEntity.level() instanceof ServerLevel) {
            List allRecipes = beeEntity.level().getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.ITEM_CONVERSION_TYPE.get());
            for (RecipeHolder recipe : allRecipes) {
                if (!((ItemConversionRecipe)recipe.value()).matches(beeInv, beeEntity.level())) continue;
                recipes.add(recipe);
            }
            itemConversionRecipeMap.put(cacheKey, recipes);
        }
        if (!recipes.isEmpty()) {
            return (RecipeHolder)recipes.get(beeEntity.level().random.nextInt(recipes.size()));
        }
        return null;
    }

    public static boolean hasItemConversionRecipe(Bee beeEntity, ItemStack item) {
        return BeeHelper.getItemConversionRecipe(beeEntity, item) != null;
    }

    public static RecipeHolder<BeeNBTChangerRecipe> getNBTChangerRecipe(Bee beeEntity, ItemStack item) {
        List<Object> recipes = new ArrayList();
        ItemInventory inv = new ItemInventory(beeEntity, item);
        String cacheKey = inv.getIdentifier(0) + inv.getIdentifier(1);
        if (nbtChangerRecipeMap.containsKey(cacheKey)) {
            recipes = nbtChangerRecipeMap.get(cacheKey);
        } else if (beeEntity.level() instanceof ServerLevel) {
            List allRecipes = beeEntity.level().getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.BEE_NBT_CHANGER_TYPE.get());
            for (RecipeHolder recipe : allRecipes) {
                if (!((BeeNBTChangerRecipe)recipe.value()).matches(inv, beeEntity.level())) continue;
                recipes.add(recipe);
            }
            nbtChangerRecipeMap.put(cacheKey, recipes);
        }
        if (!recipes.isEmpty()) {
            return (RecipeHolder)recipes.get(beeEntity.level().random.nextInt(recipes.size()));
        }
        return null;
    }

    public static boolean hasNBTChangerRecipe(Bee beeEntity, ItemStack item) {
        return BeeHelper.getNBTChangerRecipe(beeEntity, item) != null;
    }

    public static List<ItemStack> getBeeProduce(Level level, Bee beeEntity, boolean hasCombBlockUpgrade, double modifier) {
        RecipeHolder matchedRecipe = null;
        BlockPos flowerPos = beeEntity.getSavedFlowerPos();
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        String beeId = beeEntity.getEncodeId();
        if (beeId == null) {
            return outputList;
        }
        if (beeEntity instanceof ConfigurableBee) {
            beeId = ((ConfigurableBee)beeEntity).getBeeType().toString();
        }
        List allRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.ADVANCED_BEEHIVE_TYPE.get());
        IdentifierInventory beeInv = new IdentifierInventory(beeId);
        for (RecipeHolder recipe : allRecipes) {
            if (!((AdvancedBeehiveRecipe)recipe.value()).matches(beeInv, level)) continue;
            matchedRecipe = recipe;
        }
        int rolls = (int)Math.floor(modifier) + (level.random.nextDouble() < modifier % 1.0 ? 1 : 0);
        if (matchedRecipe != null) {
            ((AdvancedBeehiveRecipe)matchedRecipe.value()).getRecipeOutputs().forEach((itemStack, chancedOutput) -> {
                for (int i = 0; i < rolls; ++i) {
                    if (!(level.random.nextFloat() <= chancedOutput.chance())) continue;
                    ItemStack stack = itemStack.copy();
                    int count = Mth.nextInt((RandomSource)level.random, (int)Mth.floor((float)chancedOutput.min()), (int)Mth.floor((float)chancedOutput.max()));
                    if (hasCombBlockUpgrade && itemStack.getItem() instanceof HoneycombItem) {
                        stack = BeeHelper.getCombBlockFromHoneyComb(itemStack);
                    }
                    stack.setCount(count);
                    outputList.add(stack);
                }
            });
        } else if (beeId.equals("productivebees:lumber_bee")) {
            if (flowerPos != null && (flowerBlock = BeeHelper.getFloweringBlockFromTag(level, flowerPos, ModTags.LUMBER, (ProductiveBee)beeEntity)) != null && !flowerBlock.builtInRegistryHolder().is(ModTags.DUPE_BLACKLIST)) {
                outputList.add(new ItemStack((ItemLike)flowerBlock.asItem(), rolls));
            }
        } else if (beeId.equals("productivebees:quarry_bee")) {
            if (flowerPos != null && (flowerBlock = BeeHelper.getFloweringBlockFromTag(level, flowerPos, ModTags.QUARRY, (ProductiveBee)beeEntity)) != null && !flowerBlock.builtInRegistryHolder().is(ModTags.DUPE_BLACKLIST)) {
                outputList.add(new ItemStack((ItemLike)flowerBlock.asItem(), rolls));
            }
        } else if (beeId.equals("productivebees:dye_bee")) {
            Item flowerItem;
            ItemStack dye;
            if (flowerPos != null && (flowerBlock = BeeHelper.getFloweringBlockFromTag(level, flowerPos, (TagKey<Block>)BlockTags.FLOWERS, (ProductiveBee)beeEntity)) != null && !(dye = BeeHelper.getRecipeOutputFromInput(level, flowerItem = flowerBlock.asItem())).isEmpty()) {
                dye.setCount(rolls);
                outputList.add(dye);
            }
        } else if (beeId.equals("productivebees:wanna") && flowerPos != null && level instanceof ServerLevel) {
            FeederBlockEntity feederBlockEntity;
            ItemStack amberItem;
            CustomData tag;
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = null;
            BlockEntity blockEntity = level.getBlockEntity(flowerPos);
            if (blockEntity instanceof AmberBlockEntity) {
                AmberBlockEntity amberBlockEntity = (AmberBlockEntity)blockEntity;
                entity = amberBlockEntity.getCachedEntity();
            } else if (blockEntity instanceof FeederBlockEntity && (tag = (CustomData)(amberItem = (feederBlockEntity = (FeederBlockEntity)blockEntity).getSpecificItemFromInventory(((Block)ModBlocks.AMBER.get()).asItem(), level.random)).get(DataComponents.ENTITY_DATA)) != null) {
                entity = AmberBlockEntity.createEntity((Level)serverLevel, tag.copyTag());
            }
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(mob.getLootTable());
                if (!lootTable.equals(LootTable.EMPTY)) {
                    FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)new GameProfile(ModEntities.WANNA_BEE_UUID, "wanna_bee"));
                    LootParams.Builder lootContextBuilder = new LootParams.Builder(serverLevel);
                    lootContextBuilder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)fakePlayer);
                    lootContextBuilder.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)level.damageSources().generic());
                    lootContextBuilder.withParameter(LootContextParams.TOOL, (Object)new ItemStack((ItemLike)Items.DIAMOND_AXE));
                    lootContextBuilder.withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)fakePlayer);
                    lootContextBuilder.withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)fakePlayer);
                    lootContextBuilder.withParameter(LootContextParams.THIS_ENTITY, (Object)entity);
                    lootContextBuilder.withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)flowerPos.getX(), (double)flowerPos.getY(), (double)flowerPos.getZ()));
                    List<ItemStack> list = lootTable.getRandomItems(lootContextBuilder.create(LootContextParamSets.ENTITY)).stream().filter(itemStack -> !itemStack.is(ModTags.WANNABEE_LOOT_BLACKLIST)).toList();
                    if (!list.isEmpty()) {
                        for (int i = 0; i < rolls; ++i) {
                            outputList.add(list.get(level.random.nextInt(list.size())));
                        }
                    }
                }
            }
        }
        return outputList;
    }

    public static ItemStack getCombBlockFromHoneyComb(ItemStack itemStack) {
        ItemStack stack = ItemStack.EMPTY;
        if (itemStack.getItem() instanceof Honeycomb) {
            stack = new ItemStack((ItemLike)ModItems.CONFIGURABLE_COMB_BLOCK.get());
            stack.set(ModDataComponents.BEE_TYPE, (Object)((ResourceLocation)itemStack.get(ModDataComponents.BEE_TYPE)));
        } else {
            stack = switch (BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString()) {
                case "productivebees:honeycomb_ghostly" -> new ItemStack((ItemLike)ModBlocks.COMB_GHOSTLY.get());
                case "productivebees:honeycomb_milky" -> new ItemStack((ItemLike)ModBlocks.COMB_MILKY.get());
                case "productivebees:honeycomb_powdery" -> new ItemStack((ItemLike)ModBlocks.COMB_POWDERY.get());
                case "minecraft:honeycomb" -> new ItemStack((ItemLike)Blocks.HONEYCOMB_BLOCK);
                default -> stack;
            };
        }
        return stack;
    }

    public static ItemStack getRecipeOutputFromInput(Level level, Item input) {
        List recipes = level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING);
        for (RecipeHolder recipe : recipes) {
            Ingredient ingredient;
            ItemStack[] stacks;
            NonNullList ingredients = ((CraftingRecipe)recipe.value()).getIngredients();
            if (ingredients.size() != 1 || (stacks = (ingredient = (Ingredient)ingredients.getFirst()).getItems()).length <= 0 || !stacks[0].getItem().equals(input)) continue;
            return ((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getSingleComb(ItemStack stack) {
        ItemStack singleComb = ItemStack.EMPTY;
        if (stack.getItem() instanceof CombBlockItem) {
            singleComb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
            singleComb.set(ModDataComponents.BEE_TYPE, (Object)((ResourceLocation)stack.get(ModDataComponents.BEE_TYPE)));
        } else if (stack.is(((Block)ModBlocks.COMB_GHOSTLY.get()).asItem())) {
            singleComb = ((Item)ModItems.HONEYCOMB_GHOSTLY.get()).getDefaultInstance();
        } else if (stack.is(((Block)ModBlocks.COMB_MILKY.get()).asItem())) {
            singleComb = ((Item)ModItems.HONEYCOMB_MILKY.get()).getDefaultInstance();
        } else if (stack.is(((Block)ModBlocks.COMB_POWDERY.get()).asItem())) {
            singleComb = ((Item)ModItems.HONEYCOMB_POWDERY.get()).getDefaultInstance();
        } else if (stack.is(Items.HONEYCOMB_BLOCK)) {
            singleComb = Items.HONEYCOMB.getDefaultInstance();
        }
        return singleComb;
    }

    @Nullable
    public static RecipeHolder<CentrifugeRecipe> getCentrifugeRecipe(Level level, InventoryHandlerHelper.BlockEntityItemStackHandler inputHandler) {
        return level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.CENTRIFUGE_TYPE.get(), (RecipeInput)inputHandler, level).orElse(null);
    }

    private static Block getFloweringBlockFromTag(Level level, BlockPos flowerPos, TagKey<Block> tag, ProductiveBee bee) {
        BlockEntity feederTile;
        BlockState flowerBlockState = level.getBlockState(flowerPos);
        Block flowerBlock = flowerBlockState.getBlock();
        if (flowerBlock instanceof Feeder && (feederTile = level.getBlockEntity(flowerPos)) instanceof FeederBlockEntity) {
            FeederBlockEntity feederBlockEntity = (FeederBlockEntity)feederTile;
            if (ProductiveBee.isValidFeeder(bee, feederTile, bee::isFlowerBlock, bee::isFlowerItem)) {
                return feederBlockEntity.getRandomBlockFromInventory(tag, level.random);
            }
        }
        return flowerBlockState.is(tag) ? flowerBlock : null;
    }

    public static void encaseMob(Mob target, Level level, Direction direction) {
        if (target != null && !target.getType().is(ModTags.BEE_ENCASE_BLACKLIST) && target.isAlive() && !target.isRemoved()) {
            TamableAnimal tamableAnimal;
            if (target instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)target).isTame()) {
                return;
            }
            if (level.getBlockState(target.blockPosition()).canBeReplaced() && !target.isRemoved()) {
                level.setBlockAndUpdate(target.blockPosition(), (BlockState)((Block)ModBlocks.AMBER.get()).defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction));
                BlockEntity blockEntity = level.getBlockEntity(target.blockPosition());
                if (blockEntity instanceof AmberBlockEntity) {
                    AmberBlockEntity amberBlockEntity = (AmberBlockEntity)blockEntity;
                    amberBlockEntity.setEntity(target);
                    target.remove(Entity.RemovalReason.DISCARDED);
                }
            }
        }
    }

    public static void setOffspringAttributes(Bee newBee, Bee parent1, AgeableMob parent2) {
        BeeAttributesHandler parent1Attributes = (BeeAttributesHandler)parent1.getData(ProductiveBees.ATTRIBUTE_HANDLER);
        BeeAttributesHandler parent2Attributes = (BeeAttributesHandler)parent2.getData(ProductiveBees.ATTRIBUTE_HANDLER);
        BeeAttributesHandler newBeeAttributes = (BeeAttributesHandler)newBee.getData(ProductiveBees.ATTRIBUTE_HANDLER);
        int prod1 = parent1Attributes.getAttributeValue(GeneAttribute.PRODUCTIVITY).getValue();
        int prod2 = parent2Attributes.getAttributeValue(GeneAttribute.PRODUCTIVITY).getValue();
        int parentProductivity = Mth.nextInt((RandomSource)newBee.level().random, (int)Math.min(prod1, prod2), (int)Math.max(prod1, prod2));
        newBeeAttributes.setAttributeValue(GeneAttribute.PRODUCTIVITY, GeneValue.productivity(Math.max(newBeeAttributes.getAttributeValue(GeneAttribute.PRODUCTIVITY).getValue(), parentProductivity)));
        int end1 = parent1Attributes.getAttributeValue(GeneAttribute.ENDURANCE).getValue();
        int end2 = parent2Attributes.getAttributeValue(GeneAttribute.ENDURANCE).getValue();
        int parentEndurance = Mth.nextInt((RandomSource)newBee.level().random, (int)Math.min(end1, end2), (int)Math.max(end1, end2));
        newBeeAttributes.setAttributeValue(GeneAttribute.ENDURANCE, GeneValue.endurance(Math.max(newBeeAttributes.getAttributeValue(GeneAttribute.ENDURANCE).getValue(), parentEndurance)));
        int temp1 = parent1Attributes.getAttributeValue(GeneAttribute.TEMPER).getValue();
        int temp2 = parent2Attributes.getAttributeValue(GeneAttribute.TEMPER).getValue();
        newBeeAttributes.setAttributeValue(GeneAttribute.TEMPER, GeneValue.temper(Math.min(newBeeAttributes.getAttributeValue(GeneAttribute.TEMPER).getValue(), Math.min(temp1, temp2))));
        int beh1 = parent1Attributes.getAttributeValue(GeneAttribute.BEHAVIOR).getValue();
        int beh2 = parent2Attributes.getAttributeValue(GeneAttribute.BEHAVIOR).getValue();
        int parentBehavior = Mth.nextInt((RandomSource)newBee.level().random, (int)Math.min(beh1, beh2), (int)Math.max(beh1, beh2));
        newBeeAttributes.setAttributeValue(GeneAttribute.BEHAVIOR, GeneValue.behavior(Math.max(newBeeAttributes.getAttributeValue(GeneAttribute.BEHAVIOR).getValue(), parentBehavior)));
        int wt1 = parent1Attributes.getAttributeValue(GeneAttribute.WEATHER_TOLERANCE).getValue();
        int wt2 = parent2Attributes.getAttributeValue(GeneAttribute.WEATHER_TOLERANCE).getValue();
        int parentWeatherTolerance = Mth.nextInt((RandomSource)newBee.level().random, (int)Math.min(wt1, wt2), (int)Math.max(wt1, wt2));
        newBeeAttributes.setAttributeValue(GeneAttribute.WEATHER_TOLERANCE, GeneValue.weatherTolerance(Math.max(newBeeAttributes.getAttributeValue(GeneAttribute.WEATHER_TOLERANCE).getValue(), parentWeatherTolerance)));
    }

    public static CompoundTag getBeeAsCompoundTag(BeeIngredient beeIngredient) throws CommandSyntaxException {
        CompoundTag bee;
        if (beeIngredient.isConfigurable()) {
            String type = beeIngredient.getBeeType().getPath();
            bee = TagParser.parseTag((String)("{id:\"productivebees:configurable_bee\",bee_type: \"hive\", type: \"productivebees:" + type + "\", HasConverted: false}"));
        } else {
            bee = TagParser.parseTag((String)("{id:\"" + beeIngredient.getBeeType().toString() + "\",bee_type: \"solitary\", HasConverted: false}"));
        }
        return bee;
    }

    public static void populateBeeInfoFromEntity(Bee bee, List<Component> list) {
        CompoundTag tag = new CompoundTag();
        bee.saveWithoutId(tag);
        if (bee instanceof ProductiveBee) {
            tag.putBoolean("isProductiveBee", true);
        }
        BeeHelper.populateBeeInfoFromTag(tag, list);
    }

    public static List<Component> populateBeeInfoFromTag(CompoundTag tag, @Nullable List<Component> list) {
        return BeeHelper.populateBeeInfoFromTag(tag, list, false);
    }

    public static List<Component> populateBeeInfoFromTag(CompoundTag tag, @Nullable List<Component> list, boolean minified) {
        if (list == null) {
            list = new ArrayList<Component>();
        }
        list.add((Component)Component.translatable((String)(tag.getInt("Age") < 0 ? "productivebees.information.age.child" : "productivebees.information.age.adult")).withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.ITALIC));
        if (tag.contains("neoforge:attachments")) {
            if (!minified) {
                float current = tag.getFloat("Health");
                float max = tag.contains("MaxHealth") ? tag.getFloat("MaxHealth") : 10.0f;
                list.add((Component)Component.translatable((String)"productivebees.information.attribute.health", (Object[])new Object[]{Float.valueOf(current), Float.valueOf(max)}).withStyle(ChatFormatting.DARK_GRAY));
            }
            String type = "hive";
            if (tag.contains("bee_type")) {
                type = tag.getString("bee_type");
            }
            MutableComponent type_value = Component.translatable((String)("productivebees.information.attribute.type." + type)).withStyle(ColorUtil.getBeeTypeColor(type));
            list.add((Component)Component.translatable((String)"productivebees.information.attribute.type", (Object[])new Object[]{type_value}).withStyle(ChatFormatting.DARK_GRAY));
            CompoundTag attachments = tag.getCompound("neoforge:attachments");
            if (attachments.contains("productivebees:attributes_handler")) {
                CompoundTag attributeTag = attachments.getCompound("productivebees:attributes_handler");
                GeneValue productivity = GeneValue.byName(attributeTag.getString("bee_productivity"));
                MutableComponent productivity_value = Component.translatable((String)("productivebees.information.attribute." + productivity.getSerializedName())).withStyle(ColorUtil.getAttributeColor(productivity));
                list.add((Component)Component.translatable((String)"productivebees.information.attribute.productivity", (Object[])new Object[]{productivity_value}).withStyle(ChatFormatting.DARK_GRAY));
                GeneValue tolerance = GeneValue.byName(attributeTag.getString("bee_weather_tolerance"));
                MutableComponent tolerance_value = Component.translatable((String)("productivebees.information.attribute." + tolerance.getSerializedName())).withStyle(ColorUtil.getAttributeColor(tolerance));
                list.add((Component)Component.translatable((String)"productivebees.information.attribute.weather_tolerance", (Object[])new Object[]{tolerance_value}).withStyle(ChatFormatting.DARK_GRAY));
                GeneValue behavior = GeneValue.byName(attributeTag.getString("bee_behavior"));
                MutableComponent behavior_value = Component.translatable((String)("productivebees.information.attribute." + behavior.getSerializedName())).withStyle(ColorUtil.getAttributeColor(behavior));
                list.add((Component)Component.translatable((String)"productivebees.information.attribute.behavior", (Object[])new Object[]{behavior_value}).withStyle(ChatFormatting.DARK_GRAY));
                GeneValue endurance = GeneValue.byName(attributeTag.getString("bee_endurance"));
                MutableComponent endurance_value = Component.translatable((String)("productivebees.information.attribute." + endurance.getSerializedName())).withStyle(ColorUtil.getAttributeColor(endurance));
                list.add((Component)Component.translatable((String)"productivebees.information.attribute.endurance", (Object[])new Object[]{endurance_value}).withStyle(ChatFormatting.DARK_GRAY));
                GeneValue temper = GeneValue.byName(attributeTag.getString("bee_temper"));
                MutableComponent temper_value = Component.translatable((String)("productivebees.information.attribute." + temper.getSerializedName())).withStyle(ColorUtil.getAttributeColor(temper));
                list.add((Component)Component.translatable((String)"productivebees.information.attribute.temper", (Object[])new Object[]{temper_value}).withStyle(ChatFormatting.DARK_GRAY));
            }
            if (!minified) {
                if (tag.contains("type")) {
                    CompoundTag beeData = BeeReloadListener.INSTANCE.getData(ResourceLocation.parse((String)tag.getString("type")));
                    MutableComponent breedingItemText = Component.translatable((String)"productivebees.information.breeding_item_default");
                    if (beeData != null && beeData.contains("breedingItem") && !beeData.getString("breedingItem").isEmpty()) {
                        Item breedingItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)beeData.getString("breedingItem")));
                        breedingItemText = Component.literal((String)(beeData.getInt("breedingItemCount") + " " + Component.translatable((String)breedingItem.getDescriptionId()).getString()));
                    }
                    list.add((Component)Component.translatable((String)"productivebees.information.breeding_item", (Object[])new Object[]{breedingItemText.withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.DARK_GRAY));
                    if (beeData != null && !beeData.getBoolean("selfbreed")) {
                        list.add((Component)Component.translatable((String)"productivebees.information.selfbreed_disabled").withStyle(ChatFormatting.GRAY));
                    }
                }
                if (tag.contains("HivePos")) {
                    BlockPos hivePos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"HivePos").orElse(BlockPos.ZERO);
                    list.add((Component)Component.translatable((String)"productivebees.information.home_position", (Object[])new Object[]{hivePos.getX(), hivePos.getY(), hivePos.getZ()}));
                }
            }
        }
        return list;
    }

    public static boolean isWearingBeeNestHelmet(LivingEntity entity) {
        boolean isWearingBeeHelmet = false;
        if (entity != null) {
            ItemStack itemstack = entity.getItemBySlot(EquipmentSlot.HEAD);
            if (!itemstack.isEmpty() && itemstack.getItem().equals(ModItems.BEE_NEST_DIAMOND_HELMET.get())) {
                isWearingBeeHelmet = true;
            }
            if (!isWearingBeeHelmet && ModList.get().isLoaded("curios")) {
                isWearingBeeHelmet = CuriosCompat.isWearingBeeHelmet(entity);
            }
        }
        return isWearingBeeHelmet;
    }

    public static String itemCacheKey(ItemStack stack) {
        if (stack.has(ModDataComponents.BEE_TYPE)) {
            return BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString() + String.valueOf(stack.get(ModDataComponents.BEE_TYPE));
        }
        return BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString() + String.valueOf(!stack.getComponents().isEmpty() ? stack.getComponents().stream().map(TypedDataComponent::toString).reduce((s, s2) -> s + s2) : "");
    }

    public static class IdentifierInventory
    implements RecipeInput {
        private final List<String> identifiers = new ArrayList<String>();

        public IdentifierInventory(String identifier) {
            this.identifiers.add(identifier);
        }

        public IdentifierInventory(Bee bee1, Bee bee2) {
            String identifier1 = BuiltInRegistries.ENTITY_TYPE.getKey((Object)bee1.getType()).toString();
            if (bee1 instanceof ConfigurableBee) {
                identifier1 = ((ConfigurableBee)bee1).getBeeType().toString();
            }
            String identifier2 = BuiltInRegistries.ENTITY_TYPE.getKey((Object)bee2.getType()).toString();
            if (bee2 instanceof ConfigurableBee) {
                identifier2 = ((ConfigurableBee)bee2).getBeeType().toString();
            }
            this.identifiers.add(identifier1);
            this.identifiers.add(identifier2);
        }

        public IdentifierInventory(Bee bee1, String identifier2) {
            String identifier1 = BuiltInRegistries.ENTITY_TYPE.getKey((Object)bee1.getType()).toString();
            if (bee1 instanceof ConfigurableBee) {
                identifier1 = ((ConfigurableBee)bee1).getBeeType().toString();
            }
            this.identifiers.add(identifier1);
            this.identifiers.add(identifier2);
        }

        public IdentifierInventory(String identifier1, String identifier2) {
            this.identifiers.add(identifier1);
            this.identifiers.add(identifier2);
        }

        public String getIdentifier() {
            return this.getIdentifier(0);
        }

        public String getIdentifier(int index) {
            return this.identifiers.get(index);
        }

        public int size() {
            return 1;
        }

        public boolean isEmpty() {
            return this.identifiers.isEmpty();
        }

        @Nonnull
        public ItemStack getItem(int i) {
            return ItemStack.EMPTY;
        }
    }

    public static class BlockStateInventory
    extends IdentifierInventory {
        private BlockState state;

        public BlockStateInventory(Bee bee1, BlockState state) {
            super(bee1, state.toString());
            this.state = state;
        }

        public BlockState getState() {
            return this.state;
        }
    }

    public static class ItemInventory
    extends IdentifierInventory {
        private ItemStack input;

        public ItemInventory(Bee bee1, ItemStack input) {
            super(bee1, input.toString());
            this.input = input;
        }

        public ItemStack getInput() {
            return this.input;
        }
    }
}

