/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container.gui;

import cy.jdkdigital.productivebees.common.block.entity.HoneyGeneratorBlockEntity;
import cy.jdkdigital.productivebees.container.HoneyGeneratorContainer;
import cy.jdkdigital.productivebees.util.FluidContainerUtil;
import cy.jdkdigital.productivelib.client.screen.AbstractUpgradeableContainerScreen;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.fluids.FluidStack;

public class HoneyGeneratorScreen
extends AbstractUpgradeableContainerScreen<HoneyGeneratorContainer> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/container/honey_generator.png");

    public HoneyGeneratorScreen(HoneyGeneratorContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainer)container, inv, titleIn);
    }

    public void render(@Nonnull GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        this.renderTooltip(matrixStack, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        FluidStack fluidStack = ((HoneyGeneratorBlockEntity)((HoneyGeneratorContainer)this.menu).getBlockEntity()).getFluidHandler().getFluidInTank(0);
        if (this.isHovering(142, 16, 6, 54, mouseX, mouseY)) {
            ArrayList<FormattedCharSequence> tooltipList = new ArrayList<FormattedCharSequence>();
            if (fluidStack.getAmount() > 0) {
                tooltipList.add(Component.translatable((String)"productivebees.screen.fluid_level", (Object[])new Object[]{fluidStack.getHoverName().getString(), fluidStack.getAmount() + "mB"}).getVisualOrderText());
            } else {
                tooltipList.add(Component.translatable((String)"productivebees.screen.empty").getVisualOrderText());
            }
            guiGraphics.renderTooltip(this.font, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
        int energyAmount = ((HoneyGeneratorBlockEntity)((HoneyGeneratorContainer)this.menu).getBlockEntity()).getEnergyHandler().getEnergyStored();
        if (this.isHovering(8, 16, 6, 54, mouseX, mouseY)) {
            ArrayList<FormattedCharSequence> tooltipList = new ArrayList<FormattedCharSequence>();
            tooltipList.add(Component.translatable((String)"productivebees.screen.energy_level", (Object[])new Object[]{energyAmount + "FE"}).getVisualOrderText());
            guiGraphics.renderTooltip(this.font, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(GUI_TEXTURE, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        guiGraphics.blit(GUI_TEXTURE, this.getGuiLeft() + 8, this.getGuiTop() + 17, 206, 0, 4, 52);
        float energyAmount = ((HoneyGeneratorBlockEntity)((HoneyGeneratorContainer)this.menu).getBlockEntity()).getEnergyHandler().getEnergyStored();
        int energyLevel = (int)(energyAmount * (52.0f / (float)((HoneyGeneratorBlockEntity)((HoneyGeneratorContainer)this.menu).getBlockEntity()).getEnergyHandler().getMaxEnergyStored()));
        guiGraphics.blit(GUI_TEXTURE, this.getGuiLeft() + 8, this.getGuiTop() + 17, 8, 17, 4, 52 - energyLevel);
        FluidStack fluidStack = ((HoneyGeneratorBlockEntity)((HoneyGeneratorContainer)this.menu).getBlockEntity()).getFluidHandler().getFluidInTank(0);
        if (fluidStack.getAmount() > 0) {
            FluidContainerUtil.renderFluidTank(guiGraphics, this, fluidStack, ((HoneyGeneratorBlockEntity)((HoneyGeneratorContainer)this.menu).getBlockEntity()).getFluidHandler().getTankCapacity(0), 140, 17, 4, 52, 0);
        }
    }
}

