/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.entity.BottlerBlockEntity;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.common.block.entity.ICapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class BottlerContainer
extends AbstractContainer<BottlerBlockEntity> {
    public BottlerContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, BottlerContainer.getTileEntity(playerInventory, data));
    }

    public BottlerContainer(int windowId, Inventory playerInventory, final BottlerBlockEntity blockEntity) {
        super((MenuType)ModContainerTypes.BOTTLER.get(), (ICapabilityBlockEntity)blockEntity, windowId);
        this.addDataSlots(new ContainerData(){

            public int get(int i) {
                return i == 0 ? blockEntity.fluidId : blockEntity.fluidHandler.getFluidInTank(0).getAmount();
            }

            public void set(int i, int value) {
                switch (i) {
                    case 0: {
                        blockEntity.fluidId = value;
                    }
                    case 1: {
                        FluidStack fluid = blockEntity.fluidHandler.getFluidInTank(0);
                        if (fluid.isEmpty()) {
                            blockEntity.fluidHandler.fill(new FluidStack((Fluid)BuiltInRegistries.FLUID.byId(blockEntity.fluidId), value), IFluidHandler.FluidAction.EXECUTE);
                            break;
                        }
                        fluid.setAmount(value);
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        });
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((BottlerBlockEntity)this.getBlockEntity()).getItemHandler(), 0, 152, 17));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((BottlerBlockEntity)this.getBlockEntity()).getItemHandler(), 11, 152, 53));
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static BottlerBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof BottlerBlockEntity) {
            return (BottlerBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }
}

