/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.common.block.entity.ICapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class AdvancedBeehiveContainer
extends AbstractContainer<AdvancedBeehiveBlockEntity> {
    public static final int SLOT_BOTTLE = 0;
    public static final int SLOT_CAGE = 11;
    public static final HashMap<Integer, List<Integer>> BEE_POSITIONS = new HashMap<Integer, List<Integer>>(){
        {
            this.put(0, new ArrayList<Integer>(){
                {
                    this.add(35);
                    this.add(24);
                }
            });
            this.put(1, new ArrayList<Integer>(){
                {
                    this.add(53);
                    this.add(34);
                }
            });
            this.put(2, new ArrayList<Integer>(){
                {
                    this.add(35);
                    this.add(45);
                }
            });
        }
    };
    public static final HashMap<Integer, List<Integer>> BEE_POSITIONS_EXPANDED = new HashMap<Integer, List<Integer>>(){
        {
            this.put(0, new ArrayList<Integer>(){
                {
                    this.add(17);
                    this.add(23);
                }
            });
            this.put(1, new ArrayList<Integer>(){
                {
                    this.add(17);
                    this.add(44);
                }
            });
            this.put(2, new ArrayList<Integer>(){
                {
                    this.add(35);
                    this.add(34);
                }
            });
            this.put(3, new ArrayList<Integer>(){
                {
                    this.add(53);
                    this.add(23);
                }
            });
            this.put(4, new ArrayList<Integer>(){
                {
                    this.add(53);
                    this.add(44);
                }
            });
        }
    };

    public AdvancedBeehiveContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, AdvancedBeehiveContainer.getTileEntity(playerInventory, data));
    }

    public AdvancedBeehiveContainer(int windowId, Inventory playerInventory, AdvancedBeehiveBlockEntity blockEntity) {
        super((MenuType)ModContainerTypes.ADVANCED_BEEHIVE.get(), (ICapabilityBlockEntity)blockEntity, windowId);
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)blockEntity.inventoryHandler, 0, 86, 17));
        if (blockEntity.isSim()) {
            this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)blockEntity.inventoryHandler, 11, 86, 53));
        }
        this.addSlotBox((IItemHandler)blockEntity.inventoryHandler, InventoryHandlerHelper.OUTPUT_SLOTS[0], 116, 17, 3, 18, 3, 18);
        if (blockEntity.acceptsUpgrades()) {
            this.addSlotBox((IItemHandler)blockEntity.getUpgradeHandler(), 0, 178, 8, 1, 18, 4, 18);
        }
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static AdvancedBeehiveBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof AdvancedBeehiveBlockEntity) {
            return (AdvancedBeehiveBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }
}

