/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.jei;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredientFactory;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.compat.jei.ProductiveBeesJeiPlugin;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class BeeBreedingRecipeCategory
implements IRecipeCategory<BeeBreedingRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public BeeBreedingRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/jei/bee_breeding_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)BeeIngredientFactory.getOrCreateList().get("productivebees:quarry_bee"));
    }

    public RecipeType<BeeBreedingRecipe> getRecipeType() {
        return ProductiveBeesJeiPlugin.BEE_BREEDING_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)"jei.productivebees.bee_breeding");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BeeBreedingRecipe recipe, IFocusGroup focuses) {
        BeeIngredient beeIngredient2;
        Entity bee2;
        if (recipe.parent1.get() == null || recipe.parent2.get() == null || recipe.offspring.get() == null) {
            ProductiveBees.LOGGER.warn("Recipe is missing bee");
            return;
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 12, 17).addIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)recipe.parent1.get())).setSlotName("parent1");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 46, 17).addIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)recipe.parent2.get())).setSlotName("parent2");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 104, 17).addIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)recipe.offspring.get())).setSlotName("offspring");
        BeeIngredient beeIngredient1 = recipe.parent1.get();
        Entity bee1 = beeIngredient1.getCachedEntity((Level)Minecraft.getInstance().level);
        if (bee1 instanceof ProductiveBee) {
            ProductiveBee productiveBee = (ProductiveBee)bee1;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 10, 38).addItemStacks(productiveBee.getBreedingItems())).setSlotName("breedingItem1");
        }
        if ((bee2 = (beeIngredient2 = recipe.parent2.get()).getCachedEntity((Level)Minecraft.getInstance().level)) instanceof ProductiveBee) {
            ProductiveBee productiveBee = (ProductiveBee)bee2;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 44, 38).addItemStacks(productiveBee.getBreedingItems())).setSlotName("breedingItem2");
        }
    }
}

