/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;

public class BeeConversionRecipe
implements Recipe<RecipeInput> {
    public final Supplier<BeeIngredient> source;
    public final Supplier<BeeIngredient> result;
    public final Ingredient item;
    public final float chance;

    public BeeConversionRecipe(Supplier<BeeIngredient> ingredients, Supplier<BeeIngredient> result, Ingredient item, float chance) {
        this.source = ingredients;
        this.result = result;
        this.item = item;
        this.chance = chance;
    }

    public boolean matches(RecipeInput inv, Level worldIn) {
        if (inv instanceof BeeHelper.IdentifierInventory && this.source.get() != null) {
            String beeName = ((BeeHelper.IdentifierInventory)inv).getIdentifier(0);
            String itemName = ((BeeHelper.IdentifierInventory)inv).getIdentifier(1);
            String parentName = this.source.get().getBeeType().toString();
            boolean matchesItem = false;
            for (ItemStack stack : this.item.getItems()) {
                if (!BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString().equals(itemName)) continue;
                matchesItem = true;
            }
            return parentName.equals(beeName) && matchesItem;
        }
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.BEE_CONVERSION.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.BEE_CONVERSION_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BeeConversionRecipe> {
        private static final MapCodec<BeeConversionRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BeeIngredient.CODEC.fieldOf("source").forGetter(recipe -> recipe.source), (App)BeeIngredient.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC.fieldOf("item").forGetter(recipe -> recipe.item), (App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(1.0f)).forGetter(recipe -> Float.valueOf(recipe.chance))).apply((Applicative)builder, BeeConversionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BeeConversionRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BeeConversionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BeeConversionRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static BeeConversionRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                BeeIngredient source = BeeIngredient.fromNetwork((FriendlyByteBuf)buffer);
                BeeIngredient result = BeeIngredient.fromNetwork((FriendlyByteBuf)buffer);
                return new BeeConversionRecipe((Supplier<BeeIngredient>)Lazy.of(() -> source), (Supplier<BeeIngredient>)Lazy.of(() -> result), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), buffer.readFloat());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee conversion recipe from packet.", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, BeeConversionRecipe recipe) {
            try {
                recipe.source.get().toNetwork((FriendlyByteBuf)buffer);
                recipe.result.get().toNetwork((FriendlyByteBuf)buffer);
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.item);
                buffer.writeFloat(recipe.chance);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee conversion recipe to packet.", (Throwable)e);
                throw e;
            }
        }
    }
}

