/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.item.BeeBomb;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BeeBombBeeCageRecipe
implements CraftingRecipe {
    public final ItemStack beeBomb;

    public BeeBombBeeCageRecipe(ItemStack beeBomb) {
        this.beeBomb = beeBomb;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        ItemStack beeBombStack = null;
        int beeCount = 0;
        int bombBeeCount = 0;
        for (int j = 0; j < inv.size(); ++j) {
            ItemStack itemstack = inv.getItem(j);
            if (itemstack.isEmpty()) continue;
            if (beeBombStack == null && (itemstack.getItem().equals(ModItems.BEE_BOMB.get()) || itemstack.getItem().equals(ModItems.BEE_BOMB_ANGRY.get()))) {
                beeBombStack = itemstack;
                ListTag bees = BeeBomb.getBees(beeBombStack);
                beeCount += bees.size();
                bombBeeCount = bees.size();
                continue;
            }
            if (itemstack.getItem().equals(ModItems.BEE_CAGE.get()) && BeeCage.isFilled(itemstack)) {
                ++beeCount;
                continue;
            }
            return false;
        }
        if (beeBombStack == null) {
            return false;
        }
        if (bombBeeCount == beeCount) {
            return false;
        }
        return beeCount > 0 && beeCount <= (Integer)ProductiveBeesConfig.GENERAL.numberOfBeesPerBomb.get();
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        ItemStack bomb = null;
        ArrayList<ItemStack> beeCages = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.size(); ++j) {
            ItemStack itemstack = inv.getItem(j);
            if (itemstack.isEmpty()) continue;
            if (itemstack.getItem().equals(ModItems.BEE_BOMB.get()) || itemstack.getItem().equals(ModItems.BEE_BOMB_ANGRY.get())) {
                bomb = itemstack;
                continue;
            }
            if (!itemstack.getItem().equals(ModItems.BEE_CAGE.get())) continue;
            beeCages.add(itemstack);
        }
        if (bomb != null) {
            ItemStack beeBomb = bomb.copy();
            beeCages.forEach(beeCage -> BeeBomb.addBee(beeBomb, beeCage));
            beeBomb.setCount(1);
            return beeBomb;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.beeBomb;
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{this.beeBomb.copy()}));
        ItemStack cage = new ItemStack((ItemLike)ModItems.BEE_CAGE.get());
        list.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{cage}));
        return list;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.BEE_CAGE_BOMB.get();
    }

    public static class Serializer
    implements RecipeSerializer<BeeBombBeeCageRecipe> {
        private static final MapCodec<BeeBombBeeCageRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.CODEC.fieldOf("bee_bomb").forGetter(recipe -> recipe.beeBomb)).apply((Applicative)builder, BeeBombBeeCageRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BeeBombBeeCageRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BeeBombBeeCageRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BeeBombBeeCageRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static BeeBombBeeCageRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                return new BeeBombBeeCageRecipe((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer));
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee bomb cage recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, BeeBombBeeCageRecipe recipe) {
            try {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.beeBomb);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee bomb cage recipe to packet. ", (Throwable)e);
                throw e;
            }
        }
    }
}

