/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.capabilities.attributes.BeeAttributesHandler;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneGroup;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public class GeneBottle
extends Item {
    public GeneBottle(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack getStack(Entity target) {
        return GeneBottle.getStack(target, 1);
    }

    public static ItemStack getStack(Entity target, int count) {
        ItemStack result = new ItemStack((ItemLike)ModItems.GENE_BOTTLE.get(), count);
        GeneBottle.setGenes(result, target);
        return result;
    }

    public static void setGenes(ItemStack stack, Entity target) {
        CompoundTag nbt = new CompoundTag();
        String name = target.getName().getString();
        if (target.hasCustomName()) {
            name = target.getCustomName().getString();
        }
        String type = target.getEncodeId();
        if (target instanceof ProductiveBee) {
            ProductiveBee pBee = (ProductiveBee)target;
            type = pBee.getBeeType().toString();
        }
        ArrayList<GeneGroup> geneList = new ArrayList<GeneGroup>();
        BeeAttributesHandler data = (BeeAttributesHandler)target.getData(ProductiveBees.ATTRIBUTE_HANDLER);
        for (GeneAttribute attribute : GeneAttribute.values()) {
            if (attribute.equals((Object)GeneAttribute.TYPE)) continue;
            geneList.add(new GeneGroup(attribute, data.getAttributeValue(attribute).getSerializedName(), target.level().random.nextInt(40) + 15));
        }
        int typePurity = (Integer)ProductiveBeesConfig.BEE_ATTRIBUTES.typeGenePurity.get();
        geneList.add(new GeneGroup(GeneAttribute.TYPE, type, target.level().random.nextInt(Math.max(0, typePurity - 5)) + 10));
        stack.set(ModDataComponents.GENE_GROUP_LIST, geneList);
        stack.set(ModDataComponents.BEE_NAME, (Object)name);
    }

    @Nullable
    public static List<GeneGroup> getGenes(ItemStack stack) {
        if (stack.has(ModDataComponents.GENE_GROUP_LIST)) {
            return (List)stack.get(ModDataComponents.GENE_GROUP_LIST);
        }
        return null;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"productivebees.gene_bottle.tooltip.bee", (Object[])new Object[]{Component.literal((String)((String)stack.get(ModDataComponents.BEE_NAME))).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.DARK_GREEN));
        tooltipComponents.add((Component)Component.translatable((String)"productivebees.gene_bottle.tooltip.use").withStyle(ChatFormatting.DARK_GREEN));
    }
}

