/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.capabilities.attributes.BeeAttributesHandler;
import cy.jdkdigital.productivebees.client.particle.NectarParticleType;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.AmberBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.IEffectBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.compat.sussy.SussyCompatHandler;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModParticles;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeEffect;
import cy.jdkdigital.productivebees.util.BeeHelper;
import cy.jdkdigital.productivebees.util.ColorUtil;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneValue;
import cy.jdkdigital.productivelib.registry.LibItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

public class ConfigurableBee
extends ProductiveBee
implements IEffectBeeEntity {
    private int attackCooldown = 0;
    public int breathCollectionCooldown = 600;
    private int teleportCooldown = 250;
    public Mob target = null;
    public static final EntityDataAccessor<String> TYPE = SynchedEntityData.defineId(ConfigurableBee.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public ConfigurableBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
        this.beehiveInterests = poi -> poi.is(PoiTypeTags.BEE_HOME) || poi.value() == ModPointOfInterestTypes.NETHER_NEST.get() || poi.value() == ModPointOfInterestTypes.SOLITARY_HIVE.get() && this.isWild() || poi.value() == ModPointOfInterestTypes.SOLITARY_NEST.get() && this.isWild() || poi.value() == ModPointOfInterestTypes.DRACONIC_NEST.get() && this.isDraconic() || poi.value() == ModPointOfInterestTypes.SUGARBAG_NEST.get() && this.getBeeType().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"sugarbag"));
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            --this.teleportCooldown;
            if (--this.attackCooldown < 0) {
                this.attackCooldown = 0;
            }
            if (this.attackCooldown == 0 && this.isAngry() && this.getTarget() != null && this.getTarget().distanceToSqr((Entity)this) < 4.0) {
                this.attackCooldown = this.getEffectCooldown(this.getAttributeValue(GeneAttribute.TEMPER));
                this.attackTarget(this.getTarget());
            }
            if (!this.hasNectar() && this.level().dimension() == Level.END && this.isDraconic() && --this.breathCollectionCooldown <= 0) {
                this.breathCollectionCooldown = 600;
                this.internalSetHasNectar(true);
            }
            if (this.tickCount % 21 == 0 && this.hasNectar() && this.isRedstoned()) {
                for (int i = 1; i <= 2; ++i) {
                    BlockPos beePosDown = this.blockPosition().below(i);
                    if (!this.level().isEmptyBlock(beePosDown)) continue;
                    BlockState redstoneState = ((Block)ModBlocks.INVISIBLE_REDSTONE_BLOCK.get()).defaultBlockState();
                    this.level().setBlockAndUpdate(beePosDown, redstoneState);
                    this.level().scheduleTick(beePosDown, redstoneState.getBlock(), 20);
                }
            }
            if (this.target != null) {
                if (!this.hasNectar()) {
                    this.target.getNavigation().setSpeedModifier(0.01);
                } else {
                    this.target.setTarget((LivingEntity)this);
                    this.target = null;
                }
            }
            if (this.tickCount > 5 && ((String)this.entityData.get(TYPE)).isEmpty() && this.isAlive()) {
                this.kill();
            }
        }
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.isAlive() && this.tickCount % 120 == 0 && this.canSelfHeal() && this.getHealth() < this.getMaxHealth()) {
            this.addEffect(new MobEffectInstance(MobEffects.HEAL, 1));
        }
    }

    public boolean doHurtTarget(Entity entity) {
        AttributeInstance attackDamage = this.getAttribute(Attributes.ATTACK_DAMAGE);
        if (attackDamage != null && this.getDamage() > 2.0 && !attackDamage.hasModifier(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"extra_damage"))) {
            double damageModifier = this.getDamage();
            if (entity.level().getLevelData().isHardcore()) {
                damageModifier = Math.min(damageModifier, 1000.0);
            }
            attackDamage.addTransientModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"extra_damage"), damageModifier, AttributeModifier.Operation.ADD_VALUE));
        }
        return super.doHurtTarget(entity);
    }

    public void spawnFluidParticle(Level pLevel, double pStartX, double pEndX, double pStartZ, double pEndZ, double pPosY, ParticleOptions pParticleOption) {
        NectarParticleType particle;
        switch (this.getParticleType()) {
            case "pop": {
                NectarParticleType nectarParticleType = (NectarParticleType)((Object)ModParticles.COLORED_POPPING_NECTAR.get());
                break;
            }
            case "lava": {
                NectarParticleType nectarParticleType = (NectarParticleType)((Object)ModParticles.COLORED_LAVA_NECTAR.get());
                break;
            }
            case "portal": {
                NectarParticleType nectarParticleType = (NectarParticleType)((Object)ModParticles.COLORED_PORTAL_NECTAR.get());
                break;
            }
            case "rising": {
                NectarParticleType nectarParticleType = (NectarParticleType)((Object)ModParticles.COLORED_RISING_NECTAR.get());
                break;
            }
            default: {
                NectarParticleType nectarParticleType = particle = (NectarParticleType)((Object)ModParticles.COLORED_FALLING_NECTAR.get());
            }
        }
        if (this.hasParticleColor()) {
            particle.setColor(ColorUtil.getCacheColor(this.getParticleColor()));
        } else {
            particle.setColor(new float[]{0.92f, 0.782f, 0.72f});
        }
        pLevel.addParticle((ParticleOptions)particle, Mth.lerp((double)pLevel.random.nextDouble(), (double)pStartX, (double)pEndX), pPosY, Mth.lerp((double)pLevel.random.nextDouble(), (double)pStartZ, (double)pEndZ), 0.0, 0.0, 0.0);
    }

    @Override
    protected void customServerAiStep() {
        if (this.teleportCooldown <= 0) {
            if (null != this.navigation.getPath() && this.isTeleporting()) {
                AdvancedBeehiveBlockEntity advancedBeehiveBlockEntity;
                int antiTeleportUpgrades;
                BlockEntity te;
                if (this.hasHive() && (te = this.level().getBlockEntity(this.getHivePos())) instanceof AdvancedBeehiveBlockEntity && (antiTeleportUpgrades = (advancedBeehiveBlockEntity = (AdvancedBeehiveBlockEntity)te).getUpgradeCount((Item)LibItems.UPGRADE_ANTI_TELEPORT.get())) > 0) {
                    this.teleportCooldown = 10000;
                    super.customServerAiStep();
                    return;
                }
                BlockPos pos = this.navigation.getPath().getTarget();
                this.teleport(pos.getX(), pos.getY(), pos.getZ());
            }
            this.teleportCooldown = 250;
        }
        super.customServerAiStep();
    }

    public void makeStuckInBlock(BlockState state, Vec3 motionMultiplierIn) {
        if (!this.isStringy() || state.getBlock() != Blocks.COBWEB) {
            super.makeStuckInBlock(state, motionMultiplierIn);
        }
    }

    public boolean canFreeze() {
        return !this.isColdResistant() && super.canFreeze();
    }

    @Override
    public void attackTarget(LivingEntity target) {
        if (this.isAlive() && this.getNBTData().contains("attackResponse")) {
            String attackResponse;
            switch (attackResponse = this.getNBTData().getString("attackResponse")) {
                case "fire": {
                    target.setRemainingFireTicks(200);
                }
                case "lava": {
                    this.level().setBlock(target.blockPosition(), Blocks.LAVA.defaultBlockState(), 11);
                }
            }
        }
    }

    public void setBeeType(String data) {
        this.entityData.set(TYPE, (Object)data);
    }

    @Override
    @Nullable
    public ResourceLocation getBeeType() {
        return ResourceLocation.tryParse((String)((String)this.entityData.get(TYPE)));
    }

    public float getSpeed() {
        return super.getSpeed() * this.getSpeedModifier();
    }

    @Override
    public void setHasStung(boolean hasStung) {
        if (!this.isStingless()) {
            super.setHasStung(hasStung);
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> param) {
        if (TYPE.equals(param)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(param);
    }

    @Override
    public void setDefaultAttributes() {
        if (!this.hasBeeAttributes()) {
            BeeAttributesHandler attributes = (BeeAttributesHandler)this.getData(ProductiveBees.ATTRIBUTE_HANDLER);
            CompoundTag nbt = this.getNBTData();
            if (nbt.contains("productivity")) {
                attributes.setAttributeValue(GeneAttribute.PRODUCTIVITY, GeneValue.byName(nbt.getString("productivity")));
            }
            if (nbt.contains("temper")) {
                attributes.setAttributeValue(GeneAttribute.TEMPER, GeneValue.byName(nbt.getString("temper")));
            }
            if (nbt.contains("endurance")) {
                attributes.setAttributeValue(GeneAttribute.ENDURANCE, GeneValue.byName(nbt.getString("endurance")));
            }
            if (nbt.contains("behavior")) {
                attributes.setAttributeValue(GeneAttribute.BEHAVIOR, GeneValue.byName(nbt.getString("behavior")));
            }
            if (nbt.contains("weather_tolerance")) {
                attributes.setAttributeValue(GeneAttribute.WEATHER_TOLERANCE, GeneValue.byName(nbt.getString("weather_tolerance")));
            }
            this.setData(ProductiveBees.ATTRIBUTE_HANDLER, attributes);
            String type = this.getBeeType().toString();
            if (type.equals("productivebees:ghostly") && this.random.nextFloat() < 0.02f) {
                this.setCustomName((Component)Component.literal((String)"BooBee"));
            } else if (type.equals("productivebees:blitz") && this.random.nextFloat() < 0.02f) {
                this.setCustomName((Component)Component.literal((String)"King BitzBee"));
            } else if (type.equals("productivebees:basalz") && this.random.nextFloat() < 0.02f) {
                this.setCustomName((Component)Component.literal((String)"Queen BazBee"));
            } else if (type.equals("productivebees:blizz") && this.random.nextFloat() < 0.02f) {
                this.setCustomName((Component)Component.literal((String)"Shiny BizBee"));
            } else if (type.equals("productivebees:redstone") && this.random.nextFloat() < 0.01f) {
                this.setCustomName((Component)Component.literal((String)"Redastone Bee"));
            } else if (type.equals("productivebees:destabilized_redstone") && this.random.nextFloat() < 0.1f) {
                this.setCustomName((Component)Component.literal((String)"Destabilized RedaStone Bee"));
            } else if (type.equals("productivebees:compressed_iron") && this.random.nextFloat() < 0.05f) {
                this.setCustomName((Component)Component.literal((String)"Depressed Iron Bee"));
            } else if (type.equals("productivebees:sponge") && this.random.nextFloat() < 0.05f) {
                this.setCustomName((Component)Component.literal((String)"SpongeBee BlockPants"));
            } else if (type.equals("productivebees:infinity") && this.random.nextFloat() < 0.25f) {
                this.setCustomName((Component)Component.literal((String)"Infinibee"));
            } else if (type.equals("productivebees:allergy") && this.random.nextFloat() < 0.25f) {
                this.setCustomName((Component)Component.literal((String)"Beenadryl Buzz"));
            } else if (type.equals("productivebees:gregstar") && this.random.nextFloat() < 0.25f) {
                this.setCustomName((Component)Component.literal((String)"Monsieur Greg"));
            } else if (type.equals("productivebees:water") && this.random.nextFloat() < 0.05f) {
                switch (this.random.nextInt(5)) {
                    case 0: {
                        this.setCustomName((Component)Component.literal((String)"Wet Bee"));
                        break;
                    }
                    case 1: {
                        this.setCustomName((Component)Component.literal((String)"Splashy Bee"));
                        break;
                    }
                    case 2: {
                        this.setCustomName((Component)Component.literal((String)"Fishy Bee"));
                        break;
                    }
                    case 3: {
                        this.setCustomName((Component)Component.literal((String)"Moist Bee"));
                        break;
                    }
                    case 4: {
                        this.setCustomName((Component)Component.literal((String)"Dripping Bee"));
                    }
                }
            } else if (type.equals("productivebees:beebee") && this.random.nextFloat() < 0.5f) {
                switch (this.random.nextInt(8)) {
                    case 0: {
                        this.setCustomName((Component)Component.literal((String)"Dova Bee"));
                        break;
                    }
                    case 1: {
                        this.setCustomName((Component)Component.literal((String)"Beepocalypse"));
                        break;
                    }
                    case 2: {
                        this.setCustomName((Component)Component.literal((String)"Jeepers Beepers"));
                        break;
                    }
                    case 3: {
                        this.setCustomName((Component)Component.literal((String)"Darth Propolis"));
                        break;
                    }
                    case 4: {
                        this.setCustomName((Component)Component.literal((String)"The Ter-Bee-Nator"));
                        break;
                    }
                    case 5: {
                        this.setCustomName((Component)Component.literal((String)"BeelzeBeeb"));
                        break;
                    }
                    case 6: {
                        this.setCustomName((Component)Component.literal((String)"B-1000"));
                        break;
                    }
                    case 7: {
                        this.setCustomName((Component)Component.literal((String)"Bzz Ro Dah"));
                    }
                }
            } else if (type.equals("productivebees:royal")) {
                String[] names = new String[]{"Natalie", "Fiona", "Ysabelle", "Ada", "Alexandra", "Bianca", "Cherry", "Elizabeth", "Jasmine", "Coral", "Candy", "Ariel", "Dawn", "Faye", "Diana", "Hope", "Genevieve", "Grace", "Eleanor", "Helena", "Eve", "Joy", "Lydia", "Marigold", "Karen", "Marilyn", "Rosalyn", "Nadia", "Patty", "Peach", "Stephanie", "Sophia", "Violette", "Willow", "Zoe", "Merida", "Belle"};
                this.setCustomName((Component)Component.literal((String)("Princess " + names[this.random.nextInt(names.length)])));
            }
        }
    }

    @Override
    public int getColor(int tintIndex, float partialTicks) {
        CompoundTag nbt = this.getNBTData();
        if (nbt.contains("primaryColor")) {
            if (nbt.getBoolean("colorCycle") && !nbt.getString("renderer").contains("crystal")) {
                return ColorUtil.getCycleColor(nbt.getInt("primaryColor"), nbt.getInt("tertiaryColor"), this.tickCount, partialTicks);
            }
            return tintIndex == 0 ? nbt.getInt("primaryColor") : nbt.getInt("secondaryColor");
        }
        return super.getColor(tintIndex, partialTicks);
    }

    public int getParticleColor() {
        return this.getNBTData().getInt("particleColor");
    }

    public int getTertiaryColor(float partialTicks) {
        CompoundTag nbt = this.getNBTData();
        if (nbt.getBoolean("colorCycle") && nbt.getString("renderer").contains("crystal")) {
            return ColorUtil.getCycleColor(nbt.getInt("primaryColor"), nbt.getInt("tertiaryColor"), this.tickCount, partialTicks);
        }
        return nbt.getInt("tertiaryColor");
    }

    @Override
    public boolean isColored() {
        return !this.hasBeeTexture();
    }

    @Nonnull
    protected Component getTypeName() {
        CompoundTag nbt = this.getNBTData();
        if (nbt != null) {
            return Component.translatable((String)("entity.productivebees." + this.getBeeName() + "_bee"));
        }
        return super.getTypeName();
    }

    @Override
    public float getSizeModifier() {
        CompoundTag nbt = this.getNBTData();
        return nbt != null ? (this.hasNectar() ? nbt.getFloat("pollinatedSize") : nbt.getFloat("size")) : super.getSizeModifier();
    }

    public float getSpeedModifier() {
        CompoundTag nbt = this.getNBTData();
        return nbt != null ? nbt.getFloat("speed") : 1.0f;
    }

    public double getDamage() {
        CompoundTag nbt = this.getNBTData();
        return nbt != null ? nbt.getDouble("attack") : 2.0;
    }

    @Override
    public boolean canSelfBreed() {
        CompoundTag nbt = this.getNBTData();
        return nbt.getBoolean("selfbreed");
    }

    @Override
    public boolean isFlowerValid(BlockPos pos) {
        CompoundTag nbt;
        if (!this.level().isLoaded(pos)) {
            return false;
        }
        if (this.getFlowerType().equals("entity_types") && (nbt = this.getNBTData()) != null && nbt.contains("flowerTag")) {
            Object e;
            TagKey<EntityType<?>> entityTag = ModTags.getEntityTag(ResourceLocation.parse((String)nbt.getString("flowerTag")));
            BlockEntity blockEntity = this.level().getBlockEntity(pos);
            if (blockEntity instanceof AmberBlockEntity) {
                AmberBlockEntity amberBlockEntity = (AmberBlockEntity)blockEntity;
                Entity entity2 = amberBlockEntity.getCachedEntity();
                return entity2 != null && entity2.getType().is(entityTag);
            }
            List entities = this.level().getEntities((Entity)this, new AABB(pos).inflate(1.0, 1.0, 1.0), entity -> nbt.getBoolean("inverseFlower") != entity.getType().is(entityTag));
            if (!entities.isEmpty() && (e = entities.getFirst()) instanceof Mob) {
                Mob mob;
                this.target = mob = (Mob)e;
                this.target.addEffect(new MobEffectInstance(MobEffects.LUCK, 400));
                return true;
            }
        }
        return this.isFlowerValid(pos, this::isFlowerBlock, this::isFlowerItem);
    }

    @Override
    public boolean isFlowerBlock(BlockState flowerBlock) {
        if (flowerBlock.isAir()) {
            return false;
        }
        boolean canConvertBlock = BeeHelper.hasBlockConversionRecipe(this, flowerBlock);
        if (canConvertBlock) {
            return true;
        }
        CompoundTag nbt = this.getNBTData();
        if (nbt != null && this.getFlowerType().equals("blocks")) {
            if (nbt.contains("flowerTag")) {
                TagKey<Block> flowerTag = ModTags.getBlockTag(ResourceLocation.parse((String)nbt.getString("flowerTag")));
                return flowerBlock.is(flowerTag);
            }
            if (nbt.contains("flowerBlock")) {
                return BuiltInRegistries.BLOCK.getKey((Object)flowerBlock.getBlock()).toString().equals(nbt.getString("flowerBlock"));
            }
            if (nbt.contains("flowerFluid") && !flowerBlock.getFluidState().isEmpty()) {
                if (nbt.getString("flowerFluid").contains("#")) {
                    TagKey<Fluid> flowerFluid = ModTags.getFluidTag(ResourceLocation.parse((String)nbt.getString("flowerFluid").replace("#", "")));
                    return flowerBlock.getFluidState().is(flowerFluid);
                }
                return BuiltInRegistries.FLUID.getKey((Object)flowerBlock.getFluidState().getType()).toString().equals(nbt.getString("flowerFluid"));
            }
        }
        return false;
    }

    @Override
    public boolean isFlowerItem(ItemStack flowerItem) {
        BlockItem blockItem;
        Item item;
        if (flowerItem.isEmpty()) {
            return false;
        }
        CompoundTag nbt = this.getNBTData();
        if (nbt != null && this.getFlowerType().equals("blocks")) {
            if (nbt.contains("flowerTag")) {
                TagKey<Item> flowerTag = ModTags.getItemTag(ResourceLocation.parse((String)nbt.getString("flowerTag")));
                return flowerItem.is(flowerTag);
            }
            if (nbt.contains("flowerItem")) {
                return flowerItem.is((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)nbt.getString("flowerItem"))));
            }
            if (nbt.contains("flowerFluid") && (item = flowerItem.getItem()) instanceof BucketItem) {
                TagKey<Fluid> flowerFluid;
                BucketItem bucketItem = (BucketItem)item;
                if (nbt.getString("flowerFluid").contains("#")) {
                    flowerFluid = ModTags.getFluidTag(ResourceLocation.parse((String)nbt.getString("flowerFluid").replace("#", "")));
                    return bucketItem.content.is(flowerFluid);
                }
                flowerFluid = (TagKey<Fluid>)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)nbt.getString("flowerFluid")));
                return bucketItem.content.isSame(flowerFluid);
            }
        }
        if ((item = flowerItem.getItem()) instanceof BlockItem && BeeHelper.hasBlockConversionRecipe(this, (blockItem = (BlockItem)item).getBlock().defaultBlockState())) {
            return true;
        }
        return BeeHelper.hasItemConversionRecipe(this, flowerItem);
    }

    @Override
    public Ingredient getBreedingIngredient() {
        return ConfigurableBee.getBreedingIngredientFromString(this.getNBTData().getString("breedingItem"));
    }

    public static Ingredient getBreedingIngredientFromString(String id) {
        if (id.isEmpty()) {
            return Ingredient.of(ModTags.DEFAULT_BREEDING);
        }
        if (id.startsWith("#")) {
            return Ingredient.of(ModTags.getItemTag(ResourceLocation.parse((String)id.substring(1))));
        }
        return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)id))});
    }

    @Override
    public Integer getBreedingItemCount() {
        return this.getNBTData().getInt("breedingItemCount");
    }

    @Override
    public TagKey<Block> getNestingTag() {
        CompoundTag nbt = this.getNBTData();
        if (nbt != null && nbt.contains("nestingPreference")) {
            return ModTags.getBlockTag(ResourceLocation.parse((String)nbt.getString("nestingPreference")));
        }
        return super.getNestingTag();
    }

    @Override
    public BeeEffect getBeeEffect() {
        CompoundTag nbt = this.getNBTData();
        if (nbt.contains("effect")) {
            return new BeeEffect((HolderLookup.Provider)this.level().registryAccess(), nbt.getCompound("effect"));
        }
        return super.getBeeEffect();
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(TYPE, (Object)"");
    }

    @Override
    public void readAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setBeeType(compound.getString("type"));
        this.breathCollectionCooldown = compound.getInt("breathCollectionCooldown");
    }

    @Override
    public void addAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("type", this.getBeeType().toString());
        compound.putInt("breathCollectionCooldown", this.breathCollectionCooldown);
    }

    public CompoundTag getNBTData() {
        CompoundTag nbt = BeeReloadListener.INSTANCE.getData(this.getBeeType());
        return nbt != null ? nbt : new CompoundTag();
    }

    public boolean hasBeeTexture() {
        return this.getNBTData().contains("beeTexture");
    }

    public String getBeeTexture() {
        return this.getNBTData().getString("beeTexture");
    }

    @Override
    public String getRenderer() {
        return this.getNBTData().getString("renderer");
    }

    public String getRenderTransform() {
        return this.getNBTData().getString("renderTransform");
    }

    public boolean useGlowLayer() {
        return this.getNBTData().getBoolean("useGlowLayer") || this.isRedstoned() && this.hasNectar();
    }

    private boolean isWild() {
        return this.getNBTData().contains("nestingPreference");
    }

    public boolean isFireproof() {
        return this.getNBTData().getBoolean("fireproof");
    }

    public boolean isWithered() {
        return this.getNBTData().getBoolean("withered");
    }

    public boolean isTranslucent() {
        return this.getNBTData().getBoolean("translucent");
    }

    public boolean isBlinding() {
        return this.getNBTData().getBoolean("blinding");
    }

    public boolean isDraconic() {
        return this.getNBTData().getBoolean("draconic");
    }

    public boolean isRedstoned() {
        return this.getNBTData().getBoolean("redstoned");
    }

    public boolean isSlimy() {
        return this.getNBTData().getBoolean("slimy");
    }

    public boolean isTeleporting() {
        return this.getNBTData().getBoolean("teleporting");
    }

    public boolean isStringy() {
        return this.getNBTData().getBoolean("stringy");
    }

    public boolean isStingless() {
        return this.getNBTData().getBoolean("stingless");
    }

    public boolean hasMunchies() {
        return this.getNBTData().getBoolean("munchies");
    }

    public boolean isWaterproof() {
        return this.getNBTData().getBoolean("waterproof");
    }

    public boolean isColdResistant() {
        return this.getNBTData().getBoolean("coldResistant");
    }

    public boolean isIrradiated() {
        return this.getNBTData().getBoolean("irradiated");
    }

    public String getParticleType() {
        return this.getNBTData().getString("particleType");
    }

    public boolean hasParticleColor() {
        return this.getNBTData().contains("particleColor");
    }

    public boolean canSelfHeal() {
        return this.getNBTData().getBoolean("selfheal");
    }

    @Override
    public String getFlowerType() {
        return this.getNBTData().getString("flowerType");
    }

    @Override
    public Map<Holder<MobEffect>, Integer> getAggressiveEffects() {
        if (this.isWithered()) {
            return new HashMap<Holder<MobEffect>, Integer>(){
                {
                    this.put(MobEffects.WITHER, 350);
                }
            };
        }
        if (this.hasMunchies()) {
            return new HashMap<Holder<MobEffect>, Integer>(){
                {
                    this.put(MobEffects.HUNGER, 530);
                }
            };
        }
        if (this.isBlinding()) {
            return new HashMap<Holder<MobEffect>, Integer>(){
                {
                    this.put(MobEffects.BLINDNESS, 450);
                }
            };
        }
        return null;
    }

    public List<String> getInvulnerabilities() {
        Tag inv = this.getNBTData().get("invulnerability");
        ArrayList<String> list = new ArrayList<String>();
        if (inv instanceof ListTag) {
            ListTag listInv = (ListTag)inv;
            listInv.forEach(tag -> list.add(tag.getAsString()));
        }
        return list;
    }

    @Override
    public boolean isInvulnerableTo(@Nonnull DamageSource source) {
        if (this.isWithered() && source.equals(this.level().damageSources().wither())) {
            return true;
        }
        if (this.isDraconic() && source.equals(this.level().damageSources().dragonBreath())) {
            return true;
        }
        if (this.isTranslucent() && source.equals(this.level().damageSources().anvil((Entity)this))) {
            return true;
        }
        if (this.isWaterproof() && source.equals(this.level().damageSources().drown())) {
            return true;
        }
        if (this.isColdResistant() && source.equals(this.level().damageSources().freeze())) {
            return true;
        }
        if (this.isFireproof() && (source.equals(this.level().damageSources().hotFloor()) || source.equals(this.level().damageSources().inFire()) || source.equals(this.level().damageSources().onFire()) || source.equals(this.level().damageSources().lava()))) {
            return true;
        }
        return super.isInvulnerableTo(source) || this.getInvulnerabilities().contains(source.getMsgId());
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        if (this.isWithered()) {
            return effect.getEffect() != MobEffects.WITHER && super.canBeAffected(effect);
        }
        return super.canBeAffected(effect);
    }

    private void teleport(double x, double y, double z) {
        EntityTeleportEvent.EnderEntity event;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while (pos.getY() > this.level().getMinBuildHeight() && !this.level().getBlockState((BlockPos)pos).blocksMotion()) {
            pos.move(Direction.DOWN);
        }
        BlockState blockstate = this.level().getBlockState((BlockPos)pos);
        boolean flag = blockstate.blocksMotion();
        boolean flag1 = blockstate.getFluidState().is(FluidTags.WATER);
        if (flag && !flag1 && !(event = EventHooks.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z)).isCanceled()) {
            Vec3 vec3 = this.position();
            boolean flag2 = this.randomTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                this.level().gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)this));
                if (!this.isSilent()) {
                    this.level().playSound(null, this.xo, this.yo, this.zo, SoundEvents.ENDERMAN_TELEPORT, this.getSoundSource(), 1.0f, 1.0f);
                    this.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                }
            }
        }
    }

    @Override
    public void postPollinate() {
        super.postPollinate();
        if (this.getNBTData().contains("postPollination")) {
            switch (this.getNBTData().getString("postPollination")) {
                case "amber_encase": {
                    BeeHelper.encaseMob(this.target, this.level(), this.getDirection());
                    this.target = null;
                    break;
                }
                case "bonemeal": {
                    CropBlock cropBlock;
                    BlockState flower;
                    Block block;
                    Level level = this.level();
                    if (!(level instanceof ServerLevel)) break;
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (!this.hasSavedFlowerPos() || !((block = (flower = this.level().getBlockState(this.getSavedFlowerPos())).getBlock()) instanceof CropBlock) || !(cropBlock = (CropBlock)block).isValidBonemealTarget((LevelReader)this.level(), this.getSavedFlowerPos(), flower)) break;
                    cropBlock.performBonemeal(serverLevel, this.level().random, this.getSavedFlowerPos(), flower);
                    break;
                }
                case "force_grow_crop": {
                    CropBlock cropBlock;
                    Level flower = this.level();
                    if (!(flower instanceof ServerLevel)) break;
                    ServerLevel serverLevel = (ServerLevel)flower;
                    if (!this.hasSavedFlowerPos()) break;
                    BlockPos pos = this.getSavedFlowerPos();
                    BlockState flower2 = this.level().getBlockState(pos);
                    Block block = flower2.getBlock();
                    if (!(block instanceof CropBlock) || (cropBlock = (CropBlock)block).isMaxAge(flower2) || !CommonHooks.canCropGrow((Level)serverLevel, (BlockPos)pos, (BlockState)flower2, (boolean)true)) break;
                    serverLevel.setBlock(pos, cropBlock.getStateForAge(cropBlock.getAge(flower2) + 1), 2);
                    CommonHooks.fireCropGrowPost((Level)serverLevel, (BlockPos)pos, (BlockState)flower2);
                    break;
                }
                case "sus": {
                    ServerLevel level;
                    Level flower2;
                    if (this.savedFlowerPos == null || !((flower2 = this.level()) instanceof ServerLevel) || !((flower2 = (level = (ServerLevel)flower2).getBlockEntity(this.savedFlowerPos)) instanceof BrushableBlockEntity)) break;
                    BrushableBlockEntity brushableBlockEntity = (BrushableBlockEntity)flower2;
                    List<ResourceKey<LootTable>> possibleTables = SussyCompatHandler.getLootTables(level, this.savedFlowerPos);
                    if (possibleTables.isEmpty()) break;
                    brushableBlockEntity.setLootTable(possibleTables.get(level.getRandom().nextInt(possibleTables.size())), level.getRandom().nextLong());
                    this.savedFlowerPos = null;
                }
            }
        }
    }
}

