/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class SolitaryNestBlockEntity
extends AdvancedBeehiveBlockEntityAbstract {
    private int nestTickTimer = -1;
    private int spawnCount = 0;

    public SolitaryNestBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
        this.MAX_BEES = 1;
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)ModBlockEntityTypes.SOLITARY_NEST.get();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SolitaryNestBlockEntity blockEntity) {
        if (blockEntity.nestTickTimer > 0) {
            SolitaryNest nest;
            Entity newBee;
            Block block = state.getBlock();
            if (--blockEntity.nestTickTimer <= 0 && blockEntity.canRepopulate() && block instanceof SolitaryNest && (newBee = SolitaryNest.getNestingBeeType(nest = (SolitaryNest)block, level, (Holder<Biome>)level.getBiome(pos), level.random)) != null) {
                if (newBee instanceof ProductiveBee) {
                    ProductiveBee pBee = (ProductiveBee)newBee;
                    pBee.setDefaultAttributes();
                }
                Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
                SolitaryNestBlockEntity.spawnBeeInWorldAtPosition((ServerLevel)level, newBee, pos.relative(direction), direction, null);
                blockEntity.nestTickTimer = -1;
                if (newBee instanceof Bee) {
                    Bee bee = (Bee)newBee;
                    bee.setHealth(((Bee)newBee).getMaxHealth());
                    bee.hivePos = pos;
                }
            }
            blockEntity.setChanged();
        }
        AdvancedBeehiveBlockEntityAbstract.tick(level, pos, state, blockEntity);
    }

    public int getSpawnCount() {
        return this.spawnCount;
    }

    public boolean canRepopulate() {
        return this.canRepopulate(ItemStack.EMPTY);
    }

    public boolean canRepopulate(ItemStack heldItem) {
        SolitaryNest nest = (SolitaryNest)this.getBlockState().getBlock();
        boolean blockConditionsMet = false;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            blockConditionsMet = !SolitaryNest.getSpawningRecipes(nest, (Level)serverLevel, (Holder<Biome>)serverLevel.getBiome(this.getBlockPos()), heldItem).isEmpty();
        }
        return this.isEmpty() && blockConditionsMet;
    }

    public void setNestCooldown(int cooldown) {
        this.nestTickTimer = cooldown;
    }

    public int getNestTickCooldown() {
        return this.nestTickTimer;
    }

    @Override
    protected void beeReleasePostAction(Level level, Bee beeEntity, BlockState state, BeehiveBlockEntity.BeeReleaseStatus beeState) {
        super.beeReleasePostAction(level, beeEntity, state, beeState);
        if (beeEntity.getEncodeId() != null && this.getSpawnCount() < (Integer)ProductiveBeesConfig.BEES.cuckooSpawnCount.get() && !beeEntity.isBaby() && beeState == BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED && level.random.nextFloat() <= 0.1f) {
            Bee offspring;
            switch (beeEntity.getEncodeId()) {
                case "productivebees:blue_banded_bee": {
                    Bee bee = (Bee)((EntityType)ModEntities.NEON_CUCKOO_BEE.get()).create(level);
                    break;
                }
                case "productivebees:ashy_mining_bee": {
                    Bee bee = (Bee)((EntityType)ModEntities.NOMAD_BEE.get()).create(level);
                    break;
                }
                default: {
                    Bee bee = offspring = null;
                }
            }
            if (offspring != null) {
                ++this.spawnCount;
                offspring.setAge(-24000);
                offspring.moveTo(beeEntity.getX(), beeEntity.getY(), beeEntity.getZ(), 0.0f, 0.0f);
                if (offspring instanceof ProductiveBee) {
                    ProductiveBee pBee = (ProductiveBee)offspring;
                    pBee.setDefaultAttributes();
                }
                level.addFreshEntity((Entity)offspring);
            }
        }
        this.nestTickTimer = -1;
    }

    @Override
    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("nestTickTimer")) {
            this.nestTickTimer = tag.getInt("nestTickTimer");
        }
        if (tag.contains("spawnCount")) {
            this.spawnCount = tag.getInt("spawnCount");
        }
    }

    @Override
    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        tag.putInt("nestTickTimer", this.nestTickTimer);
        tag.putInt("spawnCount", this.spawnCount);
    }
}

