/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.xmod.cc;

import com.glodblock.github.modularbees.common.tileentities.hive.TileModularBeehive;
import com.glodblock.github.modularbees.util.BeeTable;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.GenericPeripheral;
import dan200.computercraft.api.peripheral.PeripheralType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class HivePeripheral
implements GenericPeripheral {
    @LuaFunction(mainThread=true)
    public final int getBeesCount(TileModularBeehive hive) {
        if (!hive.isFormed()) {
            return -1;
        }
        return hive.getBeeTable().getBeeCount();
    }

    @LuaFunction(mainThread=true)
    public final Object getBeeInfo(TileModularBeehive hive) {
        if (!hive.isFormed()) {
            return null;
        }
        HashMap<String, BeeInfo> result = new HashMap<String, BeeInfo>();
        List<BeeTable.BeeCache> raw = hive.getBeeTable().getData();
        for (BeeTable.BeeCache cache : raw) {
            if (!result.containsKey(cache.getID())) {
                result.put(cache.getID(), new BeeInfo());
            }
            BeeInfo info = (BeeInfo)result.get(cache.getID());
            if (cache.needLookup()) {
                hive.getBeeTable().link(cache);
            }
            if (cache.isBind()) {
                info.active = true;
            }
            ++info.count;
        }
        HashMap<String, Map<String, Object>> kv = new HashMap<String, Map<String, Object>>();
        for (Map.Entry e : result.entrySet()) {
            kv.put(ProductiveBee.getBeeName((ResourceLocation)ResourceLocation.parse((String)((String)e.getKey()))), this.wrapInfo((BeeInfo)e.getValue()));
        }
        return kv;
    }

    private Map<String, Object> wrapInfo(BeeInfo info) {
        HashMap<String, Object> kv = new HashMap<String, Object>();
        kv.put("status", info.active ? "Working" : "Idle");
        kv.put("count", info.count);
        return kv;
    }

    public String id() {
        return "modularbees:hive";
    }

    public PeripheralType getType() {
        return PeripheralType.ofType((String)"hive");
    }

    private static class BeeInfo {
        int count = 0;
        boolean active = false;

        private BeeInfo() {
        }
    }
}

