/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.util;

import com.glodblock.github.modularbees.common.tileentities.base.TileMBModularCore;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

public class StructureListener {
    private TileMBModularCore host;
    private boolean alive;

    public StructureListener(TileMBModularCore host) {
        this.host = host;
        this.alive = true;
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onUnload(LevelEvent.Unload e) {
        if (this.host != null && this.host.getLevel() == e.getLevel()) {
            this.invalidate();
        }
    }

    @SubscribeEvent
    public void onBlockUpdate(BlockEvent.NeighborNotifyEvent e) {
        if (this.host != null && this.host.getLevel() == e.getLevel()) {
            if (e.getPos().equals((Object)this.host.getBlockPos())) {
                this.host.onStateChange();
            }
            if (this.host.isStructurePos(e.getPos())) {
                this.host.onStructureChange();
            }
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load e) {
        if (this.host != null && this.host.getLevel() == e.getLevel() && this.host.isStructurePos(e.getChunk().getPos())) {
            this.host.onStructureChange();
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload e) {
        if (this.host != null && this.host.getLevel() == e.getLevel() && this.host.isStructurePos(e.getChunk().getPos())) {
            this.host.onStructureChange();
        }
    }

    public void invalidate() {
        if (!this.alive) {
            return;
        }
        this.alive = false;
        this.host = null;
        NeoForge.EVENT_BUS.unregister((Object)this);
    }
}

