/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.util;

import com.glodblock.github.modularbees.ModularBees;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.init.ModItems;
import it.unimi.dsi.fastutil.Hash;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Containers;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.DataComponentUtil;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GameUtil {
    public static final DecimalFormat NUMBER_F = new DecimalFormat("#,###.##");
    public static final StreamCodec<RegistryFriendlyByteBuf, BeehiveBlockEntity.BeeData> BEE_CODEC = StreamCodec.composite((StreamCodec)BeehiveBlockEntity.Occupant.STREAM_CODEC, BeehiveBlockEntity.BeeData::toOccupant, BeehiveBlockEntity.BeeData::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<BeehiveBlockEntity.BeeData>> BEES_CODEC = StreamCodec.of((buf, list) -> {
        buf.writeInt(list.size());
        list.forEach(bee -> BEE_CODEC.encode(buf, bee));
    }, buf -> {
        ArrayList<BeehiveBlockEntity.BeeData> list = new ArrayList<BeehiveBlockEntity.BeeData>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            list.add((BeehiveBlockEntity.BeeData)BEE_CODEC.decode(buf));
        }
        return list;
    });
    public static final Codec<ItemStack> UNLIMITED_ITEM_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(stack -> stack.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)Codec.INT.fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)stack, ItemStack::new)));
    public static final Hash.Strategy<ItemStack> ITEM_HASH = new Hash.Strategy<ItemStack>(){

        public int hashCode(@Nullable ItemStack stack) {
            if (stack == null) {
                return 0;
            }
            return ItemStack.hashItemAndComponents((ItemStack)stack);
        }

        public boolean equals(@Nullable ItemStack s1, @Nullable ItemStack s2) {
            if (s1 == s2) {
                return true;
            }
            if (s1 == null || s2 == null) {
                return false;
            }
            return ItemStack.isSameItemSameComponents((ItemStack)s1, (ItemStack)s2);
        }
    };

    public static void spawnDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        if (!level.isClientSide()) {
            for (ItemStack i : drops) {
                if (i.isEmpty()) continue;
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)i);
            }
        }
    }

    public static BlockState getBlockFromItem(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            return bi.getBlock().defaultBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    public static FluidStack getFluidFromItem(ItemStack stack) {
        IFluidHandlerItem tank = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (tank != null) {
            for (int x = 0; x < tank.getTanks(); ++x) {
                if (tank.getFluidInTank(x).isEmpty()) continue;
                return tank.getFluidInTank(x);
            }
        }
        return FluidStack.EMPTY;
    }

    public static ListTag saveItemList(List<ItemStack> items, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ListTag tag = new ListTag();
        if (!items.isEmpty()) {
            for (ItemStack stack : items) {
                if (stack.isEmpty()) continue;
                tag.add((Object)DataComponentUtil.wrapEncodingExceptions((DataComponentHolder)stack, UNLIMITED_ITEM_CODEC, (HolderLookup.Provider)provider));
            }
        }
        return tag;
    }

    public static void loadItemList(ListTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, List<ItemStack> list) {
        list.clear();
        if (!tag.isEmpty()) {
            for (Tag stack : tag) {
                UNLIMITED_ITEM_CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)stack).resultOrPartial(err -> ModularBees.LOGGER.error("Tried to load invalid item: '{}'", err)).ifPresent(list::add);
            }
        }
    }

    public static ListTag saveFluidList(List<FluidStack> fluids, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ListTag tag = new ListTag();
        if (!fluids.isEmpty()) {
            for (FluidStack stack : fluids) {
                if (stack.isEmpty()) continue;
                tag.add((Object)stack.save(provider));
            }
        }
        return tag;
    }

    public static void loadFluidList(ListTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, List<FluidStack> list) {
        list.clear();
        if (!tag.isEmpty()) {
            for (Tag stack : tag) {
                FluidStack.parse((HolderLookup.Provider)provider, (Tag)stack).ifPresent(list::add);
            }
        }
    }

    public static String readableCount(int count) {
        if (count < 1000) {
            return Integer.toString(count);
        }
        if (count < 10000) {
            float k = (float)count / 1000.0f;
            return String.format("%.1f", Float.valueOf(k)) + "k";
        }
        int k = count / 1000;
        return k + "k";
    }

    public static ItemStack emptyCage(ItemStack cage) {
        if (cage.getItem() == ModItems.STURDY_BEE_CAGE.get()) {
            return new ItemStack((Holder)ModItems.STURDY_BEE_CAGE);
        }
        return ItemStack.EMPTY;
    }
}

