/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.util;

import com.glodblock.github.modularbees.util.ChanceStack;
import com.glodblock.github.modularbees.util.GameUtil;
import cy.jdkdigital.productivebees.common.item.CombBlockItem;
import cy.jdkdigital.productivebees.common.item.Honeycomb;
import cy.jdkdigital.productivebees.common.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.util.BeeHelper;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.common.recipe.TagOutputRecipe;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CombCentrifugeLookup {
    private static final Object2ReferenceMap<RK, Output> RL_MAP = new Object2ReferenceOpenHashMap();
    private static final IdentityHashMap<Item, Output> ITEM_MAP = new IdentityHashMap();
    private static final Object2ReferenceMap<ItemStack, Output> NBT_MAP = new Object2ReferenceOpenCustomHashMap(GameUtil.ITEM_HASH);
    private static final Set<Item> VALID_INPUT = Collections.newSetFromMap(new IdentityHashMap());
    private static boolean needInit = true;
    private static final Consumer<ItemStack> PREPROCESS = CombCentrifugeLookup::filterWax;

    private CombCentrifugeLookup() {
    }

    public static boolean validInput(ItemStack stack, Level world) {
        if (stack.isEmpty() || world == null) {
            return false;
        }
        if (stack.is(ModTags.Common.HONEYCOMBS) || stack.is(ModTags.Common.STORAGE_BLOCK_HONEYCOMBS)) {
            return true;
        }
        if (needInit) {
            needInit = false;
            for (RecipeHolder holder : world.getRecipeManager().byType((RecipeType)ModRecipeTypes.CENTRIFUGE_TYPE.get())) {
                Ingredient input = ((CentrifugeRecipe)holder.value()).ingredient;
                for (ItemStack item : input.getItems()) {
                    if (stack.is(ModTags.Common.HONEYCOMBS) || stack.is(ModTags.Common.STORAGE_BLOCK_HONEYCOMBS)) continue;
                    VALID_INPUT.add(item.getItem());
                }
            }
        }
        return VALID_INPUT.contains(stack.getItem());
    }

    public static boolean query(Consumer<ItemStack> itemAcceptor, Consumer<FluidStack> fluidAcceptor, ItemStack comb, @NotNull Level world, int para, boolean heated) {
        ResourceLocation type;
        if (comb.isEmpty() || para <= 0) {
            return false;
        }
        Item item = comb.getItem();
        if (comb.is(ModTags.Common.STORAGE_BLOCK_HONEYCOMBS) && !heated) {
            return false;
        }
        Output cache = item instanceof Honeycomb || item instanceof CombBlockItem ? ((type = (ResourceLocation)comb.get(ModDataComponents.BEE_TYPE)) != null ? (Output)RL_MAP.get((Object)new RK(type, comb.is(ModTags.Common.STORAGE_BLOCK_HONEYCOMBS))) : (Output)NBT_MAP.get((Object)comb)) : (comb.isComponentsPatchEmpty() ? ITEM_MAP.get(item) : (Output)NBT_MAP.get((Object)comb));
        if (cache == null) {
            cache = CombCentrifugeLookup.lookupRecipe(comb, world);
        }
        if (cache != null) {
            cache.output(fluidAcceptor, para);
            if (heated) {
                cache.output(PREPROCESS.andThen(itemAcceptor), para, world.getRandom());
            } else {
                cache.output(itemAcceptor, para, world.getRandom());
            }
            return true;
        }
        return false;
    }

    private static void filterWax(ItemStack stack) {
        if (stack.is(ModTags.Common.WAXES)) {
            stack.setCount(0);
        }
    }

    @Nullable
    private static Output lookupRecipe(@NotNull ItemStack comb, @NotNull Level world) {
        ItemStack key = comb.copy();
        boolean isBlock = comb.is(ModTags.Common.STORAGE_BLOCK_HONEYCOMBS);
        if (isBlock) {
            key = BeeHelper.getSingleComb((ItemStack)comb);
        }
        if (key.isEmpty()) {
            return null;
        }
        InventoryHandlerHelper.BlockEntityItemStackHandler inv = new InventoryHandlerHelper.BlockEntityItemStackHandler(2);
        inv.setStackInSlot(1, key);
        RecipeHolder recipe = BeeHelper.getCentrifugeRecipe((Level)world, (InventoryHandlerHelper.BlockEntityItemStackHandler)inv);
        if (recipe == null) {
            return null;
        }
        Output output = new Output(((CentrifugeRecipe)recipe.value()).getRecipeOutputs().entrySet().stream().map(e -> ChanceStack.of((ItemStack)e.getKey(), CombCentrifugeLookup.mul4((TagOutputRecipe.ChancedOutput)e.getValue(), isBlock))).toList(), CombCentrifugeLookup.mul4(((CentrifugeRecipe)recipe.value()).getFluidOutputs(), isBlock));
        Item item = key.getItem();
        if (item instanceof Honeycomb) {
            ResourceLocation type = (ResourceLocation)key.get(ModDataComponents.BEE_TYPE);
            if (type != null) {
                RL_MAP.put((Object)new RK(type, isBlock), (Object)output);
            } else {
                NBT_MAP.put((Object)comb, (Object)output);
            }
        } else if (comb.isComponentsPatchEmpty()) {
            ITEM_MAP.put(comb.getItem(), output);
        } else {
            NBT_MAP.put((Object)comb, (Object)output);
        }
        return output;
    }

    private static TagOutputRecipe.ChancedOutput mul4(TagOutputRecipe.ChancedOutput origin, boolean enable) {
        if (!enable) {
            return origin;
        }
        float chance = origin.chance();
        if (chance * 4.0f <= 1.0f) {
            return new TagOutputRecipe.ChancedOutput(origin.ingredient(), origin.min(), origin.max(), chance * 4.0f);
        }
        if (chance * 2.0f <= 1.0f) {
            return new TagOutputRecipe.ChancedOutput(origin.ingredient(), origin.min() * 2, origin.max() * 2, chance * 2.0f);
        }
        return new TagOutputRecipe.ChancedOutput(origin.ingredient(), origin.min() * 4, origin.max() * 4, chance);
    }

    private static FluidStack mul4(FluidStack origin, boolean enable) {
        if (!enable || origin.isEmpty()) {
            return origin;
        }
        int amt = origin.getAmount();
        return origin.copyWithAmount(amt * 4);
    }

    private static void clear() {
        RL_MAP.clear();
        NBT_MAP.clear();
        ITEM_MAP.clear();
        VALID_INPUT.clear();
        needInit = true;
    }

    @SubscribeEvent
    public static void onReload(OnDatapackSyncEvent event) {
        CombCentrifugeLookup.clear();
    }

    record RK(ResourceLocation rl, boolean block) {
    }

    private record Output(List<ChanceStack> outputs, FluidStack fluid) {
        @Override
        @NotNull
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (ChanceStack stack : this.outputs) {
                sb.append("Type: ").append(stack.getClass().getSimpleName()).append(" ");
                sb.append("Stack: %s, Avg: %s, P: %s".formatted(stack.getBaseStack().getItem(), Float.valueOf(stack.getAverageAmount()), Float.valueOf(stack.getChance())));
            }
            return sb.toString();
        }

        void output(Consumer<ItemStack> collector, int multiplier, RandomSource random) {
            if (multiplier <= 8) {
                this.outputs.forEach(c -> {
                    for (int i = 0; i < multiplier; ++i) {
                        c.get(collector, random);
                    }
                });
            } else {
                this.outputs.forEach(c -> this.roll(collector, (ChanceStack)c, multiplier, random));
            }
        }

        void output(Consumer<FluidStack> collector, int multiplier) {
            if (!this.fluid.isEmpty()) {
                collector.accept(this.fluid.copyWithAmount(this.fluid.getAmount() * multiplier));
            }
        }

        void roll(Consumer<ItemStack> collector, ChanceStack chance, int n, RandomSource random) {
            double o;
            float p;
            ItemStack stack = chance.getBaseStack();
            float w = chance.getAverageAmount();
            double u = w * (float)n * (p = chance.getChance());
            int x = (int)Math.round(u + (o = Math.sqrt(w * w * (float)n * p * (1.0f - p))) * random.nextGaussian());
            if (x > 0) {
                collector.accept(stack.copyWithCount(x));
            }
        }
    }
}

