/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.util;

import com.glodblock.github.modularbees.common.tileentities.hive.TileBeehiveFeeder;
import com.glodblock.github.modularbees.util.ChanceStack;
import com.glodblock.github.modularbees.util.GameUtil;
import com.mojang.authlib.GameProfile;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.capabilities.attributes.BeeAttributesHandler;
import cy.jdkdigital.productivebees.common.block.Amber;
import cy.jdkdigital.productivebees.common.block.entity.AmberBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.recipe.AdvancedBeehiveRecipe;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.util.BeeHelper;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivelib.common.recipe.TagOutputRecipe;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public final class BeeTable {
    private final IdentityHashMap<IItemHandler, Int2ReferenceMap<List<BeeCache>>> index = new IdentityHashMap();
    private final List<BeeCache> data = new ArrayList<BeeCache>();
    private final Function<BeehiveBlockEntity.BeeData, TileBeehiveFeeder.FeedSlot> linker;
    private final BlockEntity host;
    private int dragonCount = 0;

    public BeeTable(BlockEntity host, Function<BeehiveBlockEntity.BeeData, TileBeehiveFeeder.FeedSlot> linker) {
        this.host = host;
        this.linker = linker;
    }

    public void loadBee(BeehiveBlockEntity.BeeData beeData) {
        CompoundTag tag = beeData.toOccupant().entityData().getUnsafe();
        if (tag.getString("type").equals("productivebees:draconic")) {
            ++this.dragonCount;
        }
        BeeCache cache = new BeeCache(beeData, this.host);
        this.data.add(cache);
        this.add(null, -1, cache);
    }

    public List<BeeCache> getData() {
        return this.data;
    }

    public void link(BeeCache cache) {
        TileBeehiveFeeder.FeedSlot result = this.linker.apply(cache.key);
        if (result.isSuccess()) {
            this.remove(cache);
            this.add(result.inv(), result.slot(), cache);
            cache.setIndex(result.inv(), result.slot());
        } else {
            this.remove(cache);
            this.add(null, -1, cache);
            cache.setIndex(null, -1);
        }
    }

    public void collectOutput(Level world, Consumer<ItemStack> collector) {
        for (BeeCache cache : this.data) {
            if (cache.needLookup()) {
                this.link(cache);
            }
            Output output = cache.getOutput();
            output.output(collector, world.getRandom());
        }
    }

    public void feederUpdate(IItemHandler inv, int slot) {
        List list;
        Int2ReferenceMap<List<BeeCache>> map;
        if (inv != null && slot != -1) {
            this.feederUpdate(null, -1);
        }
        if ((map = this.index.get(inv)) != null && (list = (List)map.get(slot)) != null) {
            list.forEach(BeeCache::unbind);
        }
    }

    public int getBeeCount() {
        return this.data.size();
    }

    public int getWorkingBee() {
        Int2ReferenceMap<List<BeeCache>> idle = this.index.get(null);
        if (idle == null) {
            return this.data.size();
        }
        return this.data.size() - ((List)idle.getOrDefault(-1, List.of())).size();
    }

    public int getDragonBee() {
        return this.dragonCount;
    }

    private void add(IItemHandler handler, int slot, BeeCache cache) {
        Int2ReferenceMap map = this.index.computeIfAbsent(handler, k -> new Int2ReferenceOpenHashMap());
        List list = (List)map.computeIfAbsent(slot, k -> new ArrayList());
        list.add(cache);
    }

    private void remove(BeeCache cache) {
        this.remove(cache.inv, cache.slot, cache);
    }

    private void remove(IItemHandler handler, int slot, BeeCache cache) {
        Int2ReferenceMap map = this.index.computeIfAbsent(handler, k -> new Int2ReferenceOpenHashMap());
        List list = (List)map.computeIfAbsent(slot, k -> new ArrayList());
        list.remove(cache);
    }

    public void clear() {
        this.data.clear();
        this.index.clear();
        this.dragonCount = 0;
    }

    public static class BeeCache {
        private static final Set<String> SPECIAL_BEES = Set.of("productivebees:lumber_bee", "productivebees:quarry_bee", "productivebees:dye_bee", "productivebees:wanna");
        private final BeehiveBlockEntity.BeeData key;
        private final String beeId;
        private Output output = null;
        private Supplier<Output> special = () -> Output.EMPTY;
        IItemHandler inv = null;
        int slot = -1;
        boolean needLookup = true;
        float geneBoost = 0.0f;

        BeeCache(BeehiveBlockEntity.BeeData key, BlockEntity host) {
            this.key = key;
            Level world = host.getLevel();
            if (world != null) {
                Entity entity = key.toOccupant().createEntity(world, host.getBlockPos());
                if (entity instanceof Bee) {
                    String string;
                    Bee bee = (Bee)entity;
                    if (entity.hasData(ProductiveBees.ATTRIBUTE_HANDLER)) {
                        int gene = ((BeeAttributesHandler)entity.getData(ProductiveBees.ATTRIBUTE_HANDLER)).getAttributeValue(GeneAttribute.PRODUCTIVITY).getValue();
                        this.geneBoost = gene == 0 ? 0.0f : (gene == 1 ? 1.0f : 1.0f / ((float)gene + 2.0f) + ((float)gene + 1.0f) / 2.0f);
                    }
                    if (bee instanceof ProductiveBee) {
                        ProductiveBee cBee = (ProductiveBee)bee;
                        string = Objects.requireNonNull(cBee.getBeeType()).toString();
                    } else {
                        string = bee.getEncodeId();
                    }
                    this.beeId = string;
                    RecipeHolder<AdvancedBeehiveRecipe> hiveRecipe = this.lookupRecipe(world);
                    if (hiveRecipe != null) {
                        Stream<ChanceStack> main = ((AdvancedBeehiveRecipe)hiveRecipe.value()).getRecipeOutputs().entrySet().stream().map(e -> ChanceStack.of((ItemStack)e.getKey(), this.add((TagOutputRecipe.ChancedOutput)e.getValue())));
                        float partial = this.geneBoost % 1.0f;
                        Stream<Object> left = Stream.empty();
                        if (!Mth.equal((float)partial, (float)0.0f)) {
                            left = ((AdvancedBeehiveRecipe)hiveRecipe.value()).getRecipeOutputs().entrySet().stream().map(e -> ChanceStack.of((ItemStack)e.getKey(), this.partial((TagOutputRecipe.ChancedOutput)e.getValue(), partial)));
                        }
                        this.output = new Output(Stream.concat(main, left).toList());
                    } else if (bee instanceof ProductiveBee && SPECIAL_BEES.contains(this.beeId)) {
                        this.special = () -> this.lookupSpecialOutput(world, host.getBlockPos());
                    }
                } else {
                    this.beeId = "";
                }
            } else {
                this.beeId = "";
            }
        }

        private TagOutputRecipe.ChancedOutput add(TagOutputRecipe.ChancedOutput origin) {
            if (this.geneBoost > 0.0f) {
                return new TagOutputRecipe.ChancedOutput(origin.ingredient(), (int)((float)origin.min() + this.geneBoost), (int)((float)origin.max() + this.geneBoost), origin.chance());
            }
            return origin;
        }

        private TagOutputRecipe.ChancedOutput partial(TagOutputRecipe.ChancedOutput origin, float partial) {
            return new TagOutputRecipe.ChancedOutput(origin.ingredient(), 1, 1, partial * origin.chance());
        }

        RecipeHolder<AdvancedBeehiveRecipe> lookupRecipe(Level world) {
            List allRecipes = world.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.ADVANCED_BEEHIVE_TYPE.get());
            BeeHelper.IdentifierInventory beeInv = new BeeHelper.IdentifierInventory(this.beeId);
            for (RecipeHolder recipe : allRecipes) {
                if (!((AdvancedBeehiveRecipe)recipe.value()).matches((RecipeInput)beeInv, world)) continue;
                return recipe;
            }
            return null;
        }

        public String getID() {
            return this.beeId;
        }

        @NotNull
        Output lookupSpecialOutput(Level world, BlockPos pos) {
            if (!this.isBind()) {
                return Output.EMPTY;
            }
            ItemStack input = this.inv.getStackInSlot(this.slot);
            if (input.isEmpty()) {
                return Output.EMPTY;
            }
            BlockState inputBlock = GameUtil.getBlockFromItem(input);
            float partial = this.geneBoost % 1.0f;
            switch (this.beeId) {
                case "productivebees:lumber_bee": {
                    if (!inputBlock.is(ModTags.LUMBER) || inputBlock.is(ModTags.DUPE_BLACKLIST)) break;
                    return new Output(List.of(new ChanceStack.CommonStack(input.copyWithCount(1 + (int)this.geneBoost)), new ChanceStack.ChanceStackImpl(input.copyWithCount(1), partial)));
                }
                case "productivebees:quarry_bee": {
                    if (!inputBlock.is(ModTags.QUARRY) || inputBlock.is(ModTags.DUPE_BLACKLIST)) break;
                    return new Output(List.of(new ChanceStack.CommonStack(input.copyWithCount(1 + (int)this.geneBoost)), new ChanceStack.ChanceStackImpl(input.copyWithCount(1), partial)));
                }
                case "productivebees:dye_bee": {
                    ItemStack dye;
                    if (!inputBlock.is(BlockTags.FLOWERS) || (dye = BeeHelper.getRecipeOutputFromInput((Level)world, (Item)input.getItem())).isEmpty()) break;
                    dye.setCount((int)((float)dye.getCount() + this.geneBoost));
                    return new Output(List.of(new ChanceStack.CommonStack(dye), new ChanceStack.ChanceStackImpl(dye.copyWithCount(1), partial)));
                }
                case "productivebees:wanna": {
                    Entity entity;
                    CustomData tag;
                    if (!(inputBlock.getBlock() instanceof Amber) || (tag = (CustomData)input.get(DataComponents.ENTITY_DATA)) == null || !((entity = AmberBlockEntity.createEntity((Level)world, (CompoundTag)tag.copyTag())) instanceof Mob)) break;
                    Mob mob = (Mob)entity;
                    if (!(world instanceof ServerLevel)) break;
                    ServerLevel serverWorld = (ServerLevel)world;
                    LootTable loot = serverWorld.getServer().reloadableRegistries().getLootTable(mob.getLootTable());
                    return new Output(List.of(new MobOutput(mob, loot, serverWorld, pos, (int)this.geneBoost), ChanceStack.partial(new MobOutput(mob, loot, serverWorld, pos, 1), partial)));
                }
            }
            return Output.EMPTY;
        }

        void setIndex(IItemHandler inv, int slot) {
            this.inv = inv;
            this.slot = slot;
            this.needLookup = false;
        }

        void unbind() {
            this.inv = null;
            this.slot = -1;
            this.needLookup = true;
        }

        public boolean needLookup() {
            return this.needLookup;
        }

        Output getOutput() {
            if (this.isBind()) {
                if (this.output != null) {
                    return this.output;
                }
                return this.special.get();
            }
            return Output.EMPTY;
        }

        public boolean isBind() {
            return this.inv != null && this.slot >= 0;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == BeeCache.class) {
                return ((BeeCache)obj).key.equals(this.key);
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        record MobOutput(Mob mob, LootTable loot, ServerLevel world, BlockPos pos, int multiplier) implements ChanceStack
        {
            @Override
            public void get(Consumer<ItemStack> adder, RandomSource random) {
                if (this.loot != LootTable.EMPTY) {
                    FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)this.world, (GameProfile)new GameProfile(ModEntities.WANNA_BEE_UUID, "wanna_bee"));
                    LootParams.Builder lootContextBuilder = new LootParams.Builder(this.world);
                    lootContextBuilder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)fakePlayer);
                    lootContextBuilder.withParameter(LootContextParams.ORIGIN, (Object)this.pos.getCenter());
                    lootContextBuilder.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)this.world.damageSources().generic());
                    lootContextBuilder.withParameter(LootContextParams.TOOL, (Object)new ItemStack((ItemLike)Items.DIAMOND_AXE));
                    lootContextBuilder.withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)fakePlayer);
                    lootContextBuilder.withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)fakePlayer);
                    lootContextBuilder.withParameter(LootContextParams.THIS_ENTITY, (Object)this.mob);
                    ObjectArrayList items = this.loot.getRandomItems(lootContextBuilder.create(LootContextParamSets.ENTITY));
                    int size = items.size();
                    if (size > 0) {
                        items.stream().skip(random.nextInt(size)).filter(stack -> !stack.is(ModTags.WANNABEE_LOOT_BLACKLIST)).map(stack -> stack.copyWithCount(stack.getCount() * this.multiplier)).findAny().ifPresent(adder);
                    }
                }
            }

            @Override
            public ItemStack getBaseStack() {
                throw new UnsupportedOperationException();
            }

            @Override
            public float getChance() {
                throw new UnsupportedOperationException();
            }

            @Override
            public float getAverageAmount() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private record Output(List<ChanceStack> outputs) {
        static Output EMPTY = new Output(List.of());

        void output(Consumer<ItemStack> collector, RandomSource random) {
            this.outputs.forEach(c -> c.get(collector, random));
        }
    }
}

