/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.hive;

import com.glodblock.github.glodium.util.GlodUtil;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.caps.ItemHandlerHost;
import com.glodblock.github.modularbees.common.inventory.MBItemInventory;
import com.glodblock.github.modularbees.common.inventory.SlotListener;
import com.glodblock.github.modularbees.common.recipe.TreaterRecipe;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBModularCore;
import com.glodblock.github.modularbees.common.tileentities.hive.TileBeehivePart;
import com.glodblock.github.modularbees.common.tileentities.hive.TileModularBeehive;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileBeehiveTreater
extends TileBeehivePart
implements ItemHandlerHost,
SlotListener {
    private final MBItemInventory foods = new MBItemInventory(this, 6).inputOnly();
    private TreaterRecipe cache = null;
    private boolean stuck = false;

    public TileBeehiveTreater(BlockPos pos, BlockState state) {
        super(GlodUtil.getTileType(TileBeehiveTreater.class, TileBeehiveTreater::new, (Block)MBSingletons.MODULAR_TREATER), pos, state);
    }

    public float getBoostAndConsume(int bees) {
        TileMBModularCore tileMBModularCore;
        if (bees <= 0 || !((tileMBModularCore = this.core) instanceof TileModularBeehive)) {
            return 0.0f;
        }
        TileModularBeehive beehive = (TileModularBeehive)tileMBModularCore;
        TreaterRecipe find = this.findRecipe();
        if (find != null) {
            int want = bees;
            for (int x = 0; x < this.foods.getSlots(); ++x) {
                ItemStack extracted;
                int amt;
                ItemStack stack = this.foods.getStackInSlot(x);
                if (!find.isValidInput(stack) || (amt = (extracted = this.foods.forceExtractItem(x, want, false)).getCount()) <= 0) continue;
                if (!find.output().isEmpty()) {
                    beehive.addOutput(find.output().copyWithCount(amt));
                }
                if ((want -= amt) <= 0) break;
            }
            if (want == 0) {
                return Math.max(find.boost() - 1.0f, 0.0f);
            }
            return Math.max((find.boost() - 1.0f) * (float)(bees - want) / (float)bees, 0.0f);
        }
        return 0.0f;
    }

    @Override
    public MBItemInventory getHandlerByName(String name) {
        return this.foods;
    }

    @Override
    public IItemHandler getItemInventory() {
        return this.foods;
    }

    @Override
    public void saveTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveTag(data, provider);
        data.put("foods", (Tag)this.foods.serializeNBT(provider));
    }

    @Override
    public void loadTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadTag(data, provider);
        this.foods.deserializeNBT(provider, data.getCompound("foods"));
    }

    @Override
    public void addInventoryDrops(Level level, @NotNull BlockPos pos, List<ItemStack> drops) {
        drops.addAll(this.foods.toList());
    }

    @Nullable
    private TreaterRecipe findRecipe() {
        if (this.stuck || this.level == null) {
            return null;
        }
        if (this.cache != null && this.testRecipe(this.cache)) {
            return this.cache;
        }
        this.cache = null;
        for (RecipeHolder recipe : this.level.getRecipeManager().byType(TreaterRecipe.TYPE)) {
            if (this.foods.countStack(((TreaterRecipe)recipe.value())::isValidInput) <= 0) continue;
            this.cache = (TreaterRecipe)recipe.value();
            break;
        }
        if (this.cache == null) {
            this.stuck = true;
        }
        return this.cache;
    }

    private boolean testRecipe(@NotNull TreaterRecipe recipe) {
        return this.foods.countStack(recipe::isValidInput) > 0;
    }

    @Override
    public void onChange(IItemHandler inv, int slot) {
        if (inv == this.foods) {
            this.stuck = false;
        }
    }
}

