/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.centrifuge;

import com.glodblock.github.glodium.util.GlodUtil;
import com.glodblock.github.modularbees.common.MBConfig;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.caps.ItemHandlerHost;
import com.glodblock.github.modularbees.common.inventory.MBItemInventory;
import com.glodblock.github.modularbees.common.inventory.SlotListener;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBModularCore;
import com.glodblock.github.modularbees.common.tileentities.centrifuge.TileCentrifugePart;
import com.glodblock.github.modularbees.common.tileentities.centrifuge.TileModularCentrifuge;
import com.glodblock.github.modularbees.util.ServerTickTile;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileCentrifugeImport
extends TileCentrifugePart
implements ServerTickTile,
ItemHandlerHost,
SlotListener {
    private static final int AUTO_IMPORT_INTERVAL = (Integer)MBConfig.AUTO_IMPORT_INTERVAL.get();
    private final MBItemInventory inputs = new MBItemInventory(this, 9).setFilter(this::validInput).inputOnly();
    private BlockCapabilityCache<IItemHandler, Direction> itemCache;
    private long tick = 0L;

    public TileCentrifugeImport(BlockPos pos, BlockState state) {
        super(GlodUtil.getTileType(TileCentrifugeImport.class, TileCentrifugeImport::new, (Block)MBSingletons.MODULAR_CENTRIFUGE_IMPORT), pos, state);
    }

    public void onFacingChange() {
        this.itemCache = null;
        this.invalidateCapabilities();
    }

    @Override
    public void onChange(IItemHandler inv, int slot) {
        TileMBModularCore tileMBModularCore;
        if (inv == this.inputs && this.isActive() && (tileMBModularCore = this.core) instanceof TileModularCentrifuge) {
            TileModularCentrifuge centrifuge = (TileModularCentrifuge)tileMBModularCore;
            centrifuge.unblock();
        }
    }

    @Override
    @Nullable
    public MBItemInventory getHandlerByName(String name) {
        return this.inputs;
    }

    private boolean validInput(ItemStack stack) {
        TileMBModularCore tileMBModularCore;
        if (this.isActive() && (tileMBModularCore = this.core) instanceof TileModularCentrifuge) {
            TileModularCentrifuge centrifuge = (TileModularCentrifuge)tileMBModularCore;
            return centrifuge.validInput(stack);
        }
        return false;
    }

    @Override
    public void addInventoryDrops(Level level, @NotNull BlockPos pos, List<ItemStack> drops) {
        drops.addAll(this.inputs.toList());
    }

    @Override
    public void saveTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveTag(data, provider);
        data.put("inputs", (Tag)this.inputs.serializeNBT(provider));
    }

    @Override
    public void loadTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadTag(data, provider);
        this.inputs.deserializeNBT(provider, data.getCompound("inputs"));
    }

    public MBItemInventory getItemInventory() {
        return this.inputs;
    }

    @Override
    public void tickServer(Level world, BlockState state) {
        if (this.isActive()) {
            ++this.tick;
            if (this.tick % (long)AUTO_IMPORT_INTERVAL == 0L) {
                IItemHandler itemTarget;
                Direction facing = this.getFacing();
                if (this.itemCache == null) {
                    this.itemCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)world), (BlockPos)this.getBlockPos().relative(facing), (Object)facing.getOpposite());
                }
                if ((itemTarget = (IItemHandler)this.itemCache.getCapability()) != null) {
                    for (int x = 0; x < itemTarget.getSlots(); ++x) {
                        ItemStack stack = itemTarget.getStackInSlot(x);
                        ItemStack stored = stack.copy();
                        for (int y = 0; y < this.inputs.getSlots() && !stack.isEmpty(); ++y) {
                            stack = this.inputs.insertItem(y, stack, false);
                        }
                        itemTarget.extractItem(x, stored.getCount() - stack.getCount(), false);
                    }
                }
            }
        }
    }

    public Direction getFacing() {
        return MBSingletons.MODULAR_CENTRIFUGE_IMPORT.getFacing(this.getBlockState());
    }
}

