/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.centrifuge;

import com.glodblock.github.glodium.util.GlodUtil;
import com.glodblock.github.modularbees.common.MBConfig;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.caps.FluidHandlerHost;
import com.glodblock.github.modularbees.common.caps.ItemHandlerHost;
import com.glodblock.github.modularbees.common.inventory.ProxyFluidInventory;
import com.glodblock.github.modularbees.common.inventory.ProxyItemInventory;
import com.glodblock.github.modularbees.common.inventory.RandomAccessTank;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBModularCore;
import com.glodblock.github.modularbees.common.tileentities.centrifuge.TileCentrifugePart;
import com.glodblock.github.modularbees.common.tileentities.centrifuge.TileModularCentrifuge;
import com.glodblock.github.modularbees.util.ServerTickTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;

public class TileCentrifugeExport
extends TileCentrifugePart
implements ServerTickTile,
ItemHandlerHost,
FluidHandlerHost {
    private static final int AUTO_EXPORT_INTERVAL = (Integer)MBConfig.AUTO_EXPORT_INTERVAL.get();
    private static final List<ItemStack> EMPTY_ITEMS = new ArrayList<ItemStack>();
    private static final List<FluidStack> EMPTY_FLUIDS = new ArrayList<FluidStack>();
    private final IItemHandler item = new ProxyItemInventory(this::getHostItemInventory);
    private final IFluidHandler fluid = new ProxyFluidInventory(this::getHostFluidInventory);
    private BlockCapabilityCache<IItemHandler, Direction> itemCache;
    private BlockCapabilityCache<IFluidHandler, Direction> fluidCache;
    private long tick = 0L;

    public TileCentrifugeExport(BlockPos pos, BlockState state) {
        super(GlodUtil.getTileType(TileCentrifugeExport.class, TileCentrifugeExport::new, (Block)MBSingletons.MODULAR_CENTRIFUGE_EXPORT), pos, state);
    }

    private List<ItemStack> getSendingList() {
        TileMBModularCore tileMBModularCore;
        if (this.isActive() && (tileMBModularCore = this.core) instanceof TileModularCentrifuge) {
            TileModularCentrifuge centrifuge = (TileModularCentrifuge)tileMBModularCore;
            return centrifuge.getSending();
        }
        return EMPTY_ITEMS;
    }

    private List<FluidStack> getFillingList() {
        TileMBModularCore tileMBModularCore;
        if (this.isActive() && (tileMBModularCore = this.core) instanceof TileModularCentrifuge) {
            TileModularCentrifuge centrifuge = (TileModularCentrifuge)tileMBModularCore;
            return centrifuge.getFilling();
        }
        return EMPTY_FLUIDS;
    }

    private IItemHandler getHostItemInventory() {
        TileMBModularCore tileMBModularCore;
        if (this.isActive() && (tileMBModularCore = this.core) instanceof TileModularCentrifuge) {
            TileModularCentrifuge centrifuge = (TileModularCentrifuge)tileMBModularCore;
            return centrifuge.getHandlerByName("outputs");
        }
        return EmptyItemHandler.INSTANCE;
    }

    private RandomAccessTank getHostFluidInventory() {
        TileMBModularCore tileMBModularCore;
        if (this.isActive() && (tileMBModularCore = this.core) instanceof TileModularCentrifuge) {
            TileModularCentrifuge beehive = (TileModularCentrifuge)tileMBModularCore;
            return beehive.getFluidInventory();
        }
        return RandomAccessTank.EMPTY;
    }

    public void onFacingChange() {
        this.itemCache = null;
        this.fluidCache = null;
        this.invalidateCapabilities();
    }

    @Override
    public IItemHandler getItemInventory() {
        return this.item;
    }

    @Override
    public IFluidHandler getFluidInventory() {
        return this.fluid;
    }

    @Override
    public void tickServer(Level world, BlockState state) {
        if (this.isActive()) {
            ++this.tick;
            if (this.tick % (long)AUTO_EXPORT_INTERVAL == 0L) {
                IFluidHandler fluidTarget;
                IItemHandler itemTarget;
                Direction facing = this.getFacing();
                if (this.itemCache == null) {
                    this.itemCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)world), (BlockPos)this.getBlockPos().relative(facing), (Object)facing.getOpposite());
                }
                if (this.fluidCache == null) {
                    this.fluidCache = BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)((ServerLevel)world), (BlockPos)this.getBlockPos().relative(facing), (Object)facing.getOpposite());
                }
                if ((itemTarget = (IItemHandler)this.itemCache.getCapability()) != null) {
                    ItemStack stack;
                    List<ItemStack> sending = this.getSendingList();
                    for (int i = 0; i < sending.size(); ++i) {
                        stack = sending.get(i).copy();
                        for (int y = 0; y < itemTarget.getSlots() && !stack.isEmpty(); ++y) {
                            stack = itemTarget.insertItem(y, stack, false);
                        }
                        sending.set(i, stack);
                    }
                    sending.removeIf(ItemStack::isEmpty);
                    for (int x = 0; x < this.item.getSlots(); ++x) {
                        stack = this.item.getStackInSlot(x);
                        ItemStack stored = stack.copy();
                        for (int y = 0; y < itemTarget.getSlots() && !stack.isEmpty(); ++y) {
                            stack = itemTarget.insertItem(y, stack, false);
                        }
                        this.item.extractItem(x, stored.getCount() - stack.getCount(), false);
                    }
                }
                if ((fluidTarget = (IFluidHandler)this.fluidCache.getCapability()) != null) {
                    List<FluidStack> filling = this.getFillingList();
                    for (int i = 0; i < filling.size(); ++i) {
                        FluidStack stack = filling.get(i).copy();
                        if (stack.isEmpty()) continue;
                        int filled = fluidTarget.fill(stack, IFluidHandler.FluidAction.EXECUTE);
                        stack.shrink(filled);
                        filling.set(i, stack);
                    }
                    filling.removeIf(FluidStack::isEmpty);
                    RandomAccessTank racTank = this.getHostFluidInventory();
                    if (racTank != RandomAccessTank.EMPTY) {
                        for (int x = 0; x < racTank.getTanks(); ++x) {
                            FluidStack stack = racTank.getFluidInTank(x);
                            if (stack.isEmpty()) continue;
                            int filled = fluidTarget.fill(stack, IFluidHandler.FluidAction.EXECUTE);
                            racTank.getTank(x).drain(filled, IFluidHandler.FluidAction.EXECUTE);
                        }
                        FluidStack stack = this.fluid.getFluidInTank(0);
                        int filled = fluidTarget.fill(stack, IFluidHandler.FluidAction.EXECUTE);
                        this.fluid.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                    }
                }
            }
        }
    }

    public Direction getFacing() {
        return MBSingletons.MODULAR_CENTRIFUGE_EXPORT.getFacing(this.getBlockState());
    }
}

