/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.base;

import com.glodblock.github.modularbees.common.tileentities.base.TileMBBase;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBModularComponent;
import com.glodblock.github.modularbees.util.ServerTickTile;
import com.glodblock.github.modularbees.util.StructureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class TileMBModularCore
extends TileMBBase
implements ServerTickTile {
    private final List<TileMBModularComponent> components = new ArrayList<TileMBModularComponent>();
    private final StructureListener listener = new StructureListener(this);
    private boolean refresh = true;
    private boolean formed = false;

    public TileMBModularCore(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void onChunkUnloaded() {
        this.listener.invalidate();
        super.onChunkUnloaded();
    }

    public abstract boolean isStructurePos(BlockPos var1);

    public abstract boolean isStructurePos(ChunkPos var1);

    protected abstract boolean buildStructure(Consumer<TileMBModularComponent> var1, Level var2);

    protected abstract void logicTick(@NotNull Level var1, BlockState var2, List<TileMBModularComponent> var3);

    public void onStateChange() {
        this.formed = false;
        this.refresh = true;
        this.unlink();
    }

    public void onStructureChange() {
        if (this.isRemoved()) {
            return;
        }
        this.refresh = true;
    }

    public boolean isFormed() {
        return this.formed;
    }

    public void formStructure() {
        this.unlink();
        this.formed = false;
        this.formed = this.buildStructure(c -> {
            this.components.add((TileMBModularComponent)((Object)c));
            c.linkCore(this);
        }, this.level);
        this.refresh = false;
    }

    private void unlink() {
        this.components.forEach(c -> c.linkCore(null));
        this.components.clear();
    }

    @Override
    public void tickServer(Level world, BlockState state) {
        if (this.refresh) {
            this.formStructure();
        }
        if (this.formed) {
            this.logicTick(world, state, this.components);
        }
    }

    protected <T extends TileMBModularComponent> List<T> getComponents(Class<T> type) {
        if (!this.formed) {
            return List.of();
        }
        return this.components.stream().filter(type::isInstance).map(type::cast).toList();
    }
}

