/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.hooks;

import com.glodblock.github.modularbees.common.recipe.ElectrodeRecipe;
import com.glodblock.github.modularbees.util.GameUtil;
import java.util.Collection;
import java.util.IdentityHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class TooltipHook {
    public static final TooltipHook INSTANCE = new TooltipHook();
    private static final IdentityHashMap<Item, Float> CACHE = new IdentityHashMap();

    private TooltipHook() {
        assert (INSTANCE == null);
    }

    @SubscribeEvent
    public void onTooltipEvent(ItemTooltipEvent event) {
        Item item = event.getItemStack().getItem();
        if (CACHE.containsKey(item)) {
            event.getToolTip().add(Component.translatable((String)"modularbees.tooltip.electrode_power", (Object[])new Object[]{GameUtil.NUMBER_F.format(CACHE.get(item))}).withStyle(ChatFormatting.GOLD));
        }
    }

    @SubscribeEvent
    public void onRecipeUpdate(RecipesUpdatedEvent event) {
        CACHE.clear();
        Collection recipes = event.getRecipeManager().byType(ElectrodeRecipe.TYPE);
        for (RecipeHolder recipe : recipes) {
            CACHE.put(((ElectrodeRecipe)recipe.value()).electrode().getItem(), Float.valueOf(((ElectrodeRecipe)recipe.value()).power()));
        }
    }
}

