/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.blocks.hive;

import com.glodblock.github.modularbees.client.util.ConnectBlock;
import com.glodblock.github.modularbees.common.blocks.base.BlockMBGuiBase;
import com.glodblock.github.modularbees.common.blocks.hive.Hive;
import com.glodblock.github.modularbees.common.tileentities.hive.TileBeehiveAlveary;
import com.glodblock.github.modularbees.container.ContainerMBAlveary;
import com.glodblock.github.modularbees.container.base.MBGuiHandler;
import com.glodblock.github.modularbees.dynamic.DyResourcePack;
import com.glodblock.github.modularbees.util.ContainerResolver;
import com.glodblock.github.modularbees.util.GameUtil;
import cy.jdkdigital.productivebees.common.entity.bee.SolitaryBee;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;

public class BlockBeehiveAlveary
extends BlockMBGuiBase<TileBeehiveAlveary>
implements ConnectBlock,
Hive {
    public BlockBeehiveAlveary() {
        super(BlockBeehiveAlveary.hive());
    }

    @Override
    public ItemInteractionResult check(TileBeehiveAlveary tile, ItemStack stack, Level world, BlockPos pos, BlockHitResult hit, Player p) {
        if (!world.isClientSide()) {
            Entity entity;
            ItemStack one = stack.copyWithCount(1);
            if (BeeCage.isFilled((ItemStack)one) && tile.hasRoom()) {
                Bee bee = BeeCage.getEntityFromStack((ItemStack)one, (Level)world, (boolean)true);
                if (bee == null) {
                    p.displayClientMessage((Component)Component.translatable((String)"modularbees.gui.modular_beehive_alveary.invalid"), true);
                    return ItemInteractionResult.FAIL;
                }
                if (bee instanceof SolitaryBee) {
                    p.displayClientMessage((Component)Component.translatable((String)"modularbees.gui.modular_beehive_alveary.solitary"), true);
                    return ItemInteractionResult.FAIL;
                }
                if (bee.getAge() < 0) {
                    p.displayClientMessage((Component)Component.translatable((String)"modularbees.gui.modular_beehive_alveary.child"), true);
                    return ItemInteractionResult.FAIL;
                }
                tile.addBee(world, bee);
                tile.notifyCore();
                ItemStack empty = GameUtil.emptyCage(one);
                stack.shrink(1);
                if (!p.addItem(empty)) {
                    GameUtil.spawnDrops(world, p.getOnPos(), List.of(empty));
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (tile.isEmptyCage(one) && !tile.getBees().isEmpty() && (entity = tile.getBees().getLast().toOccupant().createEntity(world, pos)) instanceof Bee) {
                Bee bee = (Bee)entity;
                bee.setHivePos(pos);
                BeeCage.captureEntity((Bee)bee, (ItemStack)one);
                tile.getBees().removeLast();
                tile.setChanged();
                tile.notifyCore();
                stack.shrink(1);
                if (!p.addItem(one)) {
                    GameUtil.spawnDrops(world, p.getOnPos(), List.of(one));
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return null;
    }

    @Override
    public void openGui(TileBeehiveAlveary tile, Player p) {
        MBGuiHandler.open(ContainerMBAlveary.TYPE.type(), p, ContainerResolver.of(tile));
    }

    @Override
    public TagKey<Block> harvestTool() {
        return BlockTags.MINEABLE_WITH_AXE;
    }

    @Override
    protected void loadBlockModel(DyResourcePack pack) {
    }

    @Override
    public boolean canConnect(BlockGetter world, BlockPos otherPos) {
        return world.getBlockState(otherPos).getBlock() instanceof Hive;
    }
}

