/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.material.part;

import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.swedz.tesseract.neoforge.material.Material;
import net.swedz.tesseract.neoforge.material.MaterialRegistry;
import net.swedz.tesseract.neoforge.material.part.MaterialPart;
import net.swedz.tesseract.neoforge.material.part.MaterialPartAction;
import net.swedz.tesseract.neoforge.material.part.MaterialPartBlockFactory;
import net.swedz.tesseract.neoforge.material.part.MaterialPartHolder;
import net.swedz.tesseract.neoforge.material.part.MaterialPartItemFactory;
import net.swedz.tesseract.neoforge.material.part.RegisteredMaterialPart;
import net.swedz.tesseract.neoforge.material.property.MaterialProperty;
import net.swedz.tesseract.neoforge.material.property.MaterialPropertyHolder;
import net.swedz.tesseract.neoforge.material.property.MaterialPropertyMap;
import net.swedz.tesseract.neoforge.registry.holder.BlockWithItemHolder;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class MaterialPartRegisterContext
implements MaterialPropertyHolder,
MaterialPartHolder {
    private final ResourceLocation id;
    private final String englishName;
    private final MaterialRegistry registry;
    private final Material material;
    private final MaterialPart part;
    private final MaterialPropertyMap properties;
    private final MaterialPartBlockFactory blockFactory;
    private final MaterialPartItemFactory itemFactory;
    private final Collection<MaterialPartAction<ItemHolder<? extends Item>>> itemActions;
    private final Collection<MaterialPartAction<BlockWithItemHolder<Block, BlockItem>>> blockActions;
    private final Collection<MaterialPartAction<ItemHolder<? extends Item>>> itemAfterActions;
    private final Collection<MaterialPartAction<BlockWithItemHolder<Block, BlockItem>>> blockAfterActions;

    public MaterialPartRegisterContext(ResourceLocation id, String englishName, MaterialRegistry registry, Material material, MaterialPart part, MaterialPropertyMap properties, MaterialPartBlockFactory blockFactory, MaterialPartItemFactory itemFactory, Collection<MaterialPartAction<ItemHolder<? extends Item>>> itemActions, Collection<MaterialPartAction<BlockWithItemHolder<Block, BlockItem>>> blockActions, Collection<MaterialPartAction<ItemHolder<? extends Item>>> itemAfterActions, Collection<MaterialPartAction<BlockWithItemHolder<Block, BlockItem>>> blockAfterActions) {
        this.id = id;
        this.englishName = englishName;
        this.registry = registry;
        this.material = material;
        this.part = part;
        this.properties = properties;
        this.blockFactory = blockFactory;
        this.itemFactory = itemFactory;
        this.itemActions = itemActions;
        this.blockActions = blockActions;
        this.itemAfterActions = itemAfterActions;
        this.blockAfterActions = blockAfterActions;
    }

    public MaterialPartRegisterContext(ResourceLocation id, String englishName, MaterialRegistry registry, Material material, MaterialPart part, MaterialPartBlockFactory blockFactory, MaterialPartItemFactory itemFactory, Collection<MaterialPartAction<ItemHolder<? extends Item>>> itemActions, Collection<MaterialPartAction<BlockWithItemHolder<Block, BlockItem>>> blockActions, Collection<MaterialPartAction<ItemHolder<? extends Item>>> itemAfterActions, Collection<MaterialPartAction<BlockWithItemHolder<Block, BlockItem>>> blockAfterActions) {
        this(id, englishName, registry, material, part, material.properties(part), blockFactory, itemFactory, itemActions, blockActions, itemAfterActions, blockAfterActions);
    }

    public ResourceLocation id() {
        return this.id;
    }

    public String englishName() {
        return this.englishName;
    }

    public MaterialRegistry registry() {
        return this.registry;
    }

    public Material material() {
        return this.material;
    }

    public MaterialPart part() {
        return this.part;
    }

    public MaterialPropertyMap properties() {
        return this.properties;
    }

    @Override
    public <T> boolean has(MaterialProperty<T> property) {
        return this.properties.has(property);
    }

    @Override
    public <T> T get(MaterialProperty<T> property) {
        return this.properties.get(property);
    }

    @Override
    public boolean has(MaterialPart part) {
        return this.material.has(part);
    }

    @Override
    public RegisteredMaterialPart get(MaterialPart part) {
        return this.material.get(part);
    }

    public MaterialPartBlockFactory blockFactory() {
        return this.blockFactory;
    }

    public MaterialPartItemFactory itemFactory() {
        return this.itemFactory;
    }

    public void register(BlockWithItemHolder<Block, BlockItem> block) {
        ItemHolder<BlockItem> item = block.item();
        this.properties.apply(block);
        this.properties.apply(item);
        this.blockActions.forEach(a -> a.apply(this, block));
        this.itemActions.forEach(a -> a.apply(this, item));
        block.register();
        this.blockAfterActions.forEach(a -> a.apply(this, block));
        this.itemAfterActions.forEach(a -> a.apply(this, item));
        this.registry.onBlockRegister(block);
        this.registry.onItemRegister(item);
    }

    public void register(BlockEntityType<?> blockEntity) {
        this.registry.onBlockEntityRegister(blockEntity);
    }

    public void register(ItemHolder<? extends Item> item) {
        this.properties.apply(item);
        this.itemActions.forEach(a -> a.apply(this, item));
        item.register();
        this.itemAfterActions.forEach(a -> a.apply(this, item));
        this.registry.onItemRegister(item);
    }
}

