/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.lang;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.helper.NamingConventionHelper;
import net.swedz.tesseract.neoforge.interfaceproxy.InterfaceProxyHandler;
import net.swedz.tesseract.neoforge.lang.LangContext;
import net.swedz.tesseract.neoforge.lang.LangEntry;
import net.swedz.tesseract.neoforge.lang.LangManager;
import net.swedz.tesseract.neoforge.lang.annotation.LangKey;
import net.swedz.tesseract.neoforge.lang.annotation.LangKeyPattern;
import net.swedz.tesseract.neoforge.lang.annotation.Parsed;
import net.swedz.tesseract.neoforge.lang.annotation.WithStyle;
import net.swedz.tesseract.neoforge.lang.parser.LangEntryParser;
import net.swedz.tesseract.neoforge.lang.parser.ParserProvider;
import net.swedz.tesseract.neoforge.lang.style.LangEntryStyle;
import net.swedz.tesseract.neoforge.lang.style.StyleProvider;

public final class LangHandler
extends InterfaceProxyHandler<Component, LangEntry> {
    private final LangManager manager;

    public LangHandler(LangManager manager) {
        this.manager = manager;
    }

    private String createLangKey(Class<?> langClass, Method method) {
        LangKey annotation = method.getAnnotation(LangKey.class);
        Assert.notNull(annotation);
        if (!annotation.value().isEmpty()) {
            return annotation.value().replace("{}", this.manager.modId());
        }
        String prefix = langClass.isAnnotationPresent(LangKeyPattern.class) ? langClass.getAnnotation(LangKeyPattern.class).value() : "text.{}.";
        prefix = prefix.replace("{}", this.manager.modId());
        String key = !annotation.key().isEmpty() ? annotation.key() : NamingConventionHelper.fromCamelCaseToSnakeCase(method);
        return prefix + key;
    }

    private StyleProvider getStyle(WithStyle annotationStyle) {
        return annotationStyle != null ? this.manager.getStyle(annotationStyle.value()) : this.manager.getStyle("default");
    }

    private LangEntryParser[] getParsers(Method method) {
        LangEntryParser[] parsers = new LangEntryParser[method.getParameterCount()];
        for (int index = 0; index < method.getParameterCount(); ++index) {
            String parserKey;
            Parameter param = method.getParameters()[index];
            Class<?> paramType = param.getType();
            if (param.isAnnotationPresent(Parsed.class)) {
                Parsed annotationParsed = param.getAnnotation(Parsed.class);
                parserKey = annotationParsed.value();
            } else {
                parserKey = "default";
            }
            ParserProvider<Object> parser = this.manager.getParser(parserKey, paramType);
            if (param.isAnnotationPresent(WithStyle.class)) {
                WithStyle annotationStyle = param.getAnnotation(WithStyle.class);
                ParserProvider<?> finalParser = parser;
                parser = (context, value) -> {
                    StyleProvider style = this.getStyle(annotationStyle);
                    return finalParser.parse(context, value).copy().withStyle(style == null ? null : style.get(context));
                };
            }
            LangContext context2 = LangContext.of(param, this.manager::getStyle, this.manager::getParser);
            parsers[index] = new LangEntryParser(context2, parser);
        }
        return parsers;
    }

    private static boolean includeFallback(Class<?> proxyClass, LangKey methodAnnotation) {
        LangKeyPattern proxyAnnotation;
        if (proxyClass.isAnnotationPresent(LangKeyPattern.class) && (proxyAnnotation = proxyClass.getAnnotation(LangKeyPattern.class)).includeFallback().length > 0) {
            return proxyAnnotation.includeFallback()[0];
        }
        return methodAnnotation.includeFallback();
    }

    @Override
    protected Optional<LangEntry> generate(Class<?> proxyClass, Object proxy, Method method) {
        if (method.isAnnotationPresent(LangKey.class)) {
            LangKey annotation = method.getAnnotation(LangKey.class);
            String methodSignature = method.toGenericString();
            if (method.getReturnType().equals(MutableComponent.class)) {
                String key = this.createLangKey(proxyClass, method);
                StyleProvider style = this.getStyle(method.getAnnotation(WithStyle.class));
                LangEntryParser[] parsers = this.getParsers(method);
                LangEntry entry = new LangEntry(key, annotation.text().length == 0 ? null : annotation.text()[0], LangHandler.includeFallback(proxyClass, annotation), new LangEntryStyle(LangContext.of(method, this.manager::getStyle, this.manager::getParser), style), parsers);
                return Optional.of(entry);
            }
            throw new IllegalStateException("Method %s does not return MutableComponent".formatted(methodSignature));
        }
        return Optional.empty();
    }
}

