/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.interfaceproxy;

import java.lang.reflect.Proxy;
import net.swedz.tesseract.neoforge.interfaceproxy.InterfaceProxyHandler;
import net.swedz.tesseract.neoforge.interfaceproxy.InterfaceProxyInstance;

public abstract class InterfaceProxyManager<H extends InterfaceProxyHandler> {
    protected abstract <P> H createHandler(Class<P> var1);

    protected abstract <P> InterfaceProxyInstance<P, H> createInstance(Class<P> var1, P var2, H var3);

    public <P> InterfaceProxyInstance<P, H> build(Class<P> proxyClass) {
        try {
            H handler = this.createHandler(proxyClass);
            Object proxy = Proxy.newProxyInstance(proxyClass.getClassLoader(), new Class[]{proxyClass}, handler);
            return this.createInstance(proxyClass, proxy, handler);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static abstract class WithArgument<H extends InterfaceProxyHandler, A>
    extends InterfaceProxyManager<H> {
        protected abstract A defaultManagerArgument();

        @Override
        protected <P> H createHandler(Class<P> proxyClass) {
            return this.createHandler(proxyClass, this.defaultManagerArgument());
        }

        protected abstract <P> H createHandler(Class<P> var1, A var2);

        @Override
        public <P> InterfaceProxyInstance<P, H> build(Class<P> proxyClass) {
            return this.build(proxyClass, this.defaultManagerArgument());
        }

        public <P> InterfaceProxyInstance<P, H> build(Class<P> proxyClass, A arg) {
            try {
                H handler = this.createHandler(proxyClass, arg);
                Object proxy = Proxy.newProxyInstance(proxyClass.getClassLoader(), new Class[]{proxyClass}, handler);
                return this.createInstance(proxyClass, proxy, handler);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

