/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper;

import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NamingConventionHelper {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("([A-Z][a-z]+)|([a-z]+)|([0-9]+)|([A-Z]+(?![a-z]))");

    public static String fromCamelCaseToSnakeCase(String methodName) {
        StringBuilder generated = new StringBuilder();
        Matcher matcher = CAMEL_CASE_PATTERN.matcher(methodName);
        int lastEnd = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (lastEnd < start) {
                generated.append(methodName, lastEnd, start);
            }
            if (!generated.isEmpty()) {
                generated.append('_');
            }
            generated.append(methodName, start, end);
            lastEnd = end;
        }
        return generated.toString().toLowerCase();
    }

    public static String fromCamelCaseToSnakeCase(Method method) {
        return NamingConventionHelper.fromCamelCaseToSnakeCase(method.getName());
    }
}

