/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.swedz.tesseract.neoforge.config.exception.IllegalConfigOptionException;
import org.jetbrains.annotations.ApiStatus;

public final class Range {
    private static final Map<Class<? extends Annotation>, Class<? extends Number>> NUMBERS = Map.of(Integer.class, java.lang.Integer.class, Double.class, java.lang.Double.class, Long.class, java.lang.Long.class);

    @ApiStatus.Internal
    public static boolean maybeDefine(ModConfigSpec.Builder builder, String key, Object value, Method method) {
        for (Map.Entry<Class<? extends Annotation>, Class<? extends Number>> entry : NUMBERS.entrySet()) {
            Class<? extends Number> number;
            Class<? extends Annotation> annotation = entry.getKey();
            if (!Range.maybeDefine(builder, key, value, method, annotation, number = entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private static <A extends Annotation, N extends Number> boolean maybeDefine(ModConfigSpec.Builder builder, String key, Object value, Method method, Class<A> annotation, Class<N> numberType) {
        if (method.isAnnotationPresent(annotation)) {
            A annotationInstance;
            if (!numberType.isAssignableFrom(value.getClass())) {
                throw new IllegalConfigOptionException("Type of %s is not a fitting numeric but has a range annotation".formatted(key));
            }
            A a = annotationInstance = method.getAnnotation(annotation);
            Objects.requireNonNull(a);
            A a2 = a;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Double.class, Long.class}, a2, n)) {
                case 0: {
                    Integer range = (Integer)a2;
                    builder.defineInRange(key, ((java.lang.Integer)value).intValue(), range.min(), range.max());
                    break;
                }
                case 1: {
                    Double range = (Double)a2;
                    builder.defineInRange(key, ((java.lang.Double)value).doubleValue(), range.min(), range.max());
                    break;
                }
                case 2: {
                    Long range = (Long)a2;
                    builder.defineInRange(key, ((java.lang.Long)value).longValue(), range.min(), range.max());
                    break;
                }
                default: {
                    throw new IllegalConfigOptionException("Unsupported numeric range annotation: %s".formatted(annotationInstance.annotationType().getName()));
                }
            }
            return true;
        }
        return false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Integer {
        public int min();

        public int max();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Double {
        public double min();

        public double max();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Long {
        public long min();

        public long max();
    }
}

