/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.config.ConfigCodecMap;
import net.swedz.tesseract.neoforge.config.ConfigHandler;
import net.swedz.tesseract.neoforge.config.ConfigInstance;
import net.swedz.tesseract.neoforge.config.ConfigManagerArg;
import net.swedz.tesseract.neoforge.config.DefaultValueConfigHandler;
import net.swedz.tesseract.neoforge.config.annotation.ConfigComment;
import net.swedz.tesseract.neoforge.config.annotation.ConfigKey;
import net.swedz.tesseract.neoforge.config.annotation.ConfigOrder;
import net.swedz.tesseract.neoforge.config.annotation.Range;
import net.swedz.tesseract.neoforge.config.annotation.SubSection;
import net.swedz.tesseract.neoforge.config.exception.IllegalConfigOptionException;
import net.swedz.tesseract.neoforge.helper.NamingConventionHelper;
import net.swedz.tesseract.neoforge.interfaceproxy.InterfaceProxyManager;
import net.swedz.tesseract.neoforge.serialization.TomlOps;

public final class ConfigManager
extends InterfaceProxyManager.WithArgument<ConfigHandler, ConfigManagerArg> {
    private final ConfigCodecMap codecs = new ConfigCodecMap();
    private boolean includeDefaultValueComments;

    public ConfigCodecMap codecs() {
        return this.codecs;
    }

    public ConfigManager includeDefaultValueComments() {
        this.includeDefaultValueComments = true;
        return this;
    }

    @Override
    protected ConfigManagerArg defaultManagerArgument() {
        return new ConfigManagerArg(Optional.empty(), "");
    }

    private <P> ModConfigSpec defaultConfigSpec(Class<P> proxyClass) {
        try {
            ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
            this.buildSpec(builder, proxyClass);
            return builder.build();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected <P> ConfigHandler createHandler(Class<P> proxyClass, ConfigManagerArg arg) {
        return new ConfigHandler(this, arg.spec().orElse(this.defaultConfigSpec(proxyClass)), arg.path());
    }

    protected <P> ConfigInstance<P> createInstance(Class<P> proxyClass, P proxy, ConfigHandler handler) {
        return new ConfigInstance<P>(proxyClass, proxy, handler);
    }

    public <P> ConfigInstance<P> build(Class<P> proxyClass) {
        return (ConfigInstance)super.build(proxyClass);
    }

    public <P> ConfigInstance<P> build(Class<P> proxyClass, ConfigManagerArg arg) {
        try {
            ConfigHandler handler = this.createHandler(proxyClass, arg);
            Object proxy = Proxy.newProxyInstance(proxyClass.getClassLoader(), new Class[]{proxyClass}, (InvocationHandler)handler);
            return this.createInstance(proxyClass, proxy, handler);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private <C> void buildSpec(ModConfigSpec.Builder builder, Class<C> configClass) throws Throwable {
        Assert.noneNull(builder, configClass);
        Object proxy = Proxy.newProxyInstance(configClass.getClassLoader(), new Class[]{configClass}, (InvocationHandler)new DefaultValueConfigHandler());
        ArrayList methods = Lists.newArrayList((Object[])configClass.getMethods());
        methods.sort((a, b) -> {
            if (a.isAnnotationPresent(ConfigOrder.class) && b.isAnnotationPresent(ConfigOrder.class)) {
                int orderA = a.getAnnotation(ConfigOrder.class).value();
                int orderB = b.getAnnotation(ConfigOrder.class).value();
                return Integer.compare(orderA, orderB);
            }
            return 0;
        });
        HashSet keys = Sets.newHashSet();
        for (Method method : methods) {
            String key;
            if (!method.isAnnotationPresent(ConfigKey.class)) continue;
            if (method.getParameterCount() != 0) {
                throw new IllegalConfigOptionException("Cannot have config method with parameters");
            }
            if (method.isAnnotationPresent(ConfigComment.class)) {
                String[] comments = method.getAnnotation(ConfigComment.class).value();
                builder.comment(comments);
            }
            if ((key = method.getAnnotation(ConfigKey.class).value()).isEmpty()) {
                key = NamingConventionHelper.fromCamelCaseToSnakeCase(method);
            }
            Class<?> type = method.getReturnType();
            if (!keys.add(key)) {
                throw new IllegalConfigOptionException("Duplicate config key: %s".formatted(key));
            }
            if (method.isAnnotationPresent(SubSection.class)) {
                builder.push(key);
                this.buildSpec(builder, type);
                builder.pop();
                continue;
            }
            if (method.isDefault()) {
                Object defaultValue = InvocationHandler.invokeDefault(proxy, method, new Object[0]);
                this.defineValue(method, builder, key, defaultValue);
                continue;
            }
            throw new IllegalConfigOptionException("Cannot retrieve default value from method %s".formatted(method.getName()));
        }
    }

    private void defineValue(Method method, ModConfigSpec.Builder builder, String key, Object defaultValue) throws Throwable {
        Class<?> type = method.getReturnType();
        if (this.codecs.has(type)) {
            Codec<?> codec = this.codecs.get(type);
            Object value = codec.encodeStart((DynamicOps)TomlOps.INSTANCE, defaultValue).getOrThrow(error -> new IllegalConfigOptionException("Unable to encode default value %s: %s".formatted(defaultValue, error)));
            builder.define(key, value, currentValue -> codec.parse((DynamicOps)TomlOps.INSTANCE, currentValue).isSuccess());
        } else {
            Object value;
            if (this.includeDefaultValueComments) {
                builder.comment("Default: " + String.valueOf(defaultValue));
            }
            if (Range.maybeDefine(builder, key, value = defaultValue, method)) {
                return;
            }
            if (value instanceof Enum) {
                Enum enumValue = (Enum)value;
                builder.defineEnum(key, enumValue);
                return;
            }
            builder.define(key, value);
        }
    }
}

