/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.machine.builder;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.compat.rei.machines.SteamMode;
import aztech.modern_industrialization.definition.FluidDefinition;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.ElectricCraftingMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.SteamCraftingMachineBlockEntity;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.init.SingleBlockCraftingMachines;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import java.util.function.Consumer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.compat.mi.hack.HackedMachineRegistrationHelper;
import net.swedz.tesseract.neoforge.compat.mi.hook.MIHook;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.MachineBuiltinModelBuilder;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.MachineGuiConfiguration;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.MachineWithGuiBuilder;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.function.MachineGuiConfigurator;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.slots.MachineSlotConfiguration;

public final class SingleBlockCraftingMachineBuilder
extends MachineWithGuiBuilder<SingleBlockCraftingMachineBuilder> {
    private final MachineRecipeType recipeType;
    private int tiers;
    private int steamX = 12;
    private int steamY = 35;
    private SingleBlockCraftingMachines.Config extraConfig = new SingleBlockCraftingMachines.Config();

    SingleBlockCraftingMachineBuilder(MIHook hook, String name, String englishName, MachineRecipeType recipeType) {
        super(hook, name, englishName);
        Assert.notNull(recipeType);
        this.recipeType = recipeType;
    }

    @Override
    public SingleBlockCraftingMachineBuilder builtinModel(MachineCasing casing, String overlayFolder, Consumer<MachineBuiltinModelBuilder> builder) {
        return (SingleBlockCraftingMachineBuilder)super.builtinModel(casing, overlayFolder, (MachineBuiltinModelBuilder b) -> {
            b.front().active();
            if (builder != null) {
                builder.accept((MachineBuiltinModelBuilder)b);
            }
        });
    }

    public SingleBlockCraftingMachineBuilder builtinModel(String overlayFolder, Consumer<MachineBuiltinModelBuilder> builder) {
        return this.builtinModel((MachineCasing)null, overlayFolder, (Consumer)builder);
    }

    public SingleBlockCraftingMachineBuilder builtinModel(String overlayFolder) {
        return this.builtinModel(overlayFolder, null);
    }

    public SingleBlockCraftingMachineBuilder bronze() {
        this.tiers |= 1;
        return this;
    }

    public SingleBlockCraftingMachineBuilder steel() {
        this.tiers |= 2;
        return this;
    }

    public SingleBlockCraftingMachineBuilder electric() {
        this.tiers |= 4;
        return this;
    }

    public SingleBlockCraftingMachineBuilder steamSlotPosition(int x, int y) {
        this.steamX = x;
        this.steamY = y;
        return this;
    }

    public SingleBlockCraftingMachineBuilder gui(SteamMode steamMode, MachineGuiConfigurator builder) {
        return (SingleBlockCraftingMachineBuilder)this.gui(false, steamMode, this.recipeType, builder);
    }

    public SingleBlockCraftingMachineBuilder extra(Consumer<SingleBlockCraftingMachines.Config> builder) {
        builder.accept(this.extraConfig);
        return this;
    }

    private static MachineCasing getCasing(MachineTier tier) {
        return switch (tier) {
            case MachineTier.BRONZE -> MachineCasings.BRONZE;
            case MachineTier.STEEL -> MachineCasings.STEEL;
            case MachineTier.LV -> CableTier.LV.casing;
            default -> throw new RuntimeException("Invalid tier: " + String.valueOf(tier));
        };
    }

    @Override
    protected void internalRegister() {
        Assert.that(this.tiers != 0, "At least one tier must be selected");
        Assert.notNull((Object)this.gui, "GUI must be configured");
        Assert.notNull((Object)this.gui.getProgressBar(), "Progress bar must be configured");
        MachineSlotConfiguration.AllSlotPositions slotPositions = this.gui.getSlots().toSlotPositions();
        for (int index = 0; index < 2; ++index) {
            if (index == 0 && (this.tiers & 1) == 0 || index == 1 && (this.tiers & 2) == 0) continue;
            MachineTier tier = index == 0 ? MachineTier.BRONZE : MachineTier.STEEL;
            String prefix = index == 0 ? "bronze" : "steel";
            String englishPrefix = index == 0 ? "Bronze " : "Steel ";
            int steamBuckets = index == 0 ? 2 : 4;
            String id = prefix + "_" + this.name;
            MachineGuiParameters guiParams = this.gui.createGuiParams(this.hook.id(id));
            MachineGuiConfiguration steamGui = this.gui.copy().inventoryOnlySlots(s -> s.fluidInput(this.steamX, this.steamY, () -> ((FluidDefinition)MIFluids.STEAM).asFluid(), steamBuckets));
            HackedMachineRegistrationHelper.registerMachine(this.hook, englishPrefix + this.englishName, id, this.blockFactory, holder -> this.holderModifiers.forEach(modifier -> modifier.modify(holder)), properties -> {
                if (this.defaultBlockProperties) {
                    HackedMachineRegistrationHelper.applyDefaultMachineProperties(properties);
                }
                this.propertiesModifiers.forEach(modifier -> modifier.modify(properties));
            }, this.defaultMineableTags, bet -> new SteamCraftingMachineBlockEntity(bet, this.recipeType, steamGui.buildInventory(), guiParams, steamGui.getProgressBar(), tier, this.extraConfig.steamOverclockCatalysts), bet -> {
                if (slotPositions.hasItems()) {
                    MachineBlockEntity.registerItemApi((BlockEntityType)bet);
                }
                MachineBlockEntity.registerFluidApi((BlockEntityType)bet);
            });
            if (this.builtinModel == null) continue;
            this.builtinModel.build(this.hook, id, SingleBlockCraftingMachineBuilder.getCasing(tier));
        }
        if ((this.tiers & 4) > 0) {
            Assert.notNull((Object)this.gui.getEnergyBar(), "Energy bar must be configured");
            Assert.notNull((Object)this.gui.getEfficiencyBar(), "Efficiency bar must be configured");
            Object id = this.tiers == 4 ? this.name : "electric_" + this.name;
            MachineGuiParameters guiParams = this.gui.createGuiParams(this.hook.id((String)id));
            Object electricEnglishName = this.englishName;
            if ((this.tiers & 1) > 0 | (this.tiers & 2) > 0) {
                electricEnglishName = "Electric " + this.englishName;
            }
            HackedMachineRegistrationHelper.registerMachine(this.hook, (String)electricEnglishName, (String)id, this.blockFactory, holder -> this.holderModifiers.forEach(modifier -> modifier.modify(holder)), properties -> {
                if (this.defaultBlockProperties) {
                    HackedMachineRegistrationHelper.applyDefaultMachineProperties(properties);
                }
                this.propertiesModifiers.forEach(modifier -> modifier.modify(properties));
            }, this.defaultMineableTags, bet -> new ElectricCraftingMachineBlockEntity(bet, this.recipeType, this.gui.buildInventory(), guiParams, this.gui.getEnergyBar(), this.gui.getProgressBar(), this.gui.getEfficiencyBar(), MachineTier.LV, 3200L), bet -> {
                ElectricCraftingMachineBlockEntity.registerEnergyApi((BlockEntityType)bet);
                if (slotPositions.hasItems()) {
                    MachineBlockEntity.registerItemApi((BlockEntityType)bet);
                }
                if (slotPositions.hasFluids()) {
                    MachineBlockEntity.registerFluidApi((BlockEntityType)bet);
                }
            });
            if (this.builtinModel != null) {
                this.builtinModel.build(this.hook, (String)id, SingleBlockCraftingMachineBuilder.getCasing(MachineTier.LV));
            }
        }
        this.gui.registerRecipeCategory(this.hook, this.name, this.englishName, this.tiers);
    }
}

