/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.helper;

import aztech.modern_industrialization.compat.almostunified.AlmostUnifiedFacade;
import aztech.modern_industrialization.inventory.AbstractConfigurableStack;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.stats.PlayerStatistics;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.ModularCrafterAccessBehavior;

public final class CrafterComponentHelper {
    private static boolean takeItemInputs(MachineRecipe recipe, boolean simulate, CommonBehavior behavior, CrafterComponent.Inventory inventory, int multiplier) {
        List baseList = inventory.getItemInputs();
        List stacks = simulate ? ConfigurableItemStack.copyList((List)baseList) : baseList;
        boolean ok = true;
        for (MachineRecipe.ItemInput input : recipe.itemInputs) {
            if (!simulate && input.probability() < 1.0f && ThreadLocalRandom.current().nextFloat() >= input.probability()) continue;
            int remainingAmount = input.amount() * (input.probability() == 0.0f ? 1 : multiplier);
            for (ConfigurableItemStack stack : stacks) {
                if (stack.getAmount() <= 0L || !((ItemVariant)stack.getResource()).test((Predicate)input.ingredient())) continue;
                int taken = Math.min((int)stack.getAmount(), remainingAmount);
                if (taken > 0 && !simulate) {
                    behavior.getStatsOrDummy().addUsedItems((ItemLike)((ItemVariant)stack.getResource()).getItem(), (long)taken);
                }
                stack.decrement((long)taken);
                if ((remainingAmount -= taken) != 0) continue;
                break;
            }
            if (remainingAmount <= 0) continue;
            ok = false;
        }
        return ok;
    }

    public static boolean takeItemInputs(MachineRecipe recipe, boolean simulate, CrafterComponent.Behavior behavior, CrafterComponent.Inventory inventory, int multiplier) {
        return CrafterComponentHelper.takeItemInputs(recipe, simulate, CommonBehavior.from(behavior), inventory, multiplier);
    }

    public static boolean takeItemInputs(MachineRecipe recipe, boolean simulate, ModularCrafterAccessBehavior behavior, CrafterComponent.Inventory inventory, int multiplier) {
        return CrafterComponentHelper.takeItemInputs(recipe, simulate, CommonBehavior.from(behavior), inventory, multiplier);
    }

    public static boolean fluidIngredientMatch(FluidVariant resource, FluidIngredient ingredient) {
        if (ingredient.isSimple()) {
            for (FluidStack stack : ingredient.getStacks()) {
                if (!resource.equals((Object)FluidVariant.of((Fluid)stack.getFluid()))) continue;
                return true;
            }
            return false;
        }
        return ingredient.test(resource.toStack(1));
    }

    private static boolean takeFluidInputs(MachineRecipe recipe, boolean simulate, CommonBehavior behavior, CrafterComponent.Inventory inventory, int multiplier) {
        List baseList = inventory.getFluidInputs();
        List stacks = simulate ? ConfigurableFluidStack.copyList((List)baseList) : baseList;
        boolean ok = true;
        for (MachineRecipe.FluidInput input : recipe.fluidInputs) {
            if (!simulate && input.probability() < 1.0f && ThreadLocalRandom.current().nextFloat() >= input.probability()) continue;
            long remainingAmount = input.amount() * (long)(input.probability() == 0.0f ? 1 : multiplier);
            for (ConfigurableFluidStack stack : stacks) {
                if (!CrafterComponentHelper.fluidIngredientMatch((FluidVariant)stack.getResource(), input.fluid())) continue;
                long taken = Math.min(remainingAmount, stack.getAmount());
                if (taken > 0L && !simulate) {
                    behavior.getStatsOrDummy().addUsedFluids(((FluidVariant)stack.getResource()).getFluid(), taken);
                }
                stack.decrement(taken);
                if ((remainingAmount -= taken) != 0L) continue;
                break;
            }
            if (remainingAmount <= 0L) continue;
            ok = false;
        }
        return ok;
    }

    public static boolean takeFluidInputs(MachineRecipe recipe, boolean simulate, CrafterComponent.Behavior behavior, CrafterComponent.Inventory inventory, int multiplier) {
        return CrafterComponentHelper.takeFluidInputs(recipe, simulate, CommonBehavior.from(behavior), inventory, multiplier);
    }

    public static boolean takeFluidInputs(MachineRecipe recipe, boolean simulate, ModularCrafterAccessBehavior behavior, CrafterComponent.Inventory inventory, int multiplier) {
        return CrafterComponentHelper.takeFluidInputs(recipe, simulate, CommonBehavior.from(behavior), inventory, multiplier);
    }

    private static boolean putItemOutputs(MachineRecipe recipe, boolean simulate, boolean toggleLock, CommonBehavior behavior, CrafterComponent.Inventory inventory, int multiplier) {
        List baseList = inventory.getItemOutputs();
        List stacks = simulate ? ConfigurableItemStack.copyList((List)baseList) : baseList;
        ArrayList<Integer> locksToToggle = new ArrayList<Integer>();
        ArrayList<Item> lockItems = new ArrayList<Item>();
        boolean ok = true;
        for (MachineRecipe.ItemOutput output : recipe.itemOutputs) {
            float randFloat;
            if (output.probability() < 1.0f && (simulate || (randFloat = ThreadLocalRandom.current().nextFloat()) > output.probability())) continue;
            int remainingAmount = output.amount() * multiplier;
            block1: for (int loopRun = 0; loopRun < 2; ++loopRun) {
                int stackId = 0;
                for (ConfigurableItemStack stack : stacks) {
                    ++stackId;
                    ItemVariant key = (ItemVariant)stack.getResource();
                    if (!key.equals((Object)output.variant()) && !key.isBlank()) continue;
                    int remainingCapacity = simulate || output.probability() < 1.0f ? (int)stack.getRemainingCapacityFor(output.variant()) : output.variant().getMaxStackSize() - (int)stack.getAmount();
                    int ins = Math.min(remainingAmount, remainingCapacity);
                    if (ins > 0) {
                        if (key.isBlank()) {
                            if ((stack.isMachineLocked() || stack.isPlayerLocked() || loopRun == 1) && stack.isValid(output.getStack())) {
                                stack.setAmount((long)ins);
                                stack.setKey((TransferVariant)output.variant());
                            } else {
                                ins = 0;
                            }
                        } else {
                            stack.increment((long)ins);
                        }
                    }
                    remainingAmount -= ins;
                    if (ins > 0) {
                        locksToToggle.add(stackId - 1);
                        lockItems.add(output.variant().getItem());
                        if (!simulate) {
                            behavior.getStatsOrDummy().addProducedItems((Level)behavior.getCrafterWorld(), (ItemLike)output.variant().getItem(), (long)ins);
                        }
                    }
                    if (remainingAmount != 0) continue;
                    continue block1;
                }
            }
            if (remainingAmount <= 0) continue;
            ok = false;
        }
        if (toggleLock) {
            for (int i = 0; i < locksToToggle.size(); ++i) {
                ((ConfigurableItemStack)baseList.get((Integer)locksToToggle.get(i))).enableMachineLock((Object)((Item)lockItems.get(i)));
            }
        }
        return ok;
    }

    public static boolean putItemOutputs(MachineRecipe recipe, boolean simulate, boolean toggleLock, CrafterComponent.Behavior behavior, CrafterComponent.Inventory inventory, int multiplier) {
        return CrafterComponentHelper.putItemOutputs(recipe, simulate, toggleLock, CommonBehavior.from(behavior), inventory, multiplier);
    }

    public static boolean putItemOutputs(MachineRecipe recipe, boolean simulate, boolean toggleLock, ModularCrafterAccessBehavior behavior, CrafterComponent.Inventory inventory, int multiplier) {
        return CrafterComponentHelper.putItemOutputs(recipe, simulate, toggleLock, CommonBehavior.from(behavior), inventory, multiplier);
    }

    private static boolean putFluidOutputs(MachineRecipe recipe, boolean simulate, boolean toggleLock, CommonBehavior behavior, CrafterComponent.Inventory inventory, int multiplier) {
        int i;
        List baseList = inventory.getFluidOutputs();
        List stacks = simulate ? ConfigurableFluidStack.copyList((List)baseList) : baseList;
        ArrayList<Integer> locksToToggle = new ArrayList<Integer>();
        ArrayList<Fluid> lockFluids = new ArrayList<Fluid>();
        boolean ok = true;
        block0: for (i = 0; i < Math.min(recipe.fluidOutputs.size(), behavior.getMaxFluidOutputs()); ++i) {
            float randFloat;
            MachineRecipe.FluidOutput output = (MachineRecipe.FluidOutput)recipe.fluidOutputs.get(i);
            if (output.probability() < 1.0f && (simulate || (randFloat = ThreadLocalRandom.current().nextFloat()) > output.probability())) continue;
            for (int tries = 0; tries < 2; ++tries) {
                for (int j = 0; j < stacks.size(); ++j) {
                    FluidVariant outputKey;
                    ConfigurableFluidStack stack = (ConfigurableFluidStack)stacks.get(j);
                    if (!stack.isResourceAllowedByLock((TransferVariant)(outputKey = FluidVariant.of((Fluid)output.fluid()))) || (tries != 1 || !stack.isResourceBlank()) && !((FluidVariant)stack.getResource()).equals((Object)outputKey)) continue;
                    long inserted = Math.min(output.amount() * (long)multiplier, stack.getRemainingSpace());
                    if (inserted > 0L) {
                        stack.setKey((TransferVariant)outputKey);
                        stack.increment(inserted);
                        locksToToggle.add(j);
                        lockFluids.add(output.fluid());
                        if (!simulate) {
                            behavior.getStatsOrDummy().addProducedFluids(output.fluid(), inserted);
                        }
                    }
                    if (inserted >= output.amount() * (long)multiplier) continue block0;
                    ok = false;
                    continue block0;
                }
                if (tries != 1) continue;
                ok = false;
            }
        }
        if (toggleLock) {
            for (i = 0; i < locksToToggle.size(); ++i) {
                ((ConfigurableFluidStack)baseList.get((Integer)locksToToggle.get(i))).enableMachineLock((Object)((Fluid)lockFluids.get(i)));
            }
        }
        return ok;
    }

    public static boolean putFluidOutputs(MachineRecipe recipe, boolean simulate, boolean toggleLock, CrafterComponent.Behavior behavior, CrafterComponent.Inventory inventory, int multiplier) {
        return CrafterComponentHelper.putFluidOutputs(recipe, simulate, toggleLock, CommonBehavior.from(behavior), inventory, multiplier);
    }

    public static boolean putFluidOutputs(MachineRecipe recipe, boolean simulate, boolean toggleLock, ModularCrafterAccessBehavior behavior, CrafterComponent.Inventory inventory, int multiplier) {
        return CrafterComponentHelper.putFluidOutputs(recipe, simulate, toggleLock, CommonBehavior.from(behavior), inventory, multiplier);
    }

    private static <T, K extends TransferVariant<T>, S extends AbstractConfigurableStack<T, K>> void handleLocking(List<S> stacks, com.google.common.base.Predicate<T> matchesRecipe, long requiredAmount, Supplier<T> lockTarget) {
        for (AbstractConfigurableStack stack : stacks) {
            if (stack.getLockedInstance() == null || !matchesRecipe.apply(stack.getLockedInstance()) || (requiredAmount -= stack.getTotalCapacityFor(stack.getLockedInstance())) > 0L) continue;
            return;
        }
        Object newLockedInstance = lockTarget.get();
        if (newLockedInstance == null) {
            return;
        }
        AbstractConfigurableStack.playerLockNoOverride((Object)newLockedInstance, (long)requiredAmount, stacks);
    }

    public static void lockRecipe(MachineRecipe recipe, Inventory playerInventory, CrafterComponent.Inventory inventory) {
        for (MachineRecipe.ItemInput input : recipe.itemInputs) {
            CrafterComponentHelper.handleLocking(inventory.getItemInputs(), item -> input.matches(new ItemStack((ItemLike)item)), input.amount(), () -> {
                Item targetItem;
                for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
                    ItemStack playerStack = playerInventory.getItem(i);
                    if (playerStack.isEmpty() || !input.matches(new ItemStack((ItemLike)playerStack.getItem()))) continue;
                    return playerStack.getItem();
                }
                List inputItems = input.getInputItems();
                if (!inputItems.isEmpty() && (targetItem = AlmostUnifiedFacade.INSTANCE.getTargetItem((ItemLike)inputItems.getFirst())) != null) {
                    return targetItem;
                }
                for (Item item : inputItems) {
                    ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
                    if (!id.getNamespace().equals("modern_industrialization")) continue;
                    return item;
                }
                if (inputItems.size() == 1) {
                    return (Item)inputItems.getFirst();
                }
                return null;
            });
        }
        for (MachineRecipe.ItemOutput output : recipe.itemOutputs) {
            CrafterComponentHelper.handleLocking(inventory.getItemOutputs(), item -> output.variant().isOf(item), output.amount(), () -> ((ItemVariant)output.variant()).getItem());
        }
        for (MachineRecipe.ItemInput input : recipe.fluidInputs) {
            CrafterComponentHelper.handleLocking(inventory.getFluidInputs(), arg_0 -> CrafterComponentHelper.lambda$lockRecipe$3((MachineRecipe.FluidInput)input, arg_0), input.amount(), () -> CrafterComponentHelper.lambda$lockRecipe$4(playerInventory, (MachineRecipe.FluidInput)input));
        }
        for (MachineRecipe.ItemOutput output : recipe.fluidOutputs) {
            CrafterComponentHelper.handleLocking(inventory.getFluidOutputs(), arg_0 -> CrafterComponentHelper.lambda$lockRecipe$5((MachineRecipe.FluidOutput)output, arg_0), output.amount(), () -> ((MachineRecipe.FluidOutput)output).fluid());
        }
        if (!recipe.itemInputs.isEmpty() || !recipe.itemOutputs.isEmpty()) {
            CrafterComponentHelper.lockAll(inventory.getItemInputs());
            CrafterComponentHelper.lockAll(inventory.getItemOutputs());
        }
        if (!recipe.fluidInputs.isEmpty() || !recipe.fluidOutputs.isEmpty()) {
            CrafterComponentHelper.lockAll(inventory.getFluidInputs());
            CrafterComponentHelper.lockAll(inventory.getFluidOutputs());
        }
    }

    public static void lockAll(List<? extends AbstractConfigurableStack<?, ?>> stacks) {
        for (AbstractConfigurableStack<?, ?> stack : stacks) {
            if (!stack.isEmpty() || stack.getLockedInstance() != null) continue;
            stack.togglePlayerLock();
        }
    }

    private static /* synthetic */ boolean lambda$lockRecipe$5(MachineRecipe.FluidOutput output, Fluid fluid) {
        return output.fluid() == fluid;
    }

    private static /* synthetic */ Fluid lambda$lockRecipe$4(Inventory playerInventory, MachineRecipe.FluidInput input) {
        for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
            FluidStack playerStack = FluidUtil.getFluidContained((ItemStack)playerInventory.getItem(i)).orElse(FluidStack.EMPTY);
            if (playerStack.isEmpty() || !input.fluid().test(new FluidStack(playerStack.getFluid(), 1))) continue;
            return playerStack.getFluid();
        }
        List inputFluids = input.getInputFluids();
        for (Fluid fluid : inputFluids) {
            ResourceLocation id = BuiltInRegistries.FLUID.getKey((Object)fluid);
            if (!id.getNamespace().equals("modern_industrialization")) continue;
            return fluid;
        }
        if (inputFluids.size() == 1) {
            return (Fluid)inputFluids.getFirst();
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$lockRecipe$3(MachineRecipe.FluidInput input, Fluid fluid) {
        return input.fluid().test(new FluidStack(fluid, 1));
    }

    private static interface CommonBehavior {
        public ServerLevel getCrafterWorld();

        public int getMaxFluidOutputs();

        public PlayerStatistics getStatsOrDummy();

        public static CommonBehavior from(final CrafterComponent.Behavior behavior) {
            return new CommonBehavior(){

                @Override
                public ServerLevel getCrafterWorld() {
                    return behavior.getCrafterWorld();
                }

                @Override
                public int getMaxFluidOutputs() {
                    return behavior.getMaxFluidOutputs();
                }

                @Override
                public PlayerStatistics getStatsOrDummy() {
                    return behavior.getStatsOrDummy();
                }
            };
        }

        public static CommonBehavior from(final ModularCrafterAccessBehavior behavior) {
            return new CommonBehavior(){

                @Override
                public ServerLevel getCrafterWorld() {
                    return behavior.getCrafterWorld();
                }

                @Override
                public int getMaxFluidOutputs() {
                    return behavior.getMaxFluidOutputs();
                }

                @Override
                public PlayerStatistics getStatsOrDummy() {
                    return behavior.getStatsOrDummy();
                }
            };
        }
    }
}

