/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import net.swedz.tesseract.neoforge.proxy.builtin.TesseractProxy;

public record WorldPos(ResourceKey<Level> dimension, BlockPos pos) {
    public static final MapCodec<WorldPos> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Level.RESOURCE_KEY_CODEC.fieldOf("dimension").forGetter(WorldPos::dimension), (App)BlockPos.CODEC.fieldOf("pos").forGetter(WorldPos::pos)).apply((Applicative)instance, WorldPos::new));
    public static final Codec<WorldPos> CODEC = MAP_CODEC.codec();
    public static final StreamCodec<ByteBuf, WorldPos> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), WorldPos::dimension, (StreamCodec)BlockPos.STREAM_CODEC, WorldPos::pos, WorldPos::new);

    public WorldPos {
        pos = pos.immutable();
    }

    public WorldPos(Level level, BlockPos pos) {
        this((ResourceKey<Level>)level.dimension(), pos);
    }

    public ServerLevel level() {
        TesseractProxy proxy = Proxies.get(TesseractProxy.class);
        if (!proxy.hasServer()) {
            throw new IllegalStateException("Cannot get level from world position on the client");
        }
        return proxy.getServer().getLevel(this.dimension);
    }

    public boolean isLoaded() {
        return this.level().isLoaded(this.pos);
    }

    public boolean isTicking() {
        ServerLevel level = this.level();
        return level.tickRateManager().runsNormally() && level.shouldTickBlocksAt(this.pos);
    }

    public boolean isSameDimension(WorldPos other) {
        return this.dimension.equals(other.dimension());
    }

    public double distanceSqr(WorldPos other) {
        if (!this.isSameDimension(other)) {
            throw new IllegalArgumentException("Mismatching dimensions in distance check");
        }
        return this.pos.distSqr((Vec3i)other.pos());
    }

    public int getX() {
        return this.pos.getX();
    }

    public int getY() {
        return this.pos.getY();
    }

    public int getZ() {
        return this.pos.getZ();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dimension.registry(), this.dimension.location(), this.pos);
    }
}

