/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester;

import appeng.api.networking.IGrid;
import appeng.menu.implementations.MenuTypeBuilder;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.network.RequesterSyncPacket;
import com.almostreliable.merequester.requester.RequesterBlockEntity;
import com.almostreliable.merequester.requester.abstraction.AbstractRequesterMenu;
import com.almostreliable.merequester.requester.abstraction.RequestTracker;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public final class RequesterMenu
extends AbstractRequesterMenu {
    public static final MenuType<RequesterMenu> TYPE = MenuTypeBuilder.create(RequesterMenu::new, RequesterBlockEntity.class).buildUnregistered(Utils.getRL("requester"));
    @Nullable
    private RequestTracker requestTracker;

    private RequesterMenu(int id, Inventory playerInventory, RequesterBlockEntity host) {
        super(TYPE, id, playerInventory, host);
    }

    public void broadcastChanges() {
        if (this.isClientSide()) {
            return;
        }
        super.broadcastChanges();
        if (this.requestTracker == null) {
            this.sendFullUpdate(null);
        } else {
            this.sendPartialUpdate();
        }
    }

    protected int transferStackToMenu(ItemStack stack) {
        assert (this.requestTracker != null);
        int firstAvailable = this.requestTracker.getServer().firstAvailableIndex();
        if (firstAvailable != -1) {
            this.requestTracker.getServer().insertItem(firstAvailable, stack, false);
        }
        return 0;
    }

    @Override
    protected void sendFullUpdate(@Nullable IGrid grid) {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)RequesterSyncPacket.createClearData(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.requestTracker = this.createTracker((RequesterBlockEntity)this.getBlockEntity());
        this.syncRequestTrackerFull(this.requestTracker);
    }

    @Override
    protected void sendPartialUpdate() {
        assert (this.requestTracker != null);
        this.syncRequestTrackerPartial(this.requestTracker);
    }

    @Override
    @Nullable
    protected RequestTracker getRequestTracker(long id) {
        return this.requestTracker;
    }
}

