/*
 * Decompiled with CFR 0.152.
 */
package nolijium.mixinextras.injector.wrapoperation;

import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import nolijium.mixinextras.injector.StackExtension;
import nolijium.mixinextras.injector.wrapoperation.Operation;
import nolijium.mixinextras.injector.wrapoperation.WrapOperation;
import nolijium.mixinextras.lib.apache.commons.ArrayUtils;
import nolijium.mixinextras.service.MixinExtrasService;
import nolijium.mixinextras.utils.ASMUtils;
import nolijium.mixinextras.utils.CompatibilityHelper;
import nolijium.mixinextras.utils.InjectorUtils;
import nolijium.mixinextras.utils.OperationUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;

class WrapOperationInjector
extends Injector {
    private static final String NPE = Type.getInternalName(NullPointerException.class);
    private final Type operationType;

    public WrapOperationInjector(InjectionInfo injectionInfo) {
        super(injectionInfo, "@WrapOperation");
        this.operationType = MixinExtrasService.getInstance().changePackage(Operation.class, Type.getType((String)CompatibilityHelper.getAnnotation((InjectionInfo)this.info).desc), WrapOperation.class);
    }

    protected void inject(Target target, InjectionNodes.InjectionNode injectionNode) {
        this.checkTargetModifiers(target, false);
        this.checkNode(target, injectionNode);
        this.wrapOperation(target, injectionNode);
    }

    private void checkNode(Target target, InjectionNodes.InjectionNode injectionNode) {
        AbstractInsnNode abstractInsnNode = injectionNode.getOriginalTarget();
        if ((injectionNode = injectionNode.getCurrentTarget()) instanceof MethodInsnNode) {
            if (((MethodInsnNode)injectionNode).name.equals("<init>")) {
                throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is trying to target an <init> call in %s in %s! If this is an instantiation, target the NEW instead.", new Object[]{this.annotationType, target, this}));
            }
            return;
        }
        if (!(injectionNode instanceof FieldInsnNode) && abstractInsnNode.getOpcode() != 193 && abstractInsnNode.getOpcode() != 187) {
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is targeting an invalid insn in %s in %s", new Object[]{this.annotationType, target, this}));
        }
    }

    private void wrapOperation(Target target, InjectionNodes.InjectionNode injectionNode) {
        StackExtension stackExtension = new StackExtension(target);
        AbstractInsnNode abstractInsnNode = injectionNode.getCurrentTarget();
        InsnList insnList = new InsnList();
        boolean bl = abstractInsnNode.getOpcode() == 187;
        boolean bl2 = InjectorUtils.isDupedNew(injectionNode);
        if (bl) {
            injectionNode.decorate("mixinextras_wrappedOperation", (Object)Boolean.TRUE);
            Target target2 = target;
            injectionNode = target2.addInjectionNode((AbstractInsnNode)ASMUtils.findInitNodeFor(target2, (TypeInsnNode)abstractInsnNode));
        }
        AbstractInsnNode abstractInsnNode2 = this.getCurrentArgTypes(injectionNode);
        Type type = this.getReturnType(injectionNode);
        abstractInsnNode2 = this.invokeHandler(target, injectionNode, (Type[])abstractInsnNode2, type, insnList, stackExtension);
        if (bl2) {
            target.insns.set(abstractInsnNode, (AbstractInsnNode)new InsnNode(1));
            stackExtension.extra(1);
            insnList.add((AbstractInsnNode)new InsnNode(91));
            insnList.add((AbstractInsnNode)new InsnNode(87));
            insnList.add((AbstractInsnNode)new InsnNode(87));
            insnList.add((AbstractInsnNode)new InsnNode(87));
        } else if (bl) {
            target.insns.set(abstractInsnNode, (AbstractInsnNode)new InsnNode(0));
            insnList.add((AbstractInsnNode)new InsnNode(87));
        }
        stackExtension = injectionNode.getCurrentTarget();
        target.wrapNode((AbstractInsnNode)stackExtension, abstractInsnNode2, insnList, new InsnList());
        if (bl) {
            target.getInjectionNode(abstractInsnNode).replace(abstractInsnNode2);
        }
        injectionNode.decorate("mixinextras_wrappedOperation", (Object)Boolean.TRUE);
        target.insns.remove((AbstractInsnNode)stackExtension);
    }

    private AbstractInsnNode invokeHandler(Target target, InjectionNodes.InjectionNode injectionNode, Type[] typeArray, Type type, InsnList insnList, StackExtension stackExtension) {
        Injector.InjectorData injectorData = new Injector.InjectorData(target, "operation wrapper");
        boolean bl = injectionNode.isReplaced() && injectionNode.getCurrentTarget().getOpcode() != 184;
        if (bl) {
            typeArray = (Type[])ArrayUtils.remove(typeArray, 0);
        }
        Object[] objectArray = this.getOriginalArgTypes(injectionNode);
        this.validateParams(injectorData, type, (Type[])ArrayUtils.add(objectArray, this.operationType));
        int[] nArray = this.storeArgs(target, typeArray, insnList, 0);
        if (bl) {
            insnList.add((AbstractInsnNode)new InsnNode(87));
        }
        if (!this.isStatic) {
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        WrapOperationInjector wrapOperationInjector = this;
        wrapOperationInjector.pushArgs(wrapOperationInjector.methodArgs, insnList, nArray, 0, objectArray.length);
        if (bl) {
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        this.pushArgs(typeArray, insnList, nArray, objectArray.length, nArray.length);
        this.makeOperation(target, (Type[])objectArray, type, injectionNode, insnList, bl, (Type[])ArrayUtils.subarray(typeArray, objectArray.length, typeArray.length));
        if (injectorData.captureTargetArgs > 0) {
            this.pushArgs(target.arguments, insnList, target.getArgIndices(), 0, injectorData.captureTargetArgs);
        }
        stackExtension.receiver(this.isStatic);
        stackExtension.extra(1);
        stackExtension.capturedArgs(target.arguments, injectorData.captureTargetArgs);
        target = super.invokeHandler(insnList);
        if (InjectorUtils.isDynamicInstanceofRedirect(injectionNode)) {
            insnList.add((AbstractInsnNode)new InsnNode(95));
            insnList.add((AbstractInsnNode)new InsnNode(87));
        }
        return target;
    }

    private void makeOperation(Target target, Type[] typeArray, Type type, InjectionNodes.InjectionNode injectionNode, InsnList insnList, boolean bl, Type[] typeArray2) {
        OperationUtils.makeOperation(typeArray, type, insnList, bl, typeArray2, this.classNode, this.operationType, this.getName(injectionNode.getCurrentTarget()), (n2, consumer) -> this.copyNode(injectionNode, n2, target, consumer));
    }

    private InsnList copyNode(InjectionNodes.InjectionNode injectionNode, int n2, Target target, Consumer consumer) {
        MethodInsnNode methodInsnNode;
        AbstractInsnNode abstractInsnNode2 = injectionNode.getCurrentTarget();
        InsnList insnList = new InsnList();
        if (abstractInsnNode2 instanceof MethodInsnNode) {
            methodInsnNode = (MethodInsnNode)abstractInsnNode2;
            if (methodInsnNode.name.equals("<init>")) {
                insnList.add((AbstractInsnNode)new TypeInsnNode(187, methodInsnNode.owner));
                insnList.add((AbstractInsnNode)new InsnNode(89));
            }
        }
        consumer.accept(insnList);
        insnList.add(abstractInsnNode2.clone(Collections.emptyMap()));
        if (InjectorUtils.isDynamicInstanceofRedirect(injectionNode)) {
            insnList.add((AbstractInsnNode)new VarInsnNode(25, n2));
            insnList.add((AbstractInsnNode)new InsnNode(3));
            insnList.add((AbstractInsnNode)new InsnNode(50));
            insnList.add((AbstractInsnNode)new InsnNode(95));
            this.checkAndMoveNodes(target.insns, insnList, abstractInsnNode2, abstractInsnNode -> abstractInsnNode.getOpcode() == 89, abstractInsnNode -> abstractInsnNode.getOpcode() == 199, abstractInsnNode -> abstractInsnNode.getOpcode() == 187 && ((TypeInsnNode)abstractInsnNode).desc.equals(NPE), abstractInsnNode -> abstractInsnNode.getOpcode() == 89, abstractInsnNode -> abstractInsnNode instanceof LdcInsnNode && ((LdcInsnNode)abstractInsnNode).cst instanceof String, abstractInsnNode -> abstractInsnNode.getOpcode() == 183 && ((MethodInsnNode)abstractInsnNode).owner.equals(NPE), abstractInsnNode -> abstractInsnNode.getOpcode() == 191, abstractInsnNode -> abstractInsnNode instanceof LabelNode, abstractInsnNode -> abstractInsnNode.getOpcode() == 95, abstractInsnNode -> abstractInsnNode.getOpcode() == 89, abstractInsnNode -> abstractInsnNode.getOpcode() == 198, abstractInsnNode -> abstractInsnNode.getOpcode() == 182 && ((MethodInsnNode)abstractInsnNode).name.equals("getClass"), abstractInsnNode -> abstractInsnNode.getOpcode() == 182 && ((MethodInsnNode)abstractInsnNode).name.equals("isAssignableFrom"), abstractInsnNode -> abstractInsnNode.getOpcode() == 167, abstractInsnNode -> abstractInsnNode instanceof LabelNode, abstractInsnNode -> abstractInsnNode.getOpcode() == 87, abstractInsnNode -> abstractInsnNode.getOpcode() == 87, abstractInsnNode -> abstractInsnNode.getOpcode() == 3, abstractInsnNode -> abstractInsnNode instanceof LabelNode);
        }
        if (InjectorUtils.isDupedFactoryRedirect(injectionNode) && (methodInsnNode = InjectorUtils.findFactoryRedirectThrowString(target, abstractInsnNode2)) != null) {
            this.checkAndMoveNodes(target.insns, insnList, abstractInsnNode2, abstractInsnNode -> abstractInsnNode.getOpcode() == 89, abstractInsnNode -> abstractInsnNode.getOpcode() == 199, abstractInsnNode -> abstractInsnNode.getOpcode() == 187 && ((TypeInsnNode)abstractInsnNode).desc.equals(NPE), abstractInsnNode -> abstractInsnNode.getOpcode() == 89, arg_0 -> WrapOperationInjector.lambda$copyNode$24((AbstractInsnNode)methodInsnNode, arg_0), abstractInsnNode -> abstractInsnNode.getOpcode() == 183 && ((MethodInsnNode)abstractInsnNode).name.equals("<init>"), abstractInsnNode -> abstractInsnNode.getOpcode() == 191, abstractInsnNode -> abstractInsnNode instanceof LabelNode);
        }
        return insnList;
    }

    private final void checkAndMoveNodes(InsnList insnList, InsnList insnList2, AbstractInsnNode abstractInsnNode, Predicate ... predicateArray) {
        abstractInsnNode = abstractInsnNode.getNext();
        int n2 = predicateArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!predicateArray[i2].test(abstractInsnNode)) {
                throw new AssertionError((Object)"Failed assertion when wrapping instructions. Please inform LlamaLad7!");
            }
            AbstractInsnNode abstractInsnNode2 = abstractInsnNode;
            while ((abstractInsnNode = abstractInsnNode.getNext()) instanceof FrameNode) {
            }
            insnList.remove(abstractInsnNode2);
            insnList2.add(abstractInsnNode2);
        }
    }

    private Type getReturnType(InjectionNodes.InjectionNode injectionNode) {
        AbstractInsnNode abstractInsnNode = injectionNode.getOriginalTarget();
        injectionNode = injectionNode.getCurrentTarget();
        if (abstractInsnNode.getOpcode() == 193) {
            return Type.BOOLEAN_TYPE;
        }
        if (injectionNode instanceof MethodInsnNode) {
            injectionNode = (MethodInsnNode)injectionNode;
            if (injectionNode.name.equals("<init>")) {
                return Type.getObjectType((String)injectionNode.owner);
            }
            return Type.getReturnType((String)injectionNode.desc);
        }
        if (injectionNode instanceof FieldInsnNode) {
            if ((injectionNode = (FieldInsnNode)injectionNode).getOpcode() == 180 || injectionNode.getOpcode() == 178) {
                return Type.getType((String)injectionNode.desc);
            }
            return Type.VOID_TYPE;
        }
        throw new UnsupportedOperationException();
    }

    private Type[] getOriginalArgTypes(InjectionNodes.InjectionNode injectionNode) {
        if (injectionNode.hasDecoration("mixinextras_newArgTypes")) {
            return (Type[])injectionNode.getDecoration("mixinextras_newArgTypes");
        }
        return this.getEffectiveArgTypes(injectionNode.getOriginalTarget());
    }

    private Type[] getCurrentArgTypes(InjectionNodes.InjectionNode injectionNode) {
        return this.getEffectiveArgTypes(injectionNode.getCurrentTarget());
    }

    private Type[] getEffectiveArgTypes(AbstractInsnNode objectArray) {
        if (objectArray instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)objectArray;
            objectArray = Type.getArgumentTypes((String)methodInsnNode.desc);
            if (methodInsnNode.name.equals("<init>")) {
                return objectArray;
            }
            switch (methodInsnNode.getOpcode()) {
                case 184: {
                    break;
                }
                case 183: {
                    objectArray = (Type[])ArrayUtils.add(objectArray, 0, Type.getObjectType((String)this.classNode.name));
                    break;
                }
                default: {
                    objectArray = (Type[])ArrayUtils.add(objectArray, 0, Type.getObjectType((String)methodInsnNode.owner));
                }
            }
            return objectArray;
        }
        if (objectArray instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)objectArray;
            switch (fieldInsnNode.getOpcode()) {
                case 180: {
                    return new Type[]{Type.getObjectType((String)fieldInsnNode.owner)};
                }
                case 181: {
                    return new Type[]{Type.getObjectType((String)fieldInsnNode.owner), Type.getType((String)fieldInsnNode.desc)};
                }
                case 178: {
                    return new Type[0];
                }
                case 179: {
                    return new Type[]{Type.getType((String)fieldInsnNode.desc)};
                }
            }
        }
        if (objectArray.getOpcode() == 193) {
            return new Type[]{Type.getType(Object.class)};
        }
        throw new UnsupportedOperationException();
    }

    private String getName(AbstractInsnNode object) {
        if (object instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)object;
            if (methodInsnNode.name.equals("<init>")) {
                Object object2 = object = methodInsnNode.owner;
                return "new" + ((String)object2).substring(((String)object2).lastIndexOf(47) + 1);
            }
            return ((MethodInsnNode)object).name;
        }
        if (object instanceof FieldInsnNode) {
            return ((FieldInsnNode)object).name;
        }
        if (object.getOpcode() == 193) {
            String string;
            String string2 = string = ((TypeInsnNode)object).desc;
            return "instanceof" + string2.substring(string2.lastIndexOf(47) + 1);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ boolean lambda$copyNode$24(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        return abstractInsnNode2 == abstractInsnNode;
    }
}

