/*
 * Decompiled with CFR 0.152.
 */
package nolijium.mixinextras.injector;

import nolijium.mixinextras.injector.StackExtension;
import nolijium.mixinextras.lib.apache.commons.ArrayUtils;
import nolijium.mixinextras.utils.CompatibilityHelper;
import nolijium.mixinextras.utils.InjectorUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;

public class ModifyReceiverInjector
extends Injector {
    public ModifyReceiverInjector(InjectionInfo injectionInfo) {
        super(injectionInfo, "@ModifyReceiver");
    }

    protected void inject(Target target, InjectionNodes.InjectionNode injectionNode) {
        this.checkTargetIsValid(target, injectionNode);
        this.checkTargetModifiers(target, false);
        this.modifyReceiverOfTarget(target, injectionNode);
    }

    private void checkTargetIsValid(Target target, InjectionNodes.InjectionNode injectionNode) {
        switch (injectionNode.getOriginalTarget().getOpcode()) {
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: {
                return;
            }
        }
        throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is targeting an invalid insn in %s in %s", new Object[]{this.annotationType, target, this}));
    }

    private void modifyReceiverOfTarget(Target target, InjectionNodes.InjectionNode injectionNode) {
        Type[] typeArray = injectionNode.getCurrentTarget();
        Type[] typeArray2 = this.getEffectiveArgTypes(injectionNode.getOriginalTarget());
        typeArray = this.getEffectiveArgTypes((AbstractInsnNode)typeArray);
        InsnList insnList = new InsnList();
        boolean bl = InjectorUtils.isVirtualRedirect(injectionNode);
        this.injectReceiverModifier(target, typeArray2, typeArray, bl, insnList);
        target.insertBefore(injectionNode, insnList);
    }

    private void injectReceiverModifier(Target target, Type[] object, Type[] typeArray, boolean bl, InsnList insnList) {
        Injector.InjectorData injectorData = new Injector.InjectorData(target, "receiver modifier");
        this.validateParams(injectorData, object[0], (Type[])object);
        object = new StackExtension(target);
        int[] nArray = this.storeArgs(target, typeArray, insnList, 0);
        int[] nArray2 = ArrayUtils.addAll(nArray, target.getArgIndices());
        if (bl) {
            nArray2 = ArrayUtils.remove(nArray2, 0);
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        ((StackExtension)object).receiver(this.isStatic);
        ((StackExtension)object).capturedArgs(target.arguments, injectorData.captureTargetArgs);
        ModifyReceiverInjector modifyReceiverInjector = this;
        modifyReceiverInjector.invokeHandlerWithArgs(modifyReceiverInjector.methodArgs, insnList, nArray2);
        this.pushArgs(typeArray, insnList, nArray, bl ? 2 : 1, nArray.length);
    }

    private Type[] getEffectiveArgTypes(AbstractInsnNode abstractInsnNode) {
        switch (abstractInsnNode.getOpcode()) {
            case 182: 
            case 185: {
                abstractInsnNode = (MethodInsnNode)abstractInsnNode;
                return (Type[])ArrayUtils.addAll(new Type[]{Type.getObjectType((String)abstractInsnNode.owner)}, Type.getArgumentTypes((String)abstractInsnNode.desc));
            }
            case 183: {
                abstractInsnNode = (MethodInsnNode)abstractInsnNode;
                return (Type[])ArrayUtils.addAll(new Type[]{Type.getObjectType((String)this.classNode.name)}, Type.getArgumentTypes((String)abstractInsnNode.desc));
            }
            case 184: {
                return Type.getArgumentTypes((String)((MethodInsnNode)abstractInsnNode).desc);
            }
            case 180: {
                abstractInsnNode = (FieldInsnNode)abstractInsnNode;
                return new Type[]{Type.getObjectType((String)abstractInsnNode.owner)};
            }
            case 181: {
                abstractInsnNode = (FieldInsnNode)abstractInsnNode;
                return new Type[]{Type.getObjectType((String)abstractInsnNode.owner), Type.getType((String)abstractInsnNode.desc)};
            }
        }
        throw new UnsupportedOperationException();
    }
}

